/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;
import org.eclipse.app4mc.visualization.util.svg.AbstractDiagram;

public class PlantUmlDiagram
extends AbstractDiagram {
    private String svg = null;

    public String getDiagramSVG() {
        return this.svg;
    }

    @Override
    public void resetDiagramData() {
        super.resetDiagramData();
        this.svg = null;
    }

    public String renderToSvg() throws IOException {
        String source = this.getDiagramText();
        if (source == null || source.isEmpty()) {
            return null;
        }
        SourceStringReader reader = new SourceStringReader(source);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DiagramDescription desc = reader.outputImage((OutputStream)baos, new FileFormatOption(FileFormat.SVG));
        if (desc != null && !desc.getDescription().isEmpty()) {
            this.svg = baos.toString(StandardCharsets.UTF_8.name());
            return this.svg;
        }
        return null;
    }
}

