/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.predefined;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.ParameterType;
import org.eclipse.app4mc.amalthea.model.SchedulerDefinition;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.predefined.StandardSchedulers;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.emf.common.notify.Notifier;

public class AmaltheaTemplates {
    private AmaltheaTemplates() {
        throw new IllegalStateException("Utility class");
    }

    public static SchedulerDefinition addStandardSchedulerDefinition(OSModel os, StandardSchedulers.Algorithm standardScheduler) {
        if (os == null || standardScheduler == null) {
            return null;
        }
        String schedulerName = standardScheduler.getAlgorithmName();
        if (schedulerName == null) {
            return null;
        }
        Set<SchedulerDefinition> existingSchedulerDefs = AmaltheaIndex.getElements((Notifier)os, schedulerName, SchedulerDefinition.class);
        Map existingParameterDefs = AmaltheaIndex.getElements((Notifier)os, SchedulingParameterDefinition.class).stream().collect(Collectors.toMap(INamed::getName, Function.identity()));
        if (existingSchedulerDefs.isEmpty()) {
            SchedulingParameterDefinition paramDef;
            SchedulerDefinition schedulerDef = AmaltheaFactory.eINSTANCE.createSchedulerDefinition();
            schedulerDef.setName(standardScheduler.getAlgorithmName());
            schedulerDef.setDescription(standardScheduler.getDescription());
            schedulerDef.setHasExactlyOneChild(standardScheduler.hasExactlyOneChild());
            schedulerDef.setPassesParametersUpwards(standardScheduler.passesParametersUpwards());
            schedulerDef.setRequiresParentScheduler(standardScheduler.requiresParentScheduler());
            os.getSchedulerDefinitions().add((Object)schedulerDef);
            for (StandardSchedulers.Parameter stdParam : standardScheduler.getAlgorithmParameters()) {
                paramDef = (SchedulingParameterDefinition)existingParameterDefs.get(stdParam.getParameterName());
                if (paramDef == null) {
                    paramDef = AmaltheaTemplates.addNewParameterDefinition(os, stdParam);
                }
                schedulerDef.getAlgorithmParameters().add((Object)paramDef);
            }
            for (StandardSchedulers.Parameter stdParam : standardScheduler.getProcessParameters()) {
                paramDef = (SchedulingParameterDefinition)existingParameterDefs.get(stdParam.getParameterName());
                if (paramDef == null) {
                    paramDef = AmaltheaTemplates.addNewParameterDefinition(os, stdParam);
                }
                schedulerDef.getProcessParameters().add((Object)paramDef);
            }
            return schedulerDef;
        }
        return existingSchedulerDefs.iterator().next();
    }

    public static SchedulingParameterDefinition addStandardSchedulingParameterDefinition(OSModel os, StandardSchedulers.Parameter standardParameter) {
        if (os == null || standardParameter == null) {
            return null;
        }
        String parameterName = standardParameter.getParameterName();
        if (parameterName == null) {
            return null;
        }
        Set<SchedulingParameterDefinition> existingParameterDefs = AmaltheaIndex.getElements((Notifier)os, parameterName, SchedulingParameterDefinition.class);
        if (existingParameterDefs.isEmpty()) {
            return AmaltheaTemplates.addNewParameterDefinition(os, standardParameter);
        }
        return existingParameterDefs.iterator().next();
    }

    private static SchedulingParameterDefinition addNewParameterDefinition(OSModel os, StandardSchedulers.Parameter stdParam) {
        SchedulingParameterDefinition paramDef = AmaltheaFactory.eINSTANCE.createSchedulingParameterDefinition();
        paramDef.setName(stdParam.getParameterName());
        paramDef.setMandatory(stdParam.isMandatory());
        paramDef.setMany(stdParam.isMany());
        String value = stdParam.getDefaultValue();
        switch (stdParam.getType()) {
            case BOOL: {
                paramDef.setType(ParameterType.BOOL);
                if (value == null) break;
                paramDef.setDefaultValue(FactoryUtil.createBooleanObject(Boolean.parseBoolean(value)));
                break;
            }
            case INTEGER: {
                paramDef.setType(ParameterType.INTEGER);
                if (value == null) break;
                paramDef.setDefaultValue(FactoryUtil.createIntegerObject(Integer.parseInt(value)));
                break;
            }
            case FLOAT: {
                paramDef.setType(ParameterType.FLOAT);
                if (value == null) break;
                paramDef.setDefaultValue(FactoryUtil.createFloatObject(Float.parseFloat(value)));
                break;
            }
            case TIME: {
                paramDef.setType(ParameterType.TIME);
                if (value == null) break;
                paramDef.setDefaultValue(FactoryUtil.createTime(value));
                break;
            }
            case STRING: {
                paramDef.setType(ParameterType.STRING);
                if (value == null) break;
                paramDef.setDefaultValue(FactoryUtil.createStringObject(value));
                break;
            }
        }
        os.getSchedulingParameterDefinitions().add((Object)paramDef);
        return paramDef;
    }
}

