/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util.stimuli;

import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EventModelFactory;
import org.eclipse.app4mc.amalthea.model.util.stimuli.IEventModel;
import org.eclipse.emf.common.util.EMap;

public class EMPeriodicBurst
implements IEventModel {
    private static final Time ZEROMS = FactoryUtil.createTime("0ms");
    private Time tOuterPeriod;
    private Time tBurstLength;
    private long iOccurrenceCount;
    private Time tMinDistance;
    private Time tDeltaBurst;

    @Override
    public long etaPlus(Time dt) {
        long iEtaInner;
        if (EventModelFactory.isNullOrZero(dt)) {
            return 0L;
        }
        if (EventModelFactory.isNullOrZero(this.tMinDistance)) {
            double dEtaScale = dt.add(this.tBurstLength).divide(this.tOuterPeriod);
            return (long)((double)this.iOccurrenceCount * Math.ceil(dEtaScale));
        }
        double fraction = Math.floor(dt.add(this.tDeltaBurst).divide(this.tOuterPeriod));
        long iEtaOuter = (long)((double)this.iOccurrenceCount * fraction);
        if (dt.compareTo(this.tOuterPeriod.subtract(this.tDeltaBurst)) < 0) {
            iEtaInner = (long)Math.min(Math.ceil(dt.divide(this.tMinDistance)), (double)this.iOccurrenceCount);
        } else {
            Time rhs = this.tOuterPeriod.multiply(Math.floor(dt.add(this.tDeltaBurst).divide(this.tOuterPeriod)));
            Time tRemainder = dt.add(this.tDeltaBurst).subtract(rhs);
            iEtaInner = (long)Math.min(Math.ceil(tRemainder.divide(this.tMinDistance)), (double)this.iOccurrenceCount);
        }
        return iEtaOuter + iEtaInner;
    }

    @Override
    public long etaMinus(Time dt) {
        if (EventModelFactory.isNullOrZero(dt)) {
            return 0L;
        }
        if (EventModelFactory.isNullOrZero(this.tMinDistance)) {
            double dEtaScale = dt.subtract(this.tBurstLength).divide(this.tOuterPeriod);
            return (long)Math.max(0.0, (double)this.iOccurrenceCount * Math.floor(dEtaScale));
        }
        Time dtOffsetRaw = dt.subtract(this.tOuterPeriod.add(this.tBurstLength).subtract(this.tMinDistance.multiply(this.iOccurrenceCount - 1L).multiply(2L))).add(this.tMinDistance);
        Time dtOffset = dtOffsetRaw.compareTo(ZEROMS) > 0 ? dtOffsetRaw : ZEROMS;
        double fraction = Math.floor(dtOffset.divide(this.tOuterPeriod));
        long iEtaOuter = (long)((double)this.iOccurrenceCount * fraction);
        if (EventModelFactory.isNullOrZero(this.tMinDistance)) {
            return iEtaOuter;
        }
        Time rhs = this.tOuterPeriod.multiply(Math.floor(dtOffset.divide(this.tOuterPeriod)));
        Time tRemainder = dtOffset.subtract(rhs);
        long iEtaInner = (long)Math.min((double)this.iOccurrenceCount, Math.ceil(tRemainder.divide(this.tMinDistance)));
        return iEtaOuter + iEtaInner;
    }

    @Override
    public Time deltaPlus(long n) {
        if (n < 2L) {
            return null;
        }
        long ceiledFraction = (n - 1L) / this.iOccurrenceCount;
        Time tFull = this.tOuterPeriod.multiply(ceiledFraction);
        Time tSlack = this.tOuterPeriod.subtract(this.tMinDistance.multiply(this.iOccurrenceCount - 1L));
        Time tPartial = tSlack.compareTo(this.tMinDistance) > 0 ? this.tOuterPeriod.subtract(this.tMinDistance.multiply(this.iOccurrenceCount - (n - 1L))) : this.tMinDistance.multiply(n - 1L);
        return tFull.add(tPartial);
    }

    @Override
    public Time deltaMinus(long n) {
        if (n < 2L) {
            return null;
        }
        long ceiledFraction = (n - 1L) / this.iOccurrenceCount;
        Time tFull = this.tOuterPeriod.multiply(ceiledFraction);
        long remainder = n - 1L - ceiledFraction * this.iOccurrenceCount;
        Time tPartial = this.tMinDistance.multiply(remainder);
        return tFull.add(tPartial);
    }

    @Override
    public double getUtilization(Process process, RuntimeUtil.TimeType tt, EMap<ModeLabel, String> modes) {
        Time executionTime = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        return executionTime.multiply(this.getOccurrenceCount()).divide(this.getOuterPeriod());
    }

    public Time getOuterPeriod() {
        return this.tOuterPeriod;
    }

    public void setOuterPeriod(Time tOuterPeriod) {
        this.tOuterPeriod = tOuterPeriod;
    }

    public Time getBurstLength() {
        return this.tBurstLength;
    }

    public void setBurstLength(Time tBurstLength) {
        this.tBurstLength = tBurstLength;
    }

    public long getOccurrenceCount() {
        return this.iOccurrenceCount;
    }

    public void setOccurrenceCount(long iOccurrenceCount) {
        this.iOccurrenceCount = iOccurrenceCount;
    }

    public Time getMinDistance() {
        return this.tMinDistance;
    }

    public void setMinDistance(Time tMinDistance) {
        this.tMinDistance = tMinDistance;
    }

    public Time getDeltaBurst() {
        return this.tDeltaBurst;
    }

    public void setDeltaBurst(Time tDeltaBurst) {
        this.tDeltaBurst = tDeltaBurst;
    }
}

