/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.sw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="Inchron-SW-Task-NotAllocated-DifferentSchedulers", checks={"Task cannot be scheduled by more than one OS"})
public class InchronSWInvalidTaskAllocation
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getTask();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof Task) {
            Task task = (Task)eObject;
            Set taskAllocations = AmaltheaIndex.getReferringObjects((EObject)task, TaskAllocation.class);
            HashSet<OperatingSystem> osSet = new HashSet<OperatingSystem>();
            for (TaskAllocation taskAllocation : taskAllocations) {
                TaskScheduler sched = taskAllocation.getScheduler();
                if (sched == null || !(sched.eContainer() instanceof OperatingSystem)) continue;
                OperatingSystem os = (OperatingSystem)sched.eContainer();
                osSet.add(os);
            }
            ArrayList<String> ar = new ArrayList<String>();
            if (osSet.size() > 1) {
                for (OperatingSystem os2 : osSet) {
                    if (os2.getName() == null) continue;
                    ar.add(os2.getName());
                }
                Collections.sort(ar);
                String str = String.join((CharSequence)",", ar);
                this.addIssue(results, (EObject)task, null, "Task " + this.name((INamed)task) + " is scheduled by more than one operating system: " + str);
            }
        }
    }
}

