/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters200.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters200.utils.StandardSchedulers;
import org.jdom2.Content;
import org.jdom2.Element;

public class SchedulerConverterUtil {
    private SchedulerConverterUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> getStandardParameterNames(String algorithmName) {
        ArrayList<String> result = new ArrayList<String>();
        for (StandardSchedulers.Parameter param : StandardSchedulers.getAllParametersOfAlgorithm(algorithmName)) {
            result.add(param.getParameterName());
        }
        return result;
    }

    public static void addParameterDefinition(Element osModel, String parameterName) {
        StandardSchedulers.Type parameterType = StandardSchedulers.Type.STRING;
        boolean parameterMany = false;
        boolean parameterMandatory = false;
        String parameterDefaultValue = null;
        StandardSchedulers.Parameter param = StandardSchedulers.getParameter(parameterName);
        if (param != null) {
            parameterType = param.getType();
            parameterMany = param.isMany();
            parameterMandatory = param.isMandatory();
            parameterDefaultValue = param.getDefaultValue();
        }
        Element paramDefElement = new Element("schedulingParameterDefinitions");
        osModel.addContent((Content)paramDefElement);
        String idValue = String.valueOf(HelperUtil.encodeName((String)parameterName)) + "?type=SchedulingParameterDefinition";
        paramDefElement.setAttribute("id", idValue, AmaltheaNamespaceRegistry.getGenericNamespace((String)"xmi"));
        paramDefElement.setAttribute("name", parameterName);
        paramDefElement.setAttribute("type", parameterType.getTypeName());
        paramDefElement.setAttribute("many", String.valueOf(parameterMany));
        paramDefElement.setAttribute("mandatory", String.valueOf(parameterMandatory));
        if (parameterDefaultValue != null) {
            Element paramDefDefaultElement = new Element("defaultValue");
            paramDefElement.addContent((Content)paramDefDefaultElement);
            paramDefDefaultElement.setAttribute("type", SchedulerConverterUtil.buildTypeString(parameterType), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (parameterType == StandardSchedulers.Type.TIME) {
                Pattern p = Pattern.compile("(-?\\d+)\\s?(s|ms|us|ns|ps)");
                Matcher m = p.matcher(parameterDefaultValue);
                if (m.matches()) {
                    String timeValue = m.group(1);
                    String timeUnit = m.group(2);
                    paramDefDefaultElement.setAttribute("value", timeValue);
                    paramDefDefaultElement.setAttribute("unit", timeUnit);
                }
            } else {
                paramDefDefaultElement.setAttribute("value", parameterDefaultValue);
            }
        }
    }

    private static String buildTypeString(StandardSchedulers.Type type) {
        switch (type) {
            case TIME: {
                return "am:Time";
            }
            case BOOL: {
                return "am:BooleanObject";
            }
            case INTEGER: {
                return "am:IntegerObject";
            }
            case FLOAT: {
                return "am:FloatObject";
            }
            case STRING: {
                return "am:StringObject";
            }
        }
        return "";
    }

    public static void addSchedulerDefinition(Element osModel, String algorithmName) {
        StandardSchedulers.Algorithm algorithm = StandardSchedulers.getAlgorithm(SchedulerConverterUtil.getNewSchedulerName(algorithmName));
        if (algorithm == null) {
            SchedulerConverterUtil.addSchedulerDefinition(osModel, algorithmName, null, null, null, null);
        } else {
            String name = algorithm.getAlgorithmName();
            String description = algorithm.getDescription();
            List<String> paramNames1 = algorithm.getAlgorithmParameterNames();
            List<String> paramNames2 = algorithm.getProcessParameterNames();
            List<Boolean> options = Arrays.asList(algorithm.hasExactlyOneChild(), algorithm.passesParametersUpwards(), algorithm.requiresParentScheduler());
            SchedulerConverterUtil.addSchedulerDefinition(osModel, name, description, paramNames1, paramNames2, options);
        }
    }

    public static void addSchedulerDefinition(Element osModel, String name, String description, List<String> algorithmParameters, List<String> processParameters, List<Boolean> options) {
        Element schedulerDefElement = new Element("schedulerDefinitions");
        osModel.addContent((Content)schedulerDefElement);
        String idValue = String.valueOf(HelperUtil.encodeName((String)name)) + "?type=SchedulerDefinition";
        schedulerDefElement.setAttribute("id", idValue, AmaltheaNamespaceRegistry.getGenericNamespace((String)"xmi"));
        schedulerDefElement.setAttribute("name", name);
        if (description != null && !description.isEmpty()) {
            schedulerDefElement.setAttribute("description", description);
        }
        if (algorithmParameters != null && !algorithmParameters.isEmpty()) {
            schedulerDefElement.setAttribute("algorithmParameters", SchedulerConverterUtil.buildParametersString(algorithmParameters));
        }
        if (processParameters != null && !processParameters.isEmpty()) {
            schedulerDefElement.setAttribute("processParameters", SchedulerConverterUtil.buildParametersString(processParameters));
        }
        if (options != null && options.size() == 3) {
            schedulerDefElement.setAttribute("hasExactlyOneChild", options.get(0).toString());
            schedulerDefElement.setAttribute("passesParametersUpwards", options.get(1).toString());
            schedulerDefElement.setAttribute("requiresParentScheduler", options.get(2).toString());
        }
    }

    private static String buildParametersString(List<String> parameters) {
        return parameters.stream().map(p -> String.valueOf(HelperUtil.encodeName((String)p)) + "?type=SchedulingParameterDefinition").collect(Collectors.joining(" "));
    }

    public static String getNewSchedulerName(String oldName) {
        if ("Grouping".equals(oldName)) {
            return "GroupingServer";
        }
        if ("PollingPeriodicServer".equals(oldName)) {
            return "PollingServer";
        }
        if ("ConstantBandwidthServerWithCASH".equals(oldName)) {
            return "ConstantBandwidthServerWithCapacitySharing";
        }
        return oldName;
    }
}

