/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.container;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResource;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResourceSetImpl;
import org.eclipse.app4mc.amalthea.model.impl.SchedulingParameterImpl;
import org.eclipse.app4mc.amalthea.model.presentation.ExtendedAmaltheaEditor;
import org.eclipse.app4mc.amalthea.model.provider.ExtendedAmaltheaItemProviderAdapterFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class AmaltheaModelContainer {
    private final IContainer iContainer;
    private final Set<EditorPart> openEditors = new HashSet<EditorPart>();
    private final Set<IFile> initialModelFiles = new HashSet<IFile>();
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryEditingDomain editingDomain;

    public AmaltheaModelContainer(IContainer container) {
        this.iContainer = container;
    }

    public boolean isInUse() {
        return !this.openEditors.isEmpty();
    }

    public boolean addEditor(EditorPart editor) {
        boolean wasEmpty = this.openEditors.isEmpty();
        boolean added = this.openEditors.add(editor);
        if (wasEmpty && added) {
            this.initialModelFiles.addAll(AmaltheaEditorUtil.getValidModelFiles(this.iContainer));
            this.initializeEditingDomain();
            for (IFile iFile : this.initialModelFiles) {
                URI uri = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
                Resource res = this.editingDomain.getResourceSet().createResource(uri);
                if (res instanceof XMLResource) {
                    ((XMLResource)res).setUseZip(AmaltheaEditorUtil.isZipFile(iFile));
                }
                try {
                    res.load(null);
                }
                catch (IOException iOException) {}
            }
            EcoreUtil.resolveAll((ResourceSet)this.editingDomain.getResourceSet());
            for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
                if (!(resource instanceof AmaltheaResource)) continue;
                ((AmaltheaResource)resource).setIntrinsicIDToEObjectMap(null);
            }
            this.updateDecorators();
        }
        return added;
    }

    public boolean removeEditor(EditorPart editor) {
        boolean removed = this.openEditors.remove(editor);
        if (removed && this.openEditors.isEmpty()) {
            this.initialModelFiles.clear();
            this.adapterFactory = null;
            this.editingDomain = null;
            this.updateDecorators();
        }
        return removed;
    }

    public Set<IFile> getInitialModelFiles() {
        return Set.copyOf(this.initialModelFiles);
    }

    public Set<EditorPart> getOpenEditors() {
        return Set.copyOf(this.openEditors);
    }

    public void updateDirtyStateOfEditors() {
        this.openEditors.stream().filter(ExtendedAmaltheaEditor.class::isInstance).map(ExtendedAmaltheaEditor.class::cast).forEach(ExtendedAmaltheaEditor::editorDirtyStateChanged);
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ResourceSet getResourceSet() {
        return this.editingDomain == null ? null : this.editingDomain.getResourceSet();
    }

    private void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ExtendedAmaltheaItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack(){

            public void execute(Command command) {
                if (!(command instanceof AbstractCommand.NonDirtying)) {
                    DiagnosticDecorator.cancel((EditingDomain)AmaltheaModelContainer.this.editingDomain);
                }
                super.execute(command);
            }
        };
        AmaltheaResourceSetImpl resourceSet = new AmaltheaResourceSetImpl();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet){

            public Command createCommand(Class<? extends Command> commandClass, CommandParameter commandParameter) {
                if (commandClass == AddCommand.class && commandParameter != null) {
                    Object content;
                    EObject owner = commandParameter.getEOwner();
                    EStructuralFeature feature = commandParameter.getEStructuralFeature();
                    Collection collection = commandParameter.getCollection();
                    int index = commandParameter.getIndex();
                    if (owner != null && feature == null && collection != null && !collection.isEmpty() && (content = collection.iterator().next()) instanceof SchedulingParameterImpl && (feature = (EStructuralFeature)owner.eClass().getEAllStructuralFeatures().stream().filter(e -> "schedulingParameters".equals(e.getName())).findAny().orElse(null)) != null) {
                        return super.createCommand(commandClass, new CommandParameter((Object)owner, (Object)feature, collection, index));
                    }
                }
                return super.createCommand(commandClass, commandParameter);
            }
        };
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)this.editingDomain));
    }

    private void updateDecorators() {
        IDecoratorManager decoratorMgr = PlatformUI.getWorkbench().getDecoratorManager();
        decoratorMgr.update("org.eclipse.app4mc.amalthea.container.decorator");
        decoratorMgr.update("org.eclipse.app4mc.amalthea.file.loaded.decorator");
    }
}

