/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.software;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.SemaphoreAccess;
import org.eclipse.app4mc.amalthea.model.SemaphoreType;
import org.eclipse.app4mc.amalthea.model.WaitingBehaviour;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-SW-Semaphore-Access", checks={"Waiting behaviour must be 'active' for spinlock semaphore access"})
public class AmSwSemaphoreAccess
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSemaphoreAccess();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof SemaphoreAccess) {
            SemaphoreAccess semAcc = (SemaphoreAccess)eObject;
            if (semAcc.getSemaphore() == null) {
                return;
            }
            Semaphore sem = semAcc.getSemaphore();
            if (sem.getSemaphoreType() == SemaphoreType.SPINLOCK && semAcc.getWaitingBehaviour() != WaitingBehaviour.ACTIVE) {
                this.addIssue(results, (EObject)semAcc, (EStructuralFeature)ePackage.getSemaphoreAccess_WaitingBehaviour(), "The waiting behaviour must be set to '" + WaitingBehaviour.ACTIVE + "' for spinlock semaphore access.");
            }
        }
    }
}

