/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.eclipse.app4mc.atdb.ATDBBuilder;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.DBConnection;
import org.eclipse.app4mc.atdb._import.btf.ATDBMetricCalculator;
import org.eclipse.app4mc.atdb._import.btf.BTFImporter;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ImportTransformation
implements IRunnableWithProgress {
    private final String btfFile;
    private final String atdbFile;
    private final boolean calculateMetrics;
    private final boolean persistTraceEvents;
    private final boolean doInMemoryDBImport;

    public ImportTransformation(String source, String target, boolean calculateMetrics, boolean persistTraceEvents, boolean doInMemoryDBImport) {
        if (source.endsWith(".btf") && target.endsWith(".atdb")) {
            this.btfFile = source;
            this.atdbFile = target;
        } else {
            this.btfFile = "";
            this.atdbFile = "";
        }
        this.calculateMetrics = calculateMetrics;
        this.persistTraceEvents = persistTraceEvents;
        this.doInMemoryDBImport = doInMemoryDBImport;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (!this.btfFile.isEmpty() && !this.atdbFile.isEmpty()) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Converting BTF trace to ATDB...", (int)100);
            DBConnection.AccessMode accessMode = this.doInMemoryDBImport ? DBConnection.AccessMode.ReadWriteInMemory : DBConnection.AccessMode.ReadWrite;
            try {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (ATDBConnection con = new ATDBConnection(this.atdbFile, accessMode);){
                        SubMonitor createATDBMonitor = subMon.split(1, 0);
                        createATDBMonitor.beginTask("Creating empty ATDB...", 1);
                        ATDBBuilder atdbBuilder = new ATDBBuilder((DBConnection)con).createBasicDBStructure().createBasicViews().createOptionalAndTemporaryTables(BTFEntityType.literals, this.persistTraceEvents);
                        if (this.persistTraceEvents) {
                            atdbBuilder.createOptionalViews(BTFEntityType.literals);
                        }
                        con.flushAllStatements();
                        createATDBMonitor.done();
                        SubMonitor btfImportMonitor = subMon.split(this.calculateMetrics ? 59 : 89, 0);
                        BTFImporter btfImporter = new BTFImporter(con, this.btfFile);
                        btfImporter.run((IProgressMonitor)btfImportMonitor);
                        con.flushAllStatements();
                        SubMonitor writeIndicesMonitor = subMon.split(10, 0);
                        writeIndicesMonitor.beginTask("Adding indices and writing events to data base...", 1);
                        atdbBuilder.createBasicDBStrctureIndices();
                        con.flushAllStatements();
                        writeIndicesMonitor.done();
                        btfImportMonitor.done();
                        if (this.calculateMetrics) {
                            SubMonitor metricCalcMonitor = subMon.split(30, 0);
                            ImportTransformation.calculateMetrics((IProgressMonitor)metricCalcMonitor, con);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    public static void calculateMetrics(IProgressMonitor progressMonitor, ATDBConnection con) throws InvocationTargetException, InterruptedException, SQLException {
        ATDBBuilder atdbBuilder = new ATDBBuilder((DBConnection)con);
        atdbBuilder.createTemporaryEntityFilteredTraceEventTables(BTFEntityType.literals).autoPopulateEntityFilteredTraceEventTables(BTFEntityType.literals);
        ATDBMetricCalculator metricCalc = new ATDBMetricCalculator(con);
        metricCalc.run(progressMonitor);
        progressMonitor.done();
    }
}

