/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters070.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AbstractHelper;
import org.eclipse.app4mc.amalthea.converters070.utils.HelperUtils_111_070;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ContentConverter
implements IConverter {
    private final HelperUtils_111_070 helper = HelperUtils_111_070.getInstance();
    private final Map<String, String> old_new_mappingTypes = new HashMap<String, String>();

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        this.buildMappingTypesMap();
        this.updateNameSpaces(root.getRootElement());
        this.updateTypes(root.getRootElement());
        this.updateReferences(root.getRootElement());
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void buildMappingTypesMap() {
        this.old_new_mappingTypes.put("sw.OSEvent", "OsEvent");
        this.old_new_mappingTypes.put("sw:OSEvent", "am:OsEvent");
        this.old_new_mappingTypes.put("sw.Periodic", "PeriodicActivation");
        this.old_new_mappingTypes.put("sw:Periodic", "am:PeriodicActivation");
        this.old_new_mappingTypes.put("hw.MemType", "MemoryType");
        this.old_new_mappingTypes.put("hw:MemType", "am:MemoryType");
        this.old_new_mappingTypes.put("hw.MemoryType", "MemoryTypeEnum");
        this.old_new_mappingTypes.put("hw:MemoryTypeEnum", "am:MemoryTypeEnum");
        this.old_new_mappingTypes.put("hw.System", "HwSystem");
        this.old_new_mappingTypes.put("hw:System", "am:HwSystem");
        this.old_new_mappingTypes.put("hw.Component", "HwComponent");
        this.old_new_mappingTypes.put("hw:Component", "am:HwComponent");
        this.old_new_mappingTypes.put("hw.Port", "HwPort");
        this.old_new_mappingTypes.put("hw:Port", "am:HwPort");
        this.old_new_mappingTypes.put("hw.AbstractionType", "AbstractionTypeDescription");
        this.old_new_mappingTypes.put("hw:AbstractionType", "am:AbstractionTypeDescription");
    }

    private void updateNameSpaces(Element rootElement) {
        this.helper.updateRootElement_NameSpaces_to_070(rootElement);
    }

    private void updateTypes(Element rootElement) {
        HashMap typeAttributesMap = new HashMap();
        List types = this.helper.getXpathResult(rootElement, ".//@xsi:type", Attribute.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Attribute typeAttribute : types) {
            String typeValue = typeAttribute.getValue();
            if (!typeAttributesMap.containsKey(typeValue)) {
                typeAttributesMap.put(typeValue, new ArrayList());
            }
            ((List)typeAttributesMap.get(typeValue)).add(typeAttribute);
        }
        for (String typeValue : typeAttributesMap.keySet()) {
            if (!typeValue.contains(":")) continue;
            if (!this.old_new_mappingTypes.containsKey(typeValue)) {
                int indexOfColon = typeValue.indexOf(":");
                String nameSpacePrefix = typeValue.substring(0, indexOfColon);
                if (!this.helper.enumTypeContainsIn111(nameSpacePrefix)) continue;
                String substring = typeValue.length() > indexOfColon + 1 ? typeValue.substring(indexOfColon + 1) : "";
                String type = "am:" + substring;
                List attribsList = (List)typeAttributesMap.get(typeValue);
                for (Attribute attribute : attribsList) {
                    attribute.setValue(type);
                }
                continue;
            }
            String updatedValue = this.old_new_mappingTypes.get(typeValue);
            List attribsList = (List)typeAttributesMap.get(typeValue);
            for (Attribute attribute : attribsList) {
                attribute.setValue(updatedValue);
            }
        }
    }

    private void updateReferences(Element rootElement) {
        HashMap typeAttributesMap = new HashMap();
        List types = this.helper.getXpathResult(rootElement, ".//@*", Attribute.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Attribute typeAttribute : types) {
            String typeValue = typeAttribute.getValue();
            if (!typeValue.contains("?type=")) continue;
            if (!typeAttributesMap.containsKey(typeValue)) {
                typeAttributesMap.put(typeValue, new ArrayList());
            }
            ((List)typeAttributesMap.get(typeValue)).add(typeAttribute);
        }
        for (String refString : typeAttributesMap.keySet()) {
            StringTokenizer tokenizer = new StringTokenizer(refString);
            StringBuffer convertedReferencesBuffer = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                String typeValue = tokenizer.nextToken();
                int indexOfColon = typeValue.indexOf("=");
                String ref_part_1 = typeValue.substring(0, indexOfColon);
                String ref_part_2 = typeValue.length() > indexOfColon + 1 ? typeValue.substring(indexOfColon + 1) : "";
                String convertedRefString = "";
                if (!this.old_new_mappingTypes.containsKey(ref_part_2)) {
                    if (ref_part_2.contains(".")) {
                        int indexOfDot = ref_part_2.indexOf(".");
                        String type = ref_part_2.length() > indexOfDot + 1 ? ref_part_2.substring(indexOfDot + 1) : "";
                        convertedRefString = String.valueOf(ref_part_1) + "=" + type;
                    }
                } else {
                    convertedRefString = String.valueOf(ref_part_1) + "=" + this.old_new_mappingTypes.get(ref_part_2);
                }
                convertedReferencesBuffer.append(String.valueOf(convertedRefString) + " ");
            }
            List attribsList = (List)typeAttributesMap.get(refString);
            for (Attribute attribute : attribsList) {
                attribute.setValue(convertedReferencesBuffer.toString().trim());
            }
        }
    }

    private HelperUtils_111_070 getHelper(AbstractHelper helper) {
        if (!(helper instanceof HelperUtils_111_070)) {
            return HelperUtils_111_070.getInstance();
        }
        return (HelperUtils_111_070)helper;
    }
}

