/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters070.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters070.utils.HelperUtils_111_070;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MappingConverter
implements IConverter {
    private final HelperUtils_111_070 helper = HelperUtils_111_070.getInstance();

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_ProcessAllocation(rootElement);
        this.update_Mapping_mem(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_Mapping_mem(Element rootElement) {
        List mappings = this.helper.getXpathResult(rootElement, ".//mappingModel/mapping|/mapping:MappingModel/mapping", Element.class, new Namespace[]{this.helper.getNS_111("mapping"), this.helper.getGenericNS("xsi")});
        for (Element mappingElement : mappings) {
            Attribute memAttribute = mappingElement.getAttribute("mem");
            if (memAttribute != null) {
                memAttribute.setName("memory");
                continue;
            }
            Element memElement = mappingElement.getChild("mem");
            if (memElement == null) continue;
            memElement.setName("memory");
        }
    }

    private void update_ProcessAllocation(Element rootElement) {
        List taskAllocations = this.helper.getXpathResult(rootElement, ".//mappingModel/processAllocation[(@xsi:type=\"mapping:TaskAllocation\")]|/mapping:MappingModel/processAllocation[(@xsi:type=\"mapping:TaskAllocation\")]", Element.class, new Namespace[]{this.helper.getNS_111("mapping"), this.helper.getGenericNS("xsi")});
        for (Element processAllocationElement : taskAllocations) {
            String href;
            Element newTaskAllocationElement = new Element("taskAllocation");
            String process = processAllocationElement.getAttributeValue("process");
            String scheduler = processAllocationElement.getAttributeValue("scheduler");
            if (process != null) {
                newTaskAllocationElement.setAttribute("task", process);
            } else {
                Element processElement = processAllocationElement.getChild("process");
                String string = href = processElement != null ? processElement.getAttributeValue("href") : null;
                if (href != null) {
                    Element sub_task_Element = new Element("task");
                    sub_task_Element.setAttribute("href", href);
                    newTaskAllocationElement.addContent((Content)sub_task_Element);
                }
            }
            if (scheduler != null) {
                newTaskAllocationElement.setAttribute("scheduler", scheduler);
            } else {
                Element schedulerElement = processAllocationElement.getChild("scheduler");
                String string = href = schedulerElement != null ? schedulerElement.getAttributeValue("href") : null;
                if (href != null) {
                    Element sub_scheduler_Element = new Element("scheduler");
                    sub_scheduler_Element.setAttribute("href", href);
                    newTaskAllocationElement.addContent((Content)sub_scheduler_Element);
                }
            }
            Element parentElement = processAllocationElement.getParentElement();
            parentElement.addContent((Content)newTaskAllocationElement);
            processAllocationElement.detach();
        }
        List isrAllocations = this.helper.getXpathResult(rootElement, ".//mappingModel/processAllocation[(@xsi:type=\"mapping:ISRAllocation\")]|/mapping:MappingModel/processAllocation[(@xsi:type=\"mapping:ISRAllocation\")]", Element.class, new Namespace[]{this.helper.getNS_111("mapping"), this.helper.getGenericNS("xsi")});
        for (Element processAllocationElement : isrAllocations) {
            String href;
            Element newISRAllocationElement = new Element("isrAllocation");
            String process = processAllocationElement.getAttributeValue("process");
            String scheduler = processAllocationElement.getAttributeValue("scheduler");
            if (process != null) {
                newISRAllocationElement.setAttribute("isr", process);
            } else {
                Element processElement = processAllocationElement.getChild("process");
                String string = href = processElement != null ? processElement.getAttributeValue("href") : null;
                if (href != null) {
                    Element sub_isr_Element = new Element("isr");
                    sub_isr_Element.setAttribute("href", href);
                    newISRAllocationElement.addContent((Content)sub_isr_Element);
                }
            }
            if (scheduler != null) {
                newISRAllocationElement.setAttribute("controller", scheduler);
            } else {
                Element schedulerElement = processAllocationElement.getChild("scheduler");
                String string = href = schedulerElement != null ? schedulerElement.getAttributeValue("href") : null;
                if (href != null) {
                    Element sub_controller_Element = new Element("controller");
                    sub_controller_Element.setAttribute("href", href);
                    newISRAllocationElement.addContent((Content)sub_controller_Element);
                }
            }
            Element parentElement = processAllocationElement.getParentElement();
            parentElement.addContent((Content)newISRAllocationElement);
            processAllocationElement.detach();
        }
    }
}

