/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters070.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters070.utils.HelperUtils_111_070;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
implements IConverter {
    private final HelperUtils_111_070 helper = HelperUtils_111_070.getInstance();

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_ModeSwitchEntry_isDefault(rootElement);
        this.update_RunnableItem_isBuffered(rootElement);
        this.update_RunnableItem_accessEnum(rootElement);
        this.update_RunnableItem_isOrdered(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_ModeSwitchEntry_isDefault(Element rootElement) {
        List isDefaultAttributes = this.helper.getXpathResult(rootElement, ".//swModel//graphEntries[(@xsi:type=\"sw:ModeSwitch\")]/entries/@isDefault|/sw:SWModel//graphEntries[(@xsi:type=\"sw:ModeSwitch\")]/entries/@isDefault", Attribute.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Attribute isDefaultAttribute : isDefaultAttributes) {
            isDefaultAttribute.setName("default");
        }
    }

    private void update_RunnableItem_isBuffered(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//swModel/labels/@isBuffered|/sw:SWModel/labels/@isBuffered");
        xpathBuffer.append("|");
        xpathBuffer.append(".//swModel/runnables/runnableItems[(@xsi:type=\"sw:LabelAccess\") or (@xsi:type=\"sw:SenderReceiverRead\") or (@xsi:type=\"sw:SenderReceiverWrite\")]/@isBuffered|/sw:SWModel/runnables/runnableItems[(@xsi:type=\"sw:LabelAccess\") or (@xsi:type=\"sw:SenderReceiverRead\") or (@xsi:type=\"sw:SenderReceiverWrite\")]/@isBuffered");
        xpathBuffer.append("|");
        xpathBuffer.append(".//swModel//runnableItem[(@xsi:type=\"sw:LabelAccess\") or (@xsi:type=\"sw:SenderReceiverRead\") or (@xsi:type=\"sw:SenderReceiverWrite\")]/@isBuffered|/sw:SWModel//runnableItem[(@xsi:type=\"sw:LabelAccess\") or (@xsi:type=\"sw:SenderReceiverRead\") or (@xsi:type=\"sw:SenderReceiverWrite\")]/@isBuffered");
        List isDefaultAttributes = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Attribute isDefaultAttribute : isDefaultAttributes) {
            isDefaultAttribute.setName("buffered");
        }
    }

    private void update_RunnableItem_accessEnum(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//swModel/runnables/runnableItems[(@xsi:type=\"sw:SemaphoreAccess\")]/@accessEnum|/sw:SWModel/runnables/runnableItems[(@xsi:type=\"sw:SemaphoreAccess\")]/@accessEnum");
        xpathBuffer.append("|");
        xpathBuffer.append(".//swModel//runnableItem[(@xsi:type=\"sw:SemaphoreAccess\")]/@accessEnum|/sw:SWModel//runnableItem[(@xsi:type=\"sw:SemaphoreAccess\")]/@accessEnum");
        List isDefaultAttributes = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Attribute isDefaultAttribute : isDefaultAttributes) {
            isDefaultAttribute.setName("access");
        }
    }

    private void update_RunnableItem_isOrdered(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//swModel/runnables/runnableItems[(@xsi:type=\"sw:Group\")]/@isOrdered|/sw:SWModel/runnables/runnableItems[(@xsi:type=\"sw:Group\")]/@isOrdered");
        xpathBuffer.append("|");
        xpathBuffer.append(".//swModel//runnableItem[(@xsi:type=\"sw:Group\")]/@isOrdered|/sw:SWModel//runnableItem[(@xsi:type=\"sw:Group\")]/@isOrdered");
        List isDefaultAttributes = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Attribute isDefaultAttribute : isDefaultAttributes) {
            isDefaultAttribute.setName("ordered");
        }
    }

    private void updatePeriodic(Element rootElement) {
        String updatedValue;
        Attribute attribute;
        List activations = this.helper.getXpathResult(rootElement, ".//swModel/activations[(@xsi:type=\"sw:Periodic\")]|/sw:SWModel/activations[(@xsi:type=\"sw:Periodic\")]", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        List runnables = this.helper.getXpathResult(rootElement, ".//swModel/runnables|/sw:SWModel/runnables", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        List processPrototypes = this.helper.getXpathResult(rootElement, ".//swModel/processPrototypes|/sw:SWModel/processPrototypes", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element element : runnables) {
            attribute = element.getAttribute("activation");
            if (attribute != null) {
                updatedValue = this.helper.updateReferenceWithType(attribute.getValue(), "PeriodicActivation");
                attribute.setValue(updatedValue);
                continue;
            }
            this.updateReferencesInActivation(element);
        }
        for (Element element : processPrototypes) {
            attribute = element.getAttribute("activation");
            if (attribute != null) {
                updatedValue = this.helper.updateReferenceWithType(attribute.getValue(), "PeriodicActivation");
                attribute.setValue(updatedValue);
                continue;
            }
            this.updateReferencesInActivation(element);
        }
        for (Element activation : activations) {
            attribute = activation.getAttribute("type", this.helper.getGenericNS("xsi"));
            if (attribute == null) continue;
            attribute.setValue("am:PeriodicActivation");
        }
    }

    private void updateReferencesInActivation(Element element) {
        Element activation = element.getChild("activation");
        if (activation != null) {
            Attribute hrefAttribute;
            Attribute typeAttribute = activation.getAttribute("type", this.helper.getGenericNS("xsi"));
            if (typeAttribute != null) {
                typeAttribute.setValue("am:PeriodicActivation");
            }
            if ((hrefAttribute = activation.getAttribute("href")) != null) {
                String updatedValue = this.helper.updateReferenceWithType(hrefAttribute.getValue(), "PeriodicActivation");
                hrefAttribute.setValue(updatedValue);
            }
        }
    }
}

