/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.impl;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters071.utils.HelperUtils_070_071;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheBuilder;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
implements IConverter {
    private final HelperUtils_070_071 helper = HelperUtils_070_071.getInstance();
    private final Logger logger = LogManager.getLogger(this.getClass());
    private List<ICache> caches;
    private Map<File, Document> fileName_documentsMap;
    private File targetFile;

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)"Migration from 0.7.0 to 0.7.1 : Starting Sw converter");
        this.caches = caches;
        this.fileName_documentsMap = fileName_documentsMap;
        this.targetFile = targetFile;
        Document root = fileName_documentsMap.get(this.targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_DataSize(rootElement);
        this.update_MemoryElements_With_Section_Info(rootElement);
        this.update_Section(rootElement);
        this.remove_SectionMapping_and_SectionMappingConstraint(rootElement);
        this.update_ModeSwitch(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_ModeSwitch(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/tasks/callGraph//graphEntries");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph//graphEntries");
        List graphEntryBaseElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_071("am")});
        for (Element graphEntryBaseElement : graphEntryBaseElements) {
            String graphEntryBaseObjectType;
            if (!graphEntryBaseElement.getParentElement().getName().equals("callGraph")) {
                graphEntryBaseElement.setName("items");
            }
            if ((graphEntryBaseObjectType = graphEntryBaseElement.getAttributeValue("type", this.helper.getGenericNS("xsi"))) == null || !graphEntryBaseObjectType.equals("am:ModeSwitch")) continue;
            List entriesElements = graphEntryBaseElement.getChildren("entries");
            boolean isDefaultFound = false;
            for (Element entriesElement : entriesElements) {
                Attribute valueAttribute;
                Attribute defaultAttribute = entriesElement.getAttribute("default");
                if (defaultAttribute != null) {
                    if (!isDefaultFound) {
                        isDefaultFound = true;
                        entriesElement.setName("defaultEntry");
                        entriesElement.removeAttribute("value");
                        entriesElement.removeChild("value");
                    }
                    entriesElement.removeAttribute("default");
                }
                if ((valueAttribute = entriesElement.getAttribute("value")) != null) {
                    valueAttribute.setName("values");
                    continue;
                }
                Element valueElement = entriesElement.getChild("value");
                if (valueElement == null) continue;
                valueElement.setName("values");
            }
        }
    }

    private void remove_SectionMapping_and_SectionMappingConstraint(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./mappingModel/mapping[@xsi:type=\"am:SectionMapping\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel/mappingConstraints[@xsi:type=\"am:SectionMappingConstraint\"]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_071("am")});
        for (Element sectionMappingElement : elements) {
            sectionMappingElement.getParent().removeContent((Content)sectionMappingElement);
        }
    }

    private void update_Section(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/sections");
        List sectionElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_071("am")});
        for (Element element : sectionElements) {
            element.removeChildren("size");
            element.removeChildren("labels");
            element.removeChildren("runEntities");
            element.removeAttribute("labels");
            element.removeAttribute("runEntities");
        }
    }

    private void update_MemoryElements_With_Section_Info(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels");
        List memoryElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_071("am")});
        for (Element memoryElement : memoryElements) {
            String memoryElementName = memoryElement.getAttributeValue("name");
            String memoryElementID = memoryElement.getAttributeValue("id", this.helper.getGenericNS("xmi"));
            List<Object> sections = new ArrayList();
            if (memoryElement.getName().equals("labels")) {
                sections = this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Label_Sections, memoryElementName);
                sections.addAll(this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Label_UUID_Sections, memoryElementID));
            } else if (memoryElement.getName().equals("runnables")) {
                sections = this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Runnable_Sections, memoryElementName);
                sections.addAll(this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Runnable_UUID_Sections, memoryElementID));
            }
            if (sections.size() <= 0) continue;
            String sectionName = (String)sections.get(0);
            if (this.isSectionDefinedInFile(sectionName, this.targetFile)) {
                memoryElement.setAttribute(new Attribute("section", String.valueOf(this.encodeSectionName(sectionName)) + "?type=Section"));
            } else {
                Element sectionRef = new Element("section");
                sectionRef.setAttribute("href", "amlt:/#" + this.encodeSectionName(sectionName) + "?type=Section");
                memoryElement.addContent((Content)sectionRef);
            }
            if (sections.size() <= 1) continue;
            this.logger.warn((Object)("MemoryElement :" + memoryElementName + " is associated to multiple sections: " + Joiner.on((String)",").join(sections.toArray()) + ". \nAs per AMALTHEA 0.7.1 it is allowed to be part of one Section only."));
        }
    }

    private List<String> getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum type, String memoryElementName_or_UUID) {
        SectionRunnableLabelCacheBuilder iCache = this.getSectionRunnableLabelCacheBuilder();
        if (iCache == null) {
            throw new RuntimeException("SectionRunnableLabelCache is not buit and Object of it is not available in Converters");
        }
        Map<File, Map<String, Object>> cacheMap = iCache.getCacheMap();
        Set<File> fileSet = this.fileName_documentsMap.keySet();
        for (File file : fileSet) {
            Map<String, Object> map = cacheMap.get(file);
            Object object = map.get(type.name());
            if (!(object instanceof Map) || !((Map)object).containsKey(memoryElementName_or_UUID)) continue;
            return (List)((Map)object).get(memoryElementName_or_UUID);
        }
        return new ArrayList<String>();
    }

    private boolean isSectionDefinedInFile(String sectionName, File inputFile) {
        Object object;
        SectionRunnableLabelCacheBuilder iCache = this.getSectionRunnableLabelCacheBuilder();
        if (iCache == null) {
            throw new RuntimeException("SectionRunnableLabelCache is not buit and Object of it is not available in Converters");
        }
        Map<File, Map<String, Object>> cacheMap = iCache.getCacheMap();
        Map<String, Object> map = cacheMap.get(inputFile);
        return map != null && (object = map.get(SectionRunnableLabelCacheEnum.Section_Names.name())) instanceof List && ((List)object).contains(sectionName);
    }

    private SectionRunnableLabelCacheBuilder getSectionRunnableLabelCacheBuilder() {
        for (ICache cache : this.caches) {
            if (!(cache instanceof SectionRunnableLabelCacheBuilder)) continue;
            return (SectionRunnableLabelCacheBuilder)cache;
        }
        return null;
    }

    private void update_DataSize(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/typeDefinitions/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/modeLabels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/customEntities/size");
        List dataSizes = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_071("am")});
        for (Element dataSizeElement : dataSizes) {
            Attribute numberBits = dataSizeElement.getAttribute("numberBits");
            if (numberBits == null) continue;
            numberBits.setName("value");
            Attribute unit = new Attribute("unit", "bit");
            dataSizeElement.setAttribute(unit);
        }
    }

    private String encodeSectionName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = name;
        }
        return result;
    }
}

