/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters071.utils.HelperUtils_070_071;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SectionRunnableLabelCacheBuilder
implements ICache {
    private final Map<File, Map<String, Object>> map = new HashMap<File, Map<String, Object>>();
    private final HelperUtils_070_071 helper = HelperUtils_070_071.getInstance();

    public void buildCache(Map<File, Document> fileName_documentsMap) {
        for (File targetFile : fileName_documentsMap.keySet()) {
            Document document1 = fileName_documentsMap.get(targetFile);
            if (document1 == null) continue;
            Element rootElement = document1.getRootElement();
            this.getCacheMap().put(targetFile, new HashMap());
            HashMap<String, List<String>> label_Sections_Map = new HashMap<String, List<String>>();
            this.getCacheMap().get(targetFile).put(SectionRunnableLabelCacheEnum.Label_Sections.name(), label_Sections_Map);
            HashMap<String, List<String>> runnable_Sections_Map = new HashMap<String, List<String>>();
            this.getCacheMap().get(targetFile).put(SectionRunnableLabelCacheEnum.Runnable_Sections.name(), runnable_Sections_Map);
            ArrayList<String> section_Names = new ArrayList<String>();
            this.getCacheMap().get(targetFile).put(SectionRunnableLabelCacheEnum.Section_Names.name(), section_Names);
            HashMap<String, List<String>> labelUUID_Sections = new HashMap<String, List<String>>();
            this.getCacheMap().get(targetFile).put(SectionRunnableLabelCacheEnum.Label_UUID_Sections.name(), labelUUID_Sections);
            HashMap<String, List<String>> runnableUUID_Sections = new HashMap<String, List<String>>();
            this.getCacheMap().get(targetFile).put(SectionRunnableLabelCacheEnum.Runnable_UUID_Sections.name(), runnableUUID_Sections);
            List sectionElements = this.helper.getXpathResult(rootElement, "./swModel/sections", Element.class, new Namespace[]{this.helper.getNS_070("am")});
            for (Element sectionElement : sectionElements) {
                Attribute runEntitiesAttribute;
                String sectionName = sectionElement.getAttributeValue("name");
                section_Names.add(sectionName);
                Attribute labelsAttribute = sectionElement.getAttribute("labels");
                if (labelsAttribute != null) {
                    this.extract_MemoryElement_Section_Info(label_Sections_Map, sectionName, labelsAttribute, labelUUID_Sections);
                }
                if ((runEntitiesAttribute = sectionElement.getAttribute("runEntities")) != null) {
                    this.extract_MemoryElement_Section_Info(runnable_Sections_Map, sectionName, runEntitiesAttribute, runnableUUID_Sections);
                }
                List labelElements = sectionElement.getChildren("labels");
                for (Element element : labelElements) {
                    this.extract_MemoryElement_Section_Info(label_Sections_Map, sectionName, element, labelUUID_Sections);
                }
                List runnableElements = sectionElement.getChildren("runEntities");
                for (Element element : runnableElements) {
                    this.extract_MemoryElement_Section_Info(runnable_Sections_Map, sectionName, element, runnableUUID_Sections);
                }
            }
        }
    }

    private void extract_MemoryElement_Section_Info(Map<String, List<String>> memoryElement_Sections_Map, String sectionName, Attribute memoryElementAttribute, Map<String, List<String>> memMElementUUID_Sections) {
        String memoryElementAttributeValue = memoryElementAttribute.getValue();
        StringTokenizer stk = new StringTokenizer(memoryElementAttributeValue);
        while (stk.hasMoreTokens()) {
            String memoryElementReferenceString = stk.nextToken();
            int lastIndexOf = memoryElementReferenceString.lastIndexOf("?");
            if (lastIndexOf != -1) {
                String memoryElementName = memoryElementReferenceString.substring(0, lastIndexOf);
                this.addEntry(memoryElement_Sections_Map, memoryElementName, sectionName);
                continue;
            }
            List<String> list = memMElementUUID_Sections.get(memoryElementReferenceString);
            if (list == null) {
                list = new ArrayList<String>();
                memMElementUUID_Sections.put(memoryElementReferenceString, list);
            }
            list.add(sectionName);
        }
    }

    private void extract_MemoryElement_Section_Info(Map<String, List<String>> memoryElement_Sections_Map, String sectionName, Element memoryElement, Map<String, List<String>> memElementUUID_Sections) {
        String memoryElementAttributeValue = memoryElement.getAttributeValue("href");
        if (memoryElementAttributeValue != null) {
            int indexOfHash = memoryElementAttributeValue.lastIndexOf("#");
            int indexOfQuestionmark = memoryElementAttributeValue.lastIndexOf("?");
            if (indexOfHash != -1 && indexOfQuestionmark != -1) {
                String memroyElementName = memoryElementAttributeValue.substring(indexOfHash + 1, indexOfQuestionmark);
                this.addEntry(memoryElement_Sections_Map, memroyElementName, sectionName);
            } else if (indexOfHash != -1) {
                String memoryElementID = memoryElementAttributeValue.substring(indexOfHash + 1);
                List<String> list = memElementUUID_Sections.get(memoryElementID);
                if (list == null) {
                    list = new ArrayList<String>();
                    memElementUUID_Sections.put(memoryElementID, list);
                }
                list.add(sectionName);
            }
        }
    }

    private void addEntry(Map<String, List<String>> memoryElement_Sections_Map, String memoryElementName, String sectionName) {
        if (!memoryElement_Sections_Map.containsKey(memoryElementName)) {
            memoryElement_Sections_Map.put(memoryElementName, new ArrayList());
        }
        memoryElement_Sections_Map.get(memoryElementName).add(sectionName);
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

