/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters072.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters072.utils.HelperUtils_071_072;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CommonElementsConverter
extends AbstractConverter {
    public CommonElementsConverter() {
        this.helper = HelperUtils_071_072.getInstance();
        this.logger = LogManager.getLogger(this.getClass());
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)"Migration from 0.7.1 to 0.7.2 : Starting \"Common Elements\" converter");
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateCommonElements(rootElement);
    }

    private void updateCommonElements(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./componentsModel/tags");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel/tags");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tags");
        List tagElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        if (tagElements.size() > 0) {
            Element commonElements = rootElement.getChild("commonElements");
            if (commonElements == null) {
                commonElements = new Element("commonElements");
                rootElement.addContent((Content)commonElements);
            }
            for (Element tagElement : tagElements) {
                Element parentElement = tagElement.getParentElement();
                parentElement.removeContent((Content)tagElement);
                commonElements.addContent((Content)tagElement);
            }
        }
    }
}

