/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters072.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters072.utils.HelperUtils_071_072;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ConstraintsConverter
extends AbstractConverter {
    public ConstraintsConverter() {
        this.helper = HelperUtils_071_072.getInstance();
        this.logger = LogManager.getLogger(this.getClass());
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)"Migration from 0.7.1 to 0.7.2 : Starting Constraints converter");
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_AffinityConstraints(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_AffinityConstraints(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./constraintsModel/affinityConstraints");
        List affinityConstraintElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element affinityConstraintElement : affinityConstraintElements) {
            String targetType;
            Element targetElement;
            String type = affinityConstraintElement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            if (type == null) continue;
            Element childElement = null;
            if (type.equals("am:RunnablePairingConstraint")) {
                childElement = affinityConstraintElement.getChild("runnables");
            } else if (type.equals("am:ProcessPairingConstraint")) {
                childElement = affinityConstraintElement.getChild("processes");
            } else if (type.equals("am:DataPairingConstraint")) {
                childElement = affinityConstraintElement.getChild("labels");
            }
            if (childElement != null) {
                childElement.setName("group");
            }
            if ((targetElement = affinityConstraintElement.getChild("target")) == null || (targetType = targetElement.getAttributeValue("type", this.helper.getGenericNS("xsi"))) == null || !targetType.equals("am:TargetCallSequence") && !targetType.equals("am:TargetProcess")) continue;
            affinityConstraintElement.removeContent((Content)targetElement);
        }
    }
}

