/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters072.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters072.utils.HelperUtils_071_072;
import org.eclipse.app4mc.amalthea.converters072.utils.HwElementsCacheBuilder;
import org.eclipse.app4mc.amalthea.converters072.utils.HwElementsCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PropertyConstraintsConverter
extends AbstractConverter {
    private List<ICache> caches;
    private Map<File, Document> fileName_documentsMap;
    private File targetFile;
    private Map.Entry<File, Element> firstOccuranceOfHwModelInModelScope;
    private HwElementsCacheBuilder hwElementsCacheBuilder;

    public PropertyConstraintsConverter() {
        this.helper = HelperUtils_071_072.getInstance();
        this.logger = LogManager.getLogger(this.getClass());
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)"Migration from 0.7.1 to 0.7.2 : Starting PropertyConstraints converter");
        this.caches = caches;
        this.fileName_documentsMap = fileName_documentsMap;
        this.targetFile = targetFile;
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.remove_CoreTypes_MemoryTypes(rootElement);
        this.update_Core_Refs(rootElement);
        this.update_Memory_Refs(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void remove_CoreTypes_MemoryTypes(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./propertyConstraintsModel");
        List propertyConstraintsModelElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        if (propertyConstraintsModelElements.size() > 0) {
            Element propertyConstraintsModel = (Element)propertyConstraintsModelElements.get(0);
            List coreTypeDefinitions = propertyConstraintsModel.getChildren("coreTypeDefinitions");
            Iterator coreTypesIterator = coreTypeDefinitions.iterator();
            while (coreTypesIterator.hasNext()) {
                Element coreTypeDefinition = (Element)coreTypesIterator.next();
                String coreTypeName = coreTypeDefinition.getAttributeValue("name");
                coreTypesIterator.remove();
                propertyConstraintsModel.removeContent((Content)coreTypeDefinition);
                if (coreTypeName == null || this.isHWElementPresentInCache(HwElementsCacheEnum.CORE_TYPE_NAMES, coreTypeName)) continue;
                Map.Entry<File, Element> entry = this.getFirstOccuranceOfHwModelFromModelFiles();
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                coreTypeDefinition.setName("coreTypes");
                hwModelElement.addContent((Content)coreTypeDefinition);
                List coreTypeNames = (List)this.getHwElementsCacheBuilder().getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.CORE_TYPE_NAMES.name());
                coreTypeNames.add(coreTypeName);
            }
            List memoryTypeDefinitions = propertyConstraintsModel.getChildren("memoryTypeDefinitions");
            Iterator memoryTypesIterator = memoryTypeDefinitions.iterator();
            while (memoryTypesIterator.hasNext()) {
                Element memoryTypeDefinition = (Element)memoryTypesIterator.next();
                String memoryTypeName = memoryTypeDefinition.getAttributeValue("name");
                memoryTypesIterator.remove();
                propertyConstraintsModel.removeContent((Content)memoryTypeDefinition);
                if (memoryTypeName == null || this.isHWElementPresentInCache(HwElementsCacheEnum.MEMORY_TYPE_NAMES, memoryTypeName)) continue;
                Map.Entry<File, Element> entry = this.getFirstOccuranceOfHwModelFromModelFiles();
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                memoryTypeDefinition.setName("memoryTypes");
                hwModelElement.addContent((Content)memoryTypeDefinition);
                List memoryTypeNames = (List)this.getHwElementsCacheBuilder().getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.MEMORY_TYPE_NAMES.name());
                memoryTypeNames.add(memoryTypeName);
            }
        }
    }

    private void update_Memory_Refs(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./propertyConstraintsModel//firstConstraint[@xsi:type=\"am:HwMemoryProperty\"]/memory");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//secondConstraint[@xsi:type=\"am:HwMemoryProperty\"]/memory");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//hwConstraint[@xsi:type=\"am:HwMemoryProperty\"]/memory");
        List memoryElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element memoryElement : memoryElements) {
            String memoryName = memoryElement.getAttributeValue("name");
            Element parent = memoryElement.getParentElement();
            parent.removeContent((Content)memoryElement);
            if (memoryName == null) continue;
            if (!this.isHWElementPresentInCache(HwElementsCacheEnum.MEMORY_NAMES, memoryName)) {
                Map.Entry<File, Element> entry = this.getFirstOccuranceOfHwModelFromModelFiles();
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                Element system = hwModelElement.getChild("system");
                if (system == null) {
                    system = new Element("system");
                    system.setAttribute("name", "migration_gen_system");
                    hwModelElement.addContent((Content)system);
                }
                Element genMemoryElement = new Element("memories");
                genMemoryElement.setAttribute("name", memoryName);
                system.addContent((Content)genMemoryElement);
                List memoryNames = (List)this.getHwElementsCacheBuilder().getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.MEMORY_NAMES.name());
                memoryNames.add(memoryName);
            }
            if (this.isElementDefinedInFile(memoryName, HwElementsCacheEnum.MEMORY_NAMES, this.targetFile)) {
                parent.setAttribute(new Attribute("memory", String.valueOf(this.encodeName(memoryName)) + "?type=Memory"));
                continue;
            }
            Element refMemoryElement = new Element("memory");
            refMemoryElement.setAttribute("href", "amlt:/#" + this.encodeName(memoryName) + "?type=Memory");
            parent.addContent((Content)refMemoryElement);
        }
    }

    private void update_Core_Refs(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./propertyConstraintsModel//firstConstraint[@xsi:type=\"am:HwCoreProperty\"]/core");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//secondConstraint[@xsi:type=\"am:HwCoreProperty\"]/core");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//hwConstraint[@xsi:type=\"am:HwCoreProperty\"]/core");
        List coreElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element coreElement : coreElements) {
            String coreName = coreElement.getAttributeValue("name");
            Element parent = coreElement.getParentElement();
            parent.removeContent((Content)coreElement);
            if (coreName == null) continue;
            if (!this.isHWElementPresentInCache(HwElementsCacheEnum.CORE_NAMES, coreName)) {
                Element ecus;
                List ecuElements;
                Map.Entry<File, Element> entry = this.getFirstOccuranceOfHwModelFromModelFiles();
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                Element system = hwModelElement.getChild("system");
                if (system == null) {
                    system = new Element("system");
                    system.setAttribute("name", "migration_gen_system");
                    hwModelElement.addContent((Content)system);
                }
                if ((ecuElements = this.helper.getXpathResult(system, ".//ecus[@name=\"migration_gen_ecu\"]", Element.class, new Namespace[0])).size() > 0) {
                    ecus = (Element)ecuElements.get(0);
                    List microControllersList = ecus.getChildren("microcontrollers");
                    for (Element microControllers : microControllersList) {
                        String microControllerName = microControllers.getAttributeValue("name");
                        if (microControllerName == null || !microControllerName.equals("migration_gen_microcontroller")) continue;
                        coreElement.setName("cores");
                        microControllers.addContent((Content)coreElement);
                        break;
                    }
                } else {
                    ecus = new Element("ecus");
                    ecus.setAttribute("name", "migration_gen_ecu");
                    system.addContent((Content)ecus);
                    Element microControllers = new Element("microcontrollers");
                    microControllers.setAttribute("name", "migration_gen_microcontroller");
                    ecus.addContent((Content)microControllers);
                    coreElement.setName("cores");
                    microControllers.addContent((Content)coreElement);
                }
                List coreNames = (List)this.getHwElementsCacheBuilder().getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.CORE_NAMES.name());
                coreNames.add(coreName);
            }
            if (this.isElementDefinedInFile(coreName, HwElementsCacheEnum.CORE_NAMES, this.targetFile)) {
                parent.setAttribute(new Attribute("core", String.valueOf(this.encodeName(coreName)) + "?type=Core"));
                continue;
            }
            Element refCoreElement = new Element("core");
            refCoreElement.setAttribute("href", "amlt:/#" + this.encodeName(coreName) + "?type=Core");
            parent.addContent((Content)refCoreElement);
        }
    }

    private Map.Entry<File, Element> getFirstOccuranceOfHwModelFromModelFiles() {
        Element rootElement;
        if (this.firstOccuranceOfHwModelInModelScope != null) {
            return this.firstOccuranceOfHwModelInModelScope;
        }
        HwElementsCacheBuilder iCache = this.getHwElementsCacheBuilder();
        if (iCache == null) {
            throw new RuntimeException("HwElementsCache is not buit and Object of it is not available in Converters");
        }
        Map<File, Map<String, Object>> cacheMap = iCache.getCacheMap();
        Set<File> fileSet = this.fileName_documentsMap.keySet();
        TreeSet<File> sortedInputFileSet = new TreeSet<File>(fileSet);
        for (File file : sortedInputFileSet) {
            Map<String, Object> map = cacheMap.get(file);
            Object object = map.get(HwElementsCacheEnum.HwModel.name());
            if (!(object instanceof Element)) continue;
            this.firstOccuranceOfHwModelInModelScope = new AbstractMap.SimpleEntry<File, Element>(file, (Element)object);
            return this.firstOccuranceOfHwModelInModelScope;
        }
        File firstInputModelFile = sortedInputFileSet.first();
        Document document = this.fileName_documentsMap.get(firstInputModelFile);
        if (document != null && (rootElement = document.getRootElement()).getName().equals("Amalthea")) {
            Element hwModel = new Element("hwModel");
            rootElement.addContent((Content)hwModel);
            Map<String, Object> map = cacheMap.get(firstInputModelFile);
            map.put(HwElementsCacheEnum.HwModel.name(), hwModel);
            this.firstOccuranceOfHwModelInModelScope = new AbstractMap.SimpleEntry<File, Element>(firstInputModelFile, hwModel);
            return this.firstOccuranceOfHwModelInModelScope;
        }
        return null;
    }

    private boolean isHWElementPresentInCache(HwElementsCacheEnum type, String hwElementName) {
        HwElementsCacheBuilder iCache = this.getHwElementsCacheBuilder();
        if (iCache == null) {
            throw new RuntimeException("HwElementsCache is not buit and Object of it is not available in Converters");
        }
        Map<File, Map<String, Object>> cacheMap = iCache.getCacheMap();
        Set<File> fileSet = this.fileName_documentsMap.keySet();
        for (File file : fileSet) {
            Map<String, Object> map = cacheMap.get(file);
            Object object = map.get(type.name());
            if (!(object instanceof List) || !((List)object).contains(hwElementName)) continue;
            return true;
        }
        return false;
    }

    private HwElementsCacheBuilder getHwElementsCacheBuilder() {
        if (this.hwElementsCacheBuilder == null) {
            for (ICache cache : this.caches) {
                if (!(cache instanceof HwElementsCacheBuilder)) continue;
                this.hwElementsCacheBuilder = (HwElementsCacheBuilder)cache;
                return this.hwElementsCacheBuilder;
            }
        }
        return this.hwElementsCacheBuilder;
    }

    private String encodeName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = name;
        }
        return result;
    }

    private boolean isElementDefinedInFile(String elementName, HwElementsCacheEnum elementsType, File inputFile) {
        Object object;
        HwElementsCacheBuilder iCache = this.getHwElementsCacheBuilder();
        Map<File, Map<String, Object>> cacheMap = iCache.getCacheMap();
        Map<String, Object> map = cacheMap.get(inputFile);
        return map != null && (object = map.get(elementsType.name())) instanceof List && ((List)object).contains(elementName);
    }
}

