/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters110.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.Tags;
import org.eclipse.app4mc.amalthea.converters110.utils.HelperUtils_103_110;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OsConverter
implements IConverter {
    private final HelperUtils_103_110 helper;

    public OsConverter() {
        this.helper = HelperUtils_103_110.getInstance();
    }

    public OsConverter(HelperUtils_103_110 helper) {
        this.helper = helper;
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_110(rootElement);
        this.createOperatingSystem(root);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void createOperatingSystem(Document root) {
        List schedulers = this.helper.getXpathResult(root, ".//os:OSModel/scheduler", Element.class, new Namespace[]{this.helper.getNS_110("os")});
        if (schedulers.size() == 0) {
            schedulers = this.helper.getXpathResult(root, ".//osModel/scheduler", Element.class, new Namespace[]{this.helper.getNS_110("os")});
        }
        if (schedulers != null && schedulers.size() > 0) {
            Element parentElement = ((Element)schedulers.get(0)).getParentElement();
            int indexOfFirstScheduler = parentElement.indexOf((Content)schedulers.get(0));
            Element operatingSystem = new Element(Tags.operatingSystems.getValue());
            Attribute osNameAttrib = new Attribute("name", "OperatingSystem");
            operatingSystem.setAttribute(osNameAttrib);
            parentElement.addContent(indexOfFirstScheduler, (Content)operatingSystem);
            for (Element scheduler : schedulers) {
                scheduler.detach();
                scheduler.setName("taskSchedulers");
                operatingSystem.addContent((Content)scheduler);
                this.updateAttribute_DeadlineMonotonic(scheduler);
            }
        }
    }

    private void updateAttribute_DeadlineMonotonic(Element schedulerElement) {
        List osTypeList = this.helper.getXpathResult(schedulerElement, "./schedulingAlgorithm/@xsi:type[.=\"os:DeadlineMonotinic\"]", Attribute.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Attribute attribute : osTypeList) {
            attribute.setValue("os:DeadlineMonotonic");
        }
    }
}

