/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ComponentConverter
implements IConverter {
    private final HelperUtils_110_111 helper = HelperUtils_110_111.getInstance();

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_111(rootElement);
        this.helper.addAdditionalNameSpace(rootElement, new Namespace[]{this.helper.getNS_111("components")});
        this.updateEnum_InterfaceKind(rootElement);
        this.update_ComponentModel(rootElement);
        this.update_ISystem(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_ISystem(Element rootElement) {
        List componentInstances = this.helper.getXpathResult(rootElement, ".//elements[(@xsi:type=\"components:ComponentInstance\")]", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getGenericNS("xsi")});
        for (Element element : componentInstances) {
            element.setName("componentInstances");
            element.removeAttribute("type", this.helper.getGenericNS("xsi"));
        }
        List connectors = this.helper.getXpathResult(rootElement, ".//elements[(@xsi:type=\"components:Connector\")]", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getGenericNS("xsi")});
        for (Element element : connectors) {
            element.setName("connectors");
            element.removeAttribute("type", this.helper.getGenericNS("xsi"));
        }
    }

    private void update_ComponentModel(Element rootElement) {
        List components = this.helper.getXpathResult(rootElement, ".//elements[(@xsi:type=\"components:Component\")]", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getGenericNS("xsi")});
        for (Element element : components) {
            element.setName("components");
            element.removeAttribute("type", this.helper.getGenericNS("xsi"));
        }
        List composites = this.helper.getXpathResult(rootElement, ".//elements[(@xsi:type=\"components:Composite\")]", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getGenericNS("xsi")});
        for (Element element : composites) {
            element.setName("components");
        }
        List systems = this.helper.getXpathResult(rootElement, ".//elements[(@xsi:type=\"components:System\")]", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getGenericNS("xsi")});
        for (Element element : systems) {
            element.setName("systems");
            element.removeAttribute("type", this.helper.getGenericNS("xsi"));
        }
    }

    private void updateEnum_InterfaceKind(Element rootElement) {
        List ports = this.helper.getXpathResult(rootElement, ".//ports[(@xsi:type=\"components:FInterfacePort\") and not(@kind)]", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getGenericNS("xsi")});
        for (Element port : ports) {
            port.setAttribute("kind", "PROVIDES");
        }
    }
}

