/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.impl;

import com.google.common.collect.Table;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters111.utils.CacheEnum;
import org.eclipse.app4mc.amalthea.converters111.utils.ComponentModelRefsCacheBuilder;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class ComponentModelRefsConverter
implements IConverter {
    private final HelperUtils_110_111 helper;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public ComponentModelRefsConverter() {
        this.helper = HelperUtils_110_111.getInstance();
    }

    public ComponentModelRefsConverter(HelperUtils_110_111 helper) {
        this.helper = helper;
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        for (ICache cache : this.getFilteredCaches(caches, new Class[]{ComponentModelRefsCacheBuilder.class})) {
            for (File file : fileName_documentsMap.keySet()) {
                Map cacheMap = (Map)cache.getCacheMap().get(file);
                if (cacheMap == null) continue;
                Map uriFragment_component_map = (Map)cacheMap.get(CacheEnum.URIFRAGMENT_ELEMENT.name());
                Map uriFragment_component_attribs_map = (Map)cacheMap.get(CacheEnum.URIFRAGMENT_ELEMENT_REFS_ATRIBUTES.name());
                if (uriFragment_component_attribs_map == null || uriFragment_component_map == null) continue;
                for (String uriFragment : uriFragment_component_map.keySet()) {
                    Element element = (Element)uriFragment_component_map.get(uriFragment);
                    String updated_uriFragment = this.helper.getURIFragment(element, ModelVersion._111);
                    this.logger.info((Object)(String.valueOf(uriFragment) + " : : " + element + " : : " + updated_uriFragment));
                    List list = (List)uriFragment_component_attribs_map.get(uriFragment);
                    for (Attribute attribute : list) {
                        attribute.setValue(updated_uriFragment);
                    }
                }
                Map href_uriFragment_component_map = (Map)cacheMap.get(CacheEnum.HREF_URIFRAGMENT_ELEMENT.name());
                Map href_urifragment_attributesMap = (Map)cacheMap.get(CacheEnum.HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES.name());
                for (String href_uriFragment : href_uriFragment_component_map.keySet()) {
                    Element componentElement = (Element)href_uriFragment_component_map.get(href_uriFragment);
                    String updated_uriFragment = this.helper.getURIFragment(componentElement, ModelVersion._111);
                    List<Attribute> attributes = this.getAttributes(href_urifragment_attributesMap, href_uriFragment);
                    for (Attribute attribute : attributes) {
                        String[] split = href_uriFragment.split("#");
                        attribute.setValue(String.valueOf(split[0]) + "#" + updated_uriFragment);
                    }
                }
            }
        }
        for (ICache cache : caches) {
            if (!(cache instanceof ComponentModelRefsCacheBuilder)) continue;
            ((ComponentModelRefsCacheBuilder)cache).updateURIFragments_in_Cache(fileName_documentsMap);
        }
    }

    private List<Attribute> getAttributes(Map<File, Table<String, String, List<Attribute>>> href_urifragment_attributesMap, String uriFragment) {
        for (File referenceFile : href_urifragment_attributesMap.keySet()) {
            Set keySet;
            Iterator iterator;
            Map map;
            Table<String, String, List<Attribute>> table = href_urifragment_attributesMap.get(referenceFile);
            if (table == null || (map = table.row((Object)uriFragment)) == null || map.size() <= 0 || !(iterator = (keySet = map.keySet()).iterator()).hasNext()) continue;
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            return list;
        }
        return new ArrayList<Attribute>();
    }
}

