/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ConstraintsConverter
implements IConverter {
    private final HelperUtils_110_111 helper = HelperUtils_110_111.getInstance();

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_111(rootElement);
        this.update_DataAgeCycle(rootElement);
        this.updateEnum_RunnableOrderType(rootElement);
        this.updateEnum_RunnableGroupingType(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_DataAgeCycle(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("(.//dataAge/@maximumCyle)");
        List constraints = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("propertyconstraints"), this.helper.getGenericNS("xsi")});
        for (Attribute attribute : constraints) {
            attribute.setName("maximumCycle");
        }
    }

    private void updateEnum_RunnableOrderType(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("(.//constraintsModel/runnableSequencingConstraints[not(@orderType)])");
        xpathBuffer.append("|");
        xpathBuffer.append("(./constraints:ConstraintsModel/runnableSequencingConstraints[not(@orderType)])");
        List constraints = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("constraints"), this.helper.getGenericNS("xsi")});
        for (Element constraint : constraints) {
            constraint.setAttribute("orderType", "successor");
        }
    }

    private void updateEnum_RunnableGroupingType(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("(.//constraintsModel/runnableSequencingConstraints/runnableGroups[not(@groupingType)])");
        xpathBuffer.append("|");
        xpathBuffer.append("(./constraints:ConstraintsModel/runnableSequencingConstraints/runnableGroups[not(@groupingType)])");
        List constraints = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("constraints"), this.helper.getGenericNS("xsi")});
        for (Element constraint : constraints) {
            constraint.setAttribute("groupingType", "allOfThem");
        }
    }
}

