/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HwConverter
implements IConverter {
    private final HelperUtils_110_111 helper = HelperUtils_110_111.getInstance();

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_111(rootElement);
        this.helper.addAdditionalNameSpace(rootElement, new Namespace[]{this.helper.getNS_111("os")});
        this.updateEnum_QType(rootElement);
        this.updateEnum_MemoryType(rootElement);
        this.updateEnum_BusType(rootElement);
        this.updateEnum_RWType(rootElement);
        this.updateEnum_SchedType(rootElement);
        this.updateEnum_PinType(rootElement);
        this.updateEnum_FeatureType(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateEnum_QType(Element rootElement) {
        List quartzElements = this.helper.getXpathResult(rootElement, ".//quartzes[not(@type)]|/hw:Quartz[not(@type)]", Element.class, new Namespace[]{this.helper.getNS_111("hw")});
        for (Element quartzElement : quartzElements) {
            quartzElement.setAttribute("type", "DYNAMIC");
        }
    }

    private void updateEnum_MemoryType(Element rootElement) {
        List quartzElements = this.helper.getXpathResult(rootElement, ".//memoryTypes[not(@type)]|.//memTypeDefinitions[not(@type)]|/hw:MemType[not(@type)]", Element.class, new Namespace[]{this.helper.getNS_111("hw")});
        for (Element quartzElement : quartzElements) {
            quartzElement.setAttribute("type", "RAM");
        }
    }

    private void updateEnum_BusType(Element rootElement) {
        List quartzElements = this.helper.getXpathResult(rootElement, ".//networkTypes[(@xsi:type=\"hw:Bus\") and not(@busType)]|/hw:Bus[not(@busType)]", Element.class, new Namespace[]{this.helper.getNS_111("hw"), this.helper.getGenericNS("xsi")});
        for (Element quartzElement : quartzElements) {
            quartzElement.setAttribute("busType", "CAN");
        }
    }

    private void updateEnum_RWType(Element rootElement) {
        List quartzElements = this.helper.getXpathResult(rootElement, ".//ports[(@xsi:type=\"hw:ComplexPort\") and not(@direction)]|.//pins[(@xsi:type=\"hw:ComplexPin\") and not(@direction)]|/hw:ComplexPort[not(@direction)]|/hw:ComplexPin[not(@direction)]", Element.class, new Namespace[]{this.helper.getNS_111("hw"), this.helper.getGenericNS("xsi")});
        for (Element quartzElement : quartzElements) {
            quartzElement.setAttribute("direction", "R");
        }
    }

    private void updateEnum_SchedType(Element rootElement) {
        List quartzElements = this.helper.getXpathResult(rootElement, ".//networkTypes[not(@schedPolicy)]|/hw:NetworkType[not(@schedPolicy)]", Element.class, new Namespace[]{this.helper.getNS_111("hw")});
        for (Element quartzElement : quartzElements) {
            quartzElement.setAttribute("schedPolicy", "RROBIN");
        }
    }

    private void updateEnum_PinType(Element rootElement) {
        List quartzElements = this.helper.getXpathResult(rootElement, ".//pins[(@xsi:type=\"hw:ComplexPin\") and not(@type)]|/hw:ComplexPin[not(@type)]", Element.class, new Namespace[]{this.helper.getNS_111("hw"), this.helper.getGenericNS("xsi")});
        for (Element quartzElement : quartzElements) {
            quartzElement.setAttribute("type", "ANALOG");
        }
    }

    private void updateEnum_FeatureType(Element rootElement) {
        List quartzElements = this.helper.getXpathResult(rootElement, ".//features[(@xsi:type=\"hw:FeatureTypes\") and  not(@value)]|/hw:FeatureTypes[not(@value)]", Element.class, new Namespace[]{this.helper.getNS_111("hw"), this.helper.getGenericNS("xsi")});
        for (Element quartzElement : quartzElements) {
            quartzElement.setAttribute("value", "floatingPointUnit");
        }
    }
}

