/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters111.utils.CacheEnum;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.eclipse.app4mc.amalthea.converters111.utils.LabelValueProviderRefsCacheBuilder;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;

public class StimuliConverter
implements IConverter {
    private final HelperUtils_110_111 helper = HelperUtils_110_111.getInstance();
    private List<ICache> caches;
    private String workingDirectoryLocation;
    private File targetFile;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private int modeCount = 1;

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.caches = caches;
        this.targetFile = targetFile;
        this.workingDirectoryLocation = targetFile.getParentFile().getCanonicalPath();
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_111(rootElement);
        this.helper.addAdditionalNameSpace(rootElement, new Namespace[]{this.helper.getNS_111("stimuli")});
        this.update_VariableRefs_inside_Stimulus(rootElement);
        this.update_ModeLiteral_References(rootElement);
        this.update_ModeLabel_References(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_ModeLabel_References(Element rootElement) throws Exception {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("(.//entries/@valueProvider)");
        HashMap<String, String> localModeLabelsMap = new HashMap<String, String>();
        List valueLabelProvidersRefs = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("stimuli"), this.helper.getGenericNS("xsi")});
        for (Attribute attribute : valueLabelProvidersRefs) {
            String value = attribute.getValue();
            String modeLabelID = "";
            if (!localModeLabelsMap.containsKey(value)) {
                Element label;
                if (value.contains("//")) {
                    label = this.getLabel(value, true);
                    if (label == null) continue;
                    modeLabelID = this.createModeLabel(label);
                    localModeLabelsMap.put(value, modeLabelID);
                } else {
                    label = this.getLabel(value, false);
                    if (label == null) continue;
                    modeLabelID = this.createModeLabel(label);
                    localModeLabelsMap.put(value, modeLabelID);
                }
            } else {
                modeLabelID = (String)localModeLabelsMap.get(value);
            }
            if (modeLabelID == null || modeLabelID.length() <= 0) continue;
            attribute.setValue(modeLabelID);
        }
        StringBuffer xpathHREFBuffer = new StringBuffer();
        xpathHREFBuffer.append("(.//entries/valueProvider/@href)");
        List hRefs = this.helper.getXpathResult(rootElement, xpathHREFBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("stimuli"), this.helper.getGenericNS("xsi")});
        for (Attribute attribute : hRefs) {
            String value = attribute.getValue();
            String modeLabelID = "";
            if (!localModeLabelsMap.containsKey(value)) {
                Element label = this.getLabelFromHRef(value);
                if (label == null) continue;
                modeLabelID = String.valueOf(value.split("#")[0]) + "#" + this.createModeLabel(label);
                localModeLabelsMap.put(value, modeLabelID);
            } else {
                modeLabelID = (String)localModeLabelsMap.get(value);
            }
            if (modeLabelID == null || modeLabelID.length() <= 0) continue;
            attribute.setValue(modeLabelID);
            Element parent = attribute.getParent();
            parent.removeAttribute("type", this.helper.getGenericNS("xsi"));
            parent.setAttribute("type", "sw:ModeLabel", this.helper.getGenericNS("xsi"));
        }
    }

    private void update_VariableRefs_inside_Stimulus(Element rootElement) {
        StringBuffer enablingLabelsList_xpathBuffer = new StringBuffer();
        StringBuffer disablingLabelsList_xpathBuffer = new StringBuffer();
        disablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Periodic\")]/disablingLabelsList)");
        disablingLabelsList_xpathBuffer.append("|");
        disablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:ArrivalCurve\")]/disablingLabelsList)");
        disablingLabelsList_xpathBuffer.append("|");
        disablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:CustomStimulus\")]/disablingLabelsList)");
        disablingLabelsList_xpathBuffer.append("|");
        disablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:InterProcess\")]/disablingLabelsList)");
        disablingLabelsList_xpathBuffer.append("|");
        disablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:PeriodicEvent\")]/disablingLabelsList)");
        disablingLabelsList_xpathBuffer.append("|");
        disablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Single\")]/disablingLabelsList)");
        disablingLabelsList_xpathBuffer.append("|");
        disablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Sporadic\")]/disablingLabelsList)");
        enablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Periodic\")]/enablingLabelsList)");
        enablingLabelsList_xpathBuffer.append("|");
        enablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:ArrivalCurve\")]/enablingLabelsList)");
        enablingLabelsList_xpathBuffer.append("|");
        enablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:CustomStimulus\")]/enablingLabelsList)");
        enablingLabelsList_xpathBuffer.append("|");
        enablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:InterProcess\")]/enablingLabelsList)");
        enablingLabelsList_xpathBuffer.append("|");
        enablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:PeriodicEvent\")]/enablingLabelsList)");
        enablingLabelsList_xpathBuffer.append("|");
        enablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Single\")]/enablingLabelsList)");
        enablingLabelsList_xpathBuffer.append("|");
        enablingLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Sporadic\")]/enablingLabelsList)");
        StringBuffer setLabelsList_xpathBuffer = new StringBuffer();
        setLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Periodic\")]/setLabelsList)");
        setLabelsList_xpathBuffer.append("|");
        setLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:ArrivalCurve\")]/setLabelsList)");
        setLabelsList_xpathBuffer.append("|");
        setLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:CustomStimulus\")]/setLabelsList)");
        setLabelsList_xpathBuffer.append("|");
        setLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:InterProcess\")]/setLabelsList)");
        setLabelsList_xpathBuffer.append("|");
        setLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:PeriodicEvent\")]/setLabelsList)");
        setLabelsList_xpathBuffer.append("|");
        setLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Single\")]/setLabelsList)");
        setLabelsList_xpathBuffer.append("|");
        setLabelsList_xpathBuffer.append("(.//stimuli[(@xsi:type=\"stimuli:Sporadic\")]/setLabelsList)");
        List setLabelsList = this.helper.getXpathResult(rootElement, setLabelsList_xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("stimuli"), this.helper.getGenericNS("xsi")});
        for (Element element : setLabelsList) {
            element.setName("setModeValueList");
        }
        List enablingLabelsList = this.helper.getXpathResult(rootElement, enablingLabelsList_xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("stimuli"), this.helper.getGenericNS("xsi")});
        for (Element element : enablingLabelsList) {
            element.setName("enablingModeValueList");
        }
        List disablingLabelsList = this.helper.getXpathResult(rootElement, disablingLabelsList_xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("stimuli"), this.helper.getGenericNS("xsi")});
        for (Element element : disablingLabelsList) {
            element.setName("disablingModeValueList");
        }
    }

    private Element getLabel(String labelReference, boolean iURIFragment) {
        for (ICache iCache : this.caches) {
            if (!(iCache instanceof LabelValueProviderRefsCacheBuilder)) continue;
            Set fileSet = iCache.getCacheMap().keySet();
            for (File file : fileSet) {
                Element element;
                Map cacheMap = (Map)iCache.getCacheMap().get(file);
                Object URIFRAGMENT_ELEMENT_Map = cacheMap.get(CacheEnum.URIFRAGMENT_ELEMENT.name());
                Object UUID_ELEMENT_Map = cacheMap.get(CacheEnum.UUID_ELEMENT.name());
                if (!(iURIFragment ? (element = (Element)((Map)URIFRAGMENT_ELEMENT_Map).get(labelReference)) != null && this.targetFile == file : (element = (Element)((Map)UUID_ELEMENT_Map).get(labelReference)) != null)) continue;
                return element;
            }
        }
        return null;
    }

    private Element getLabelFromHRef(String labelReference_with_fileName) throws Exception {
        boolean iURIFragment = false;
        String[] split = labelReference_with_fileName.split("#");
        if (split.length != 2) {
            return null;
        }
        String refFileName = split[0];
        String labelReference = split[1];
        if (labelReference.contains("//")) {
            iURIFragment = true;
        }
        if (iURIFragment) {
            for (ICache iCache : this.caches) {
                if (!(iCache instanceof LabelValueProviderRefsCacheBuilder)) continue;
                Set fileSet = iCache.getCacheMap().keySet();
                for (File file : fileSet) {
                    Map cacheMap = (Map)iCache.getCacheMap().get(file);
                    Object HREF_URIFRAGMENT_ELEMENT_Map = cacheMap.get(CacheEnum.HREF_URIFRAGMENT_ELEMENT.name());
                    Element element = (Element)((Map)HREF_URIFRAGMENT_ELEMENT_Map).get(labelReference_with_fileName);
                    if (element == null) continue;
                    return element;
                }
            }
        } else {
            String referencedFilePath = String.valueOf(this.workingDirectoryLocation) + File.separator + refFileName;
            File referenceFile = new File(referencedFilePath).getCanonicalFile();
            List filteredCaches = this.getFilteredCaches(this.caches, new Class[]{LabelValueProviderRefsCacheBuilder.class});
            for (LabelValueProviderRefsCacheBuilder labelValueProviderRefsCacheBuilder : filteredCaches) {
                Object UUID_ELEMENT_Map;
                Element element;
                Map cacheMap;
                if (iURIFragment || (cacheMap = (Map)labelValueProviderRefsCacheBuilder.getCacheMap().get(referenceFile)) == null || (element = (Element)((Map)(UUID_ELEMENT_Map = cacheMap.get(CacheEnum.UUID_ELEMENT.name()))).get(labelReference)) == null) continue;
                return element;
            }
        }
        return null;
    }

    private String createModeLabel(Element labelElement) {
        Parent parent = labelElement.getParent();
        Element element = new Element("modeLabels");
        element.setAttribute("name", labelElement.getAttributeValue("name"));
        String uuid = EcoreUtil.generateUUID();
        element.setAttribute("id", uuid, this.helper.getGenericNS("xmi"));
        parent.addContent((Content)element);
        return uuid;
    }

    private void update_ModeLiteral_References(Element rootElement) {
        HashMap<String, Element> element_LiteralMap = new HashMap<String, Element>();
        List swModels = this.helper.getXpathResult(rootElement, ".//swModel|/sw:SWModel", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        if (swModels.size() == 0) {
            System.err.println("sw-model not present, so can't associate individual ModeLiteral values");
            this.logger.error((Object)"Model Migration (1.1.0 to 1.1.1) -> sw-model not present, so can't associate individual ModeLiteral values which are part of ModeValueList");
            return;
        }
        List entryElements = this.helper.getXpathResult(rootElement, ".//stimuliModel/stimuli//entries|/stimuli:StimuliModel/stimuli//entries", Element.class, new Namespace[]{this.helper.getNS_111("stimuli"), this.helper.getGenericNS("xsi")});
        Element mode_migElement = null;
        if (entryElements.size() > 0) {
            mode_migElement = new Element("modes");
            mode_migElement.setAttribute("name", "mode_stimuli_" + this.modeCount++ + "_migration_generated");
            mode_migElement.setAttribute("id", EcoreUtil.generateUUID(), this.helper.getGenericNS("xmi"));
            ((Element)swModels.get(0)).addContent((Content)mode_migElement);
            for (Element entryElement : entryElements) {
                String value;
                boolean literalElementExists;
                Attribute modeSwitchEntry_value_attribute = entryElement.getAttribute("value");
                if (modeSwitchEntry_value_attribute == null) {
                    modeSwitchEntry_value_attribute = new Attribute("value", "0");
                    entryElement.setAttribute(modeSwitchEntry_value_attribute);
                }
                if (literalElementExists = element_LiteralMap.containsKey(value = modeSwitchEntry_value_attribute.getValue())) {
                    Element literalElement = (Element)element_LiteralMap.get(value);
                    String literal_uuid = literalElement.getAttributeValue("id", this.helper.getGenericNS("xmi"));
                    modeSwitchEntry_value_attribute.setValue(literal_uuid);
                    continue;
                }
                Element literals = new Element("literals");
                literals.setAttribute("name", value);
                String literalID = EcoreUtil.generateUUID();
                literals.setAttribute("id", literalID, this.helper.getGenericNS("xmi"));
                mode_migElement.addContent((Content)literals);
                modeSwitchEntry_value_attribute.setValue(literalID);
                element_LiteralMap.put(value, literals);
            }
        }
    }
}

