/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.base.IFormatter;
import org.eclipse.app4mc.amalthea.converters.common.base.IPreProcessor;
import org.eclipse.app4mc.amalthea.converters.common.utils.AbstractHelper;
import org.eclipse.app4mc.amalthea.converters.ui.utils.ConverterElement;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jdom2.Document;

public abstract class AbstractModelConverterHandler
extends AbstractHandler {
    protected AbstractHelper helper;
    protected Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea");

    protected void executeConversion(IConverter converter, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        for (File file : fileName_documentsMap.keySet()) {
            converter.convert(file, fileName_documentsMap, caches);
        }
    }

    protected Object getSelection(ExecutionEvent event) {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite((ExecutionEvent)event).getSelectionProvider().getSelection();
        if (selection == null) {
            return null;
        }
        return selection.getFirstElement();
    }

    protected IConfigurationElement[] getAllConverterExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters");
        IConfigurationElement[] extensions = extensionPoint.getConfigurationElements();
        return extensions;
    }

    protected List<ICache> getAllCacheObjectsFromExtensions(String inputModelVersion) throws CoreException {
        IConfigurationElement[] extensions;
        ArrayList<ICache> caches = new ArrayList<ICache>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters.cachebuilders");
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String definedInputModelVersion = iConfigurationElement.getAttribute("input-model-version");
            if (definedInputModelVersion.equals(inputModelVersion)) {
                Object cacheBuilder = iConfigurationElement.createExecutableExtension("class");
                caches.add((ICache)cacheBuilder);
            }
            ++n2;
        }
        return caches;
    }

    protected List<IPreProcessor> getAllPreProcessorObjectsFromExtensions(String ... inputModelVersions) throws CoreException {
        IConfigurationElement[] extensions;
        ArrayList<IPreProcessor> preProcessors = new ArrayList<IPreProcessor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters.preprocessor");
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            ArrayList<String> definedModelVersions = new ArrayList<String>();
            Object[] objectArray = children = iConfigurationElement.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement childConfigurationElement = objectArray[n4];
                String attrib = childConfigurationElement.getAttribute("version");
                if (attrib != null) {
                    definedModelVersions.add(attrib);
                }
                ++n4;
            }
            objectArray = inputModelVersions;
            n3 = inputModelVersions.length;
            n4 = 0;
            block2: while (n4 < n3) {
                IConfigurationElement inputModelVersion = objectArray[n4];
                for (String definedModelVersion : definedModelVersions) {
                    if (!definedModelVersion.equals(inputModelVersion)) continue;
                    Object preProcessor = iConfigurationElement.createExecutableExtension("class");
                    preProcessors.add((IPreProcessor)preProcessor);
                    break block2;
                }
                ++n4;
            }
            ++n2;
        }
        return preProcessors;
    }

    protected void invokeAllPreProcessors(List<IPreProcessor> preProcessors, Map<File, Document> fileName_documentsMap) throws Exception {
        for (IPreProcessor preProcessor : preProcessors) {
            for (File file : fileName_documentsMap.keySet()) {
                preProcessor.process(file, fileName_documentsMap);
            }
        }
    }

    protected void invokeAllCacheBuilders(List<ICache> caches, Map<File, Document> fileName_documentsMap) {
        for (ICache iCache : caches) {
            iCache.buildCache(fileName_documentsMap);
        }
    }

    protected Collection<ConverterElement> getEnabledConverterObjects(IConfigurationElement[] extensions, String inputModelVersion, String outputModelVersion) throws CoreException {
        HashMap<String, ConverterElement> converterElementsMap = new HashMap<String, ConverterElement>();
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String isEnabled = iConfigurationElement.getAttribute("enabled");
            if ("true".equals(isEnabled)) {
                String id = iConfigurationElement.getAttribute("id");
                String definedInputModelVersion = iConfigurationElement.getAttribute("input-model-version");
                String definedOutputModelVersion = iConfigurationElement.getAttribute("output-model-version");
                if (inputModelVersion.equals(definedInputModelVersion) && outputModelVersion.equals(definedOutputModelVersion)) {
                    IConfigurationElement[] children;
                    Object converterObject = iConfigurationElement.createExecutableExtension("converter-class");
                    ConverterElement converterElement = new ConverterElement(id, (IConverter)converterObject);
                    converterElementsMap.put(id, converterElement);
                    IConfigurationElement[] iConfigurationElementArray2 = children = iConfigurationElement.getChildren("dependent-on-converter");
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement childConfigurationElement = iConfigurationElementArray2[n4];
                        String dependentOnConverterID = childConfigurationElement.getAttribute("id");
                        if (dependentOnConverterID != null) {
                            converterElement.addDependentOnConverterID(dependentOnConverterID);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        if (converterElementsMap.size() > 0) {
            for (String converterID : converterElementsMap.keySet()) {
                ConverterElement converterElement = (ConverterElement)converterElementsMap.get(converterID);
                List<String> idsOfDependentOnConverters = converterElement.getIDSofDependentOnConverters();
                for (String idOfDependentOnConverter : idsOfDependentOnConverters) {
                    converterElement.addRequiredConverter((ConverterElement)converterElementsMap.get(idOfDependentOnConverter));
                }
            }
        }
        return converterElementsMap.values();
    }

    protected void invokeAllConvertersHeirarchially(Collection<ConverterElement> converterObjects, List<String> iconverters, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        for (ConverterElement converterElement : converterObjects) {
            if (converterElement.isCompleted() || iconverters.contains(converterElement.getID())) continue;
            List<ConverterElement> requiredConverters = converterElement.getRequiredConverters();
            this.invokeAllConvertersHeirarchially(requiredConverters, iconverters, fileName_documentsMap, caches);
            this.executeConversion(converterElement.getConverterObject(), fileName_documentsMap, caches);
            converterElement.setCompleted(true);
            iconverters.add(converterElement.getID());
        }
    }

    protected Collection<ConverterElement> executeConversion(Map<File, Document> fileName_documentsMap, String inputModelVersion, String outputModelVersion) throws CoreException, Exception {
        List<ICache> caches = this.getAllCacheObjectsFromExtensions(inputModelVersion);
        this.logger.info((Object)("start to build cache for models : " + inputModelVersion));
        long st = System.currentTimeMillis();
        this.invokeAllCacheBuilders(caches, fileName_documentsMap);
        long end = System.currentTimeMillis();
        this.logger.info((Object)("end of building cache for models " + inputModelVersion));
        this.logger.info((Object)("total time taken to build cache for " + inputModelVersion + " models:  " + (end - st)));
        IConfigurationElement[] allConverterExtensions = this.getAllConverterExtensions();
        Collection<ConverterElement> converterObjects = this.getEnabledConverterObjects(allConverterExtensions, inputModelVersion, outputModelVersion);
        this.invokeAllConvertersHeirarchially(converterObjects, new ArrayList<String>(), fileName_documentsMap, caches);
        return converterObjects;
    }

    protected IFormatter getModelFormatter() {
        IConfigurationElement[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters.formatter");
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                Object iConverter = iConfigurationElement.createExecutableExtension("class");
                return (IFormatter)iConverter;
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error occured during Object creation of Formatter class ", (Throwable)e);
                ++n2;
            }
        }
        return null;
    }
}

