/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.providers;

import java.io.File;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationInputFile;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class MigrationInputDataProvider
extends DelegatingStyledCellLabelProvider
implements IStructuredContentProvider {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public MigrationInputDataProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
        super(labelProvider);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        return new Object[]{inputElement};
    }

    public StyledString getStyledText(Object element) {
        MigrationInputFile migModelFile;
        File file;
        if (element instanceof MigrationInputFile && (file = (migModelFile = (MigrationInputFile)element).getFile()) != null) {
            try {
                String path = migModelFile.getMigrationSettings().getProject().toURI().relativize(file.toURI()).getPath();
                if (migModelFile.isSelectedFile()) {
                    return new StyledString(path, (StyledString.Styler)new BoldFontStyler());
                }
                return new StyledString(path);
            }
            catch (Exception e) {
                this.logger.warn((Object)("unable to build the relative path for file : " + file.getAbsolutePath()), (Throwable)e);
                return new StyledString(file.getAbsolutePath());
            }
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    class BoldFontStyler
    extends StyledString.Styler {
        BoldFontStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = new Color((Device)Display.getCurrent(), 0, 0, 255);
        }
    }

    class ItalicFontStyler
    extends StyledString.Styler {
        ItalicFontStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            Font italic;
            FontDescriptor italicDescriptor = FontDescriptor.createFrom((FontData)new FontData()).setStyle(2);
            textStyle.font = italic = italicDescriptor.createFont((Device)Display.getCurrent());
        }
    }
}

