/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.export.osek;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.app4mc.amalthea.export.osek.handlers.SchedulerToCoreMap;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class OsekMainWriter {
    private FileReader main = null;
    private BufferedReader brMain = null;
    private FileOutputStream mainStream = null;

    public boolean generateOutputMain(String filename, EList<Task> osekTasks, EList<TaskAllocation> taskAllocList, SchedulerToCoreMap coreAlloc, URI fileDir) throws IOException {
        String ausgabe = "";
        String mainFileName = String.valueOf(fileDir.toFileString()) + "\\06_Target\\" + filename + ".c";
        File theFile = new File(String.valueOf(fileDir.toFileString()) + "\\06_Target");
        theFile.mkdirs();
        try {
            this.main = new FileReader(String.valueOf(fileDir.toFileString()) + "\\.templates\\template.c");
            this.brMain = new BufferedReader(this.main);
            this.mainStream = new FileOutputStream(mainFileName);
            String mainZeile = "";
            String coreID = "";
            coreID = filename.toString() == "master" ? "e200z6" : "e200z0";
            System.out.println("Writing " + filename + ".c to location: " + fileDir.toFileString() + "\\06_Target\\");
            while ((mainZeile = this.brMain.readLine()) != null) {
                if (mainZeile.toString().equals("%%")) {
                    for (TaskAllocation currentExeAlloc : taskAllocList) {
                        if (!coreAlloc.isSchedulerMappedToCore((Scheduler)currentExeAlloc.getScheduler(), coreID)) continue;
                        Task taskAlloc = currentExeAlloc.getTask();
                        ausgabe = ausgabe.concat("DeclareTask(" + taskAlloc.getName().toString() + ");\n");
                    }
                    for (TaskAllocation currentExeAlloc : taskAllocList) {
                        if (!coreAlloc.isSchedulerMappedToCore((Scheduler)currentExeAlloc.getScheduler(), coreID)) continue;
                        Task taskAlloc = currentExeAlloc.getTask();
                        ausgabe = ausgabe.concat("\nTASK(" + taskAlloc.getName() + ")\n{\n");
                        EList callGraphEntries = taskAlloc.getCallGraph().getGraphEntries();
                        for (GraphEntryBase singleGraphEntrie : callGraphEntries) {
                            CallSequence taskCallSequence = (CallSequence)singleGraphEntrie;
                            EList callSequenceItem = taskCallSequence.getCalls();
                            for (CallSequenceItem runnableCall : callSequenceItem) {
                                TaskRunnableCall runnableAtThisTask = (TaskRunnableCall)runnableCall;
                                ausgabe = ausgabe.concat("\t" + runnableAtThisTask.getRunnable().getName() + "();\n");
                            }
                        }
                        ausgabe = ausgabe.concat("\n\tTerminateTask();\n}");
                    }
                    ausgabe = ausgabe.concat("\n");
                    ausgabe = ausgabe.concat("static void fixed_step_interrupt(void)\n{\n");
                    for (TaskAllocation currentExeAlloc : taskAllocList) {
                        if (!coreAlloc.isSchedulerMappedToCore((Scheduler)currentExeAlloc.getScheduler(), coreID)) continue;
                        Task taskAlloc = currentExeAlloc.getTask();
                        ausgabe = ausgabe.concat("\tActivateTask(" + taskAlloc.getName() + ");\n");
                    }
                    ausgabe = ausgabe.concat("\n\tPIT.TFLG3.R = 0x00000001;\n}");
                    continue;
                }
                if (mainZeile.toString().equals("%ISR")) {
                    if (filename.toString().equals("master")) {
                        ausgabe = ausgabe.concat("\tInitSystemClock(FSYS_100MHz);\n\n");
                        ausgabe = ausgabe.concat("\tEE_mpc5668_start_z0((void (*)(void))0x40020000);\n\n");
                        ausgabe = ausgabe.concat("\tEE_e200z7_register_ISR(168, fixed_step_interrupt, 2);\n");
                        ausgabe = ausgabe.concat("\t/* Set up the PIT (Extern Interrupt Request) with the\n");
                        ausgabe = ausgabe.concat("\t * COMPARE_VALUE, defined above */\n");
                        ausgabe = ausgabe.concat("\tInitPIT4(COMPARE_VALUE);");
                        continue;
                    }
                    if (!filename.toString().equals("slave")) continue;
                    ausgabe = ausgabe.concat("\tEE_e200z7_register_ISR(167, fixed_step_interrupt, 2);\n");
                    ausgabe = ausgabe.concat("\t/* Set up the PIT (Extern Interrupt Request) with the\n");
                    ausgabe = ausgabe.concat("\t * COMPARE_VALUE, defined above */\n");
                    ausgabe = ausgabe.concat("\tInitPIT3(COMPARE_VALUE);");
                    continue;
                }
                ausgabe = ausgabe.concat(String.valueOf(mainZeile) + "\n");
            }
            int j = 0;
            while (j < ausgabe.length()) {
                this.mainStream.write((byte)ausgabe.charAt(j));
                ++j;
            }
            System.out.println(String.valueOf(filename) + " generation successful!" + "\n");
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR, template file not found!\n");
            return true;
        }
        finally {
            OsekMainWriter.close(this.mainStream);
            OsekMainWriter.close(this.main);
            OsekMainWriter.close(this.brMain);
        }
    }

    private static void close(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

