/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.export.osek.handlers;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OsekGenerationGUI
extends TitleAreaDialog {
    String workingDirectory;
    private String initName;
    private String nameOfCompilation;
    private String pathToMappingModel;
    private String pathToOutput;
    private Text textProjectName;
    Text textMappingModelFile;

    public OsekGenerationGUI(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("OSEK Files");
    }

    protected Point getInitialSize() {
        return new Point(600, 250);
    }

    protected Control createDialogArea(final Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Label label1 = new Label(parent, 0);
        label1.setText("Name of the Project");
        this.textProjectName = new Text(parent, 2048);
        this.textProjectName.setLayoutData((Object)gridData);
        if (this.initName != null) {
            this.textProjectName.setText(this.initName);
        }
        new Label(parent, 0);
        Label label3 = new Label(parent, 0);
        label3.setText("Path to Mapping Model (*.amxmi; *.amxmi-mapping)");
        this.textMappingModelFile = new Text(parent, 2048);
        this.textMappingModelFile.setLayoutData((Object)gridData);
        Button btwSearchMappingModel = new Button(parent, 0);
        btwSearchMappingModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = parent.getShell();
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setText("Select Mapping Model");
                fileDialog.setFilterExtensions(new String[]{"*.amxmi; *.amxmi-mapping"});
                fileDialog.setFilterNames(new String[]{"(*.amxmi; *.amxmi-mapping)"});
                fileDialog.setFilterPath(OsekGenerationGUI.this.workingDirectory);
                String selected = fileDialog.open();
                OsekGenerationGUI.this.textMappingModelFile.setText(selected);
            }
        });
        btwSearchMappingModel.setText("Search");
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        parent.setLayoutData((Object)gridData);
        this.createOkButton(parent, 0, "Generate OSEK-Files", true);
        Button cancelButton = this.createButton(parent, 1, "Cancel", false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OsekGenerationGUI.this.setReturnCode(1);
                OsekGenerationGUI.this.close();
            }
        });
    }

    protected Button createOkButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (OsekGenerationGUI.this.isValidInput()) {
                    OsekGenerationGUI.this.okPressed();
                }
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    boolean isValidInput() {
        boolean valid = true;
        if (this.textProjectName.getText().length() == 0) {
            this.setErrorMessage("Please enter a valid Project Name.");
            valid = false;
        }
        if (this.textMappingModelFile.getText().length() == 0) {
            this.setErrorMessage("Please select a valid Mapping Model.");
            valid = false;
        }
        return valid;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.setPathToMappingModel(this.textMappingModelFile.getText());
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getNameOfCompilation() {
        return this.nameOfCompilation;
    }

    public void setNameOfCompilation(String nameOfCompilation) {
        this.nameOfCompilation = nameOfCompilation;
    }

    public String getPathToMappingModel() {
        return this.pathToMappingModel;
    }

    public void setPathToMappingModel(String pathToMappingModel) {
        this.pathToMappingModel = pathToMappingModel;
    }

    public String getPathToOutput() {
        return this.pathToOutput;
    }

    public void setPathToOutput(String pathToOutput) {
        this.pathToOutput = pathToOutput;
    }

    public void setProjectName(String projectName) {
        this.initName = projectName;
    }
}

