/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.export.osek.handlers;

import java.io.File;
import java.io.IOException;
import org.eclipse.app4mc.amalthea.export.osek.OsekMainWriter;
import org.eclipse.app4mc.amalthea.export.osek.OsekOilWriter;
import org.eclipse.app4mc.amalthea.export.osek.handlers.OsekGenerationGUI;
import org.eclipse.app4mc.amalthea.export.osek.handlers.SchedulerToCoreMap;
import org.eclipse.app4mc.amalthea.model.CoreAllocation;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class OsekGenerationHandler
extends AbstractHandler {
    private boolean fileNotFoundCheckerOil = false;
    private boolean fileNotFoundCheckerMaster = false;
    private boolean fileNotFoundCheckerSlave = false;
    private URI selectedSWModel;
    private URI workingFolder;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block15: {
            UniversalHandler uh = UniversalHandler.getInstance();
            String pathMappingModel = "";
            URI projectDir = uh.getProjectDir(event);
            IFile selectedFile = uh.getSelectedFile(event);
            URI selectedFilePath = URI.createURI((String)selectedFile.getLocationURI().toString());
            uh.readModels(selectedFilePath, true);
            SWModel swmodel = uh.getSwModel();
            this.selectedSWModel = selectedFilePath;
            this.workingFolder = uh.getProjectDir(event);
            try {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                OsekGenerationGUI dialog = new OsekGenerationGUI(window.getShell());
                String f = new File(this.selectedSWModel.devicePath()).getName();
                dialog.setProjectName(f.substring(0, f.lastIndexOf(46)));
                dialog.setWorkingDirectory(this.workingFolder.devicePath());
                dialog.create();
                if (dialog.open() == 0) {
                    pathMappingModel = dialog.getPathToMappingModel();
                    System.out.println("PathMappingModel: " + pathMappingModel);
                    uh.readModels(URI.createFileURI((String)pathMappingModel), true);
                    MappingModel mappingmodel = uh.getMappingModel();
                    SchedulerToCoreMap coreAlloc = new SchedulerToCoreMap((EList<CoreAllocation>)mappingmodel.getCoreAllocation());
                    EList exeAlloc = mappingmodel.getTaskAllocation();
                    EList tasksList = swmodel.getTasks();
                    System.out.println("\nStarting generation!\n");
                    OsekOilWriter oil = new OsekOilWriter();
                    OsekMainWriter master = new OsekMainWriter();
                    OsekMainWriter slave = new OsekMainWriter();
                    try {
                        try {
                            this.fileNotFoundCheckerOil = oil.generateOutputOil((EList<Task>)tasksList, (EList<TaskAllocation>)exeAlloc, coreAlloc, projectDir);
                            this.fileNotFoundCheckerMaster = master.generateOutputMain("master", (EList<Task>)tasksList, (EList<TaskAllocation>)exeAlloc, coreAlloc, projectDir);
                            this.fileNotFoundCheckerSlave = slave.generateOutputMain("slave", (EList<Task>)tasksList, (EList<TaskAllocation>)exeAlloc, coreAlloc, projectDir);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            IWorkbenchWindow windowFinalStatus = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                            MessageDialog.openInformation((Shell)windowFinalStatus.getShell(), (String)"ERROR", (String)"Something is going wrong!");
                            if (this.fileNotFoundCheckerOil || this.fileNotFoundCheckerMaster || this.fileNotFoundCheckerSlave) {
                                IWorkbenchWindow windowFinalStatus2 = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                                String outputInfo = "";
                                if (this.fileNotFoundCheckerOil) {
                                    outputInfo = outputInfo.concat("  - confTemplate.oil\n ");
                                }
                                if (this.fileNotFoundCheckerMaster || this.fileNotFoundCheckerSlave) {
                                    outputInfo = outputInfo.concat("  - template.c");
                                }
                                MessageDialog.openInformation((Shell)windowFinalStatus2.getShell(), (String)"ERROR", (String)("The following files were not found:\n" + outputInfo + "\n\nPlease copy the required files into the template folder."));
                                break block15;
                            }
                            IWorkbenchWindow windowFinalStatus3 = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                            MessageDialog.openInformation((Shell)windowFinalStatus3.getShell(), (String)"Status Information", (String)"The OSEK file generation have been successfully completed!");
                        }
                        break block15;
                    }
                    finally {
                        if (this.fileNotFoundCheckerOil || this.fileNotFoundCheckerMaster || this.fileNotFoundCheckerSlave) {
                            IWorkbenchWindow windowFinalStatus = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                            String outputInfo = "";
                            if (this.fileNotFoundCheckerOil) {
                                outputInfo = outputInfo.concat("  - confTemplate.oil\n ");
                            }
                            if (this.fileNotFoundCheckerMaster || this.fileNotFoundCheckerSlave) {
                                outputInfo = outputInfo.concat("  - template.c");
                            }
                            MessageDialog.openInformation((Shell)windowFinalStatus.getShell(), (String)"ERROR", (String)("The following files were not found:\n" + outputInfo + "\n\nPlease copy the required files into the template folder."));
                        } else {
                            IWorkbenchWindow windowFinalStatus = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                            MessageDialog.openInformation((Shell)windowFinalStatus.getShell(), (String)"Status Information", (String)"The OSEK file generation have been successfully completed!");
                        }
                    }
                }
                System.out.println("User caused abort!");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

