/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.export.osek.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreAllocation;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.emf.common.util.EList;

public class SchedulerToCoreMap {
    private final Map<Scheduler, Set<String>> schedulerToCoreNames = new HashMap<Scheduler, Set<String>>();

    public SchedulerToCoreMap(EList<CoreAllocation> coreAllocationList) {
        for (CoreAllocation coreAllocation : coreAllocationList) {
            Scheduler scheduler = coreAllocation.getScheduler();
            if (scheduler == null) continue;
            EList coreList = coreAllocation.getCore();
            HashSet<String> coreNames = new HashSet<String>();
            this.schedulerToCoreNames.put(scheduler, coreNames);
            for (Core core : coreList) {
                String coreName = core.getName();
                if (coreName == null) continue;
                coreNames.add(coreName.toLowerCase());
            }
        }
    }

    public boolean isSchedulerMappedToCore(Scheduler scheduler, String coreName) {
        Set<String> coreNames = this.schedulerToCoreNames.get(scheduler);
        if (coreNames == null) {
            return false;
        }
        return coreNames.contains(coreName.toLowerCase());
    }
}

