/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.app4mc.amalthea._import.atdb.IImporter;
import org.eclipse.app4mc.amalthea._import.atdb.model.Isr;
import org.eclipse.app4mc.amalthea._import.atdb.model.Model;
import org.eclipse.app4mc.amalthea._import.atdb.model.Runnable;
import org.eclipse.app4mc.amalthea._import.atdb.model.Signal;
import org.eclipse.app4mc.amalthea._import.atdb.model.Stimulus;
import org.eclipse.app4mc.amalthea._import.atdb.model.Task;
import org.eclipse.core.runtime.IProgressMonitor;

public class ATDBImporter
implements IImporter {
    private String filePath = null;
    private Connection traceDbConnection;
    private int timeBase = 0;

    public ATDBImporter(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public Model run(IProgressMonitor progressMonitor) {
        Model model = new Model();
        progressMonitor.beginTask("Importing AMALTHEA database...", 100);
        File databaseFile = new File(this.filePath);
        try {
            this.connectToDatabase(databaseFile);
            this.determineTimeUnit();
            List<Task> tasks = this.determineTasks();
            List<Isr> isrs = this.determineISRs();
            List<Runnable> runnables = this.determineRunnables();
            List<Signal> signals = this.determineSignals();
            List<Stimulus> stimuli = this.determineStimuli();
            model.setTasks(tasks);
            model.setIsrs(isrs);
            model.setRunnables(runnables);
            model.setSignals(signals);
            model.setStimuli(stimuli);
            this.closeDatabaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        progressMonitor.done();
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determineTimeUnit() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Statement stmt = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = stmt.executeQuery("SELECT Value FROM MetaInformation WHERE Name LIKE 'time_base'");){
                    while (resultSet.next()) {
                        String value = resultSet.getString("Value");
                        switch (value.toLowerCase()) {
                            case "ps": {
                                this.timeBase = 0;
                                break;
                            }
                            case "ns": {
                                this.timeBase = 1;
                                break;
                            }
                            case "us": {
                                this.timeBase = 2;
                                break;
                            }
                            case "ms": {
                                this.timeBase = 3;
                                break;
                            }
                            case "s": {
                                this.timeBase = 4;
                            }
                        }
                    }
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void connectToDatabase(File databaseFile) throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        String connectionStr = "jdbc:sqlite:";
        connectionStr = String.valueOf(connectionStr) + databaseFile.toString();
        Properties properties = new Properties();
        properties.put("open_mode", "1");
        this.traceDbConnection = DriverManager.getConnection(connectionStr, properties);
    }

    public void closeDatabaseConnection() throws SQLException {
        this.traceDbConnection.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Task> determineTasks() throws SQLException {
        HashMap<Task, String> map;
        ArrayList<Task> result;
        block16: {
            result = new ArrayList<Task>();
            map = new HashMap<Task, String>();
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                Statement stmt = this.traceDbConnection.createStatement();
                try {
                    try (ResultSet resultSet = stmt.executeQuery("SELECT a.Name, a.EventTableName FROM Entity AS a JOIN EntityType AS b ON a.EntityTypeId = b.Id WHERE b.Name LIKE 'task'");){
                        while (resultSet.next()) {
                            String name = resultSet.getString("Name");
                            String table = resultSet.getString("EventTableName");
                            Task task = new Task(name);
                            map.put(task, table);
                        }
                    }
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        HashMap<String, Task> tasks = new HashMap<String, Task>();
        Iterator iterator = map.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.determineTaskRunnableCalls(tasks);
                result.addAll(map.keySet());
                return result;
            }
            Task task = (Task)iterator.next();
            this.determineTaskActivations(task, (String)map.get(task));
            tasks.put(task.getName(), task);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void determineTaskRunnableCalls(Map<String, Task> tasks) throws SQLException {
        Iterator iterator;
        String selection;
        HashMap<String, String> runnables;
        block29: {
            runnables = new HashMap<String, String>();
            selection = "SELECT a.Name, a.EventTableName FROM Entity AS a JOIN EntityType AS b ON a.EntityTypeId = b.Id WHERE b.Name LIKE 'runnable'";
            Throwable throwable = null;
            iterator = null;
            try {
                Statement stmt = this.traceDbConnection.createStatement();
                try {
                    try (ResultSet resultSet = stmt.executeQuery(selection);){
                        while (resultSet.next()) {
                            String name = resultSet.getString("Name");
                            String table = resultSet.getString("EventTableName");
                            runnables.put(name, table);
                        }
                    }
                    if (stmt == null) break block29;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        iterator = runnables.keySet().iterator();
        while (iterator.hasNext()) {
            String runnable = (String)iterator.next();
            selection = "SELECT c.Name FROM '" + (String)runnables.get(runnable) + "' AS a JOIN EventType AS b JOIN Entity AS c ON a.EventTypeId = b.Id AND a.SourceEntityId = c.Id WHERE b.Name Like 'start'";
            Throwable throwable = null;
            Object var7_11 = null;
            try {
                Statement stmt = this.traceDbConnection.createStatement();
                try {
                    try (ResultSet resultSet = stmt.executeQuery(selection);){
                        while (resultSet.next()) {
                            String source = resultSet.getString("Name");
                            tasks.get(source).addRunnableCall(runnable);
                        }
                    }
                    if (stmt == null) continue;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void determineTaskActivations(Task task, String table) throws SQLException {
        String selection = "SELECT c.Name, a.SourceEntityInstanceId FROM '" + table + "' AS a JOIN EventType AS b JOIN Entity AS c ON a.EventTypeId = b.Id AND a.SourceEntityId = c.Id WHERE b.Name Like 'activate'";
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Statement stmt = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = stmt.executeQuery(selection);){
                    while (resultSet.next()) {
                        String name = resultSet.getString("Name");
                        long sourceEntityInstanceId = resultSet.getLong("SourceEntityInstanceId");
                        task.addStimulus(String.valueOf(name) + "_" + sourceEntityInstanceId);
                    }
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Isr> determineISRs() throws SQLException {
        ArrayList<Isr> result = new ArrayList<Isr>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Statement stmt = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = stmt.executeQuery("SELECT a.Name FROM Entity AS a JOIN EntityType AS b ON a.EntityTypeId = b.Id WHERE b.Name LIKE 'isr'");){
                    while (resultSet.next()) {
                        String name = resultSet.getString("Name");
                        Isr isr = new Isr(name);
                        result.add(isr);
                    }
                }
                if (stmt == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Runnable> determineRunnables() throws SQLException {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Statement statement = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = statement.executeQuery("SELECT a.Name FROM Entity AS a JOIN EntityType AS b ON a.EntityTypeId = b.Id WHERE b.Name LIKE 'runnable'");){
                    while (resultSet.next()) {
                        String name = resultSet.getString("Name");
                        Runnable runnable = new Runnable(name);
                        result.add(runnable);
                    }
                }
                if (statement == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Signal> determineSignals() throws SQLException {
        ArrayList<Signal> result = new ArrayList<Signal>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Statement stmt = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = stmt.executeQuery("SELECT a.Name FROM Entity AS a JOIN EntityType AS b ON a.EntityTypeId = b.Id WHERE b.Name LIKE 'signal'");){
                    while (resultSet.next()) {
                        String name = resultSet.getString("Name");
                        Signal signal = new Signal(name);
                        result.add(signal);
                    }
                }
                if (stmt == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Stimulus> determineStimuli() throws SQLException {
        Iterator iterator;
        String selection;
        HashMap<String, String> map;
        ArrayList<Stimulus> result;
        block29: {
            result = new ArrayList<Stimulus>();
            map = new HashMap<String, String>();
            selection = "SELECT a.Name, a.EventTableName FROM Entity AS a JOIN EntityType AS b ON a.EntityTypeId = b.Id WHERE b.Name LIKE 'stimulus'";
            Throwable throwable = null;
            iterator = null;
            try {
                Statement stmt = this.traceDbConnection.createStatement();
                try {
                    try (ResultSet resultSet = stmt.executeQuery(selection);){
                        while (resultSet.next()) {
                            String name = resultSet.getString("Name");
                            String table = resultSet.getString("EventTableName");
                            map.put(name, table);
                        }
                    }
                    if (stmt == null) break block29;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            selection = "SELECT TimeStamp, EntityInstanceId FROM '" + (String)map.get(name) + "'";
            Throwable throwable = null;
            Object var7_11 = null;
            try {
                Statement stmt = this.traceDbConnection.createStatement();
                try {
                    try (ResultSet resultSet = stmt.executeQuery(selection);){
                        while (resultSet.next()) {
                            long timeStamp = resultSet.getLong("TimeStamp");
                            long entityInstanceId = resultSet.getLong("EntityInstanceId");
                            Stimulus stimulus = new Stimulus(String.valueOf(name) + "_" + entityInstanceId);
                            stimulus.setMoment(timeStamp);
                            stimulus.setTimeBase(this.timeBase);
                            result.add(stimulus);
                        }
                    }
                    if (stmt == null) continue;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        return result;
    }
}

