/**
 * *******************************************************************************
 *  Copyright (c) 2016 Robert Bosch GmbH and others.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.amalthea.model.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.app4mc.amalthea.model.util.AmaltheaAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AmaltheaItemProviderAdapterFactory extends AmaltheaAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AmaltheaItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Amalthea} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AmaltheaItemProvider amaltheaItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Amalthea}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAmaltheaAdapter() {
		if (amaltheaItemProvider == null) {
			amaltheaItemProvider = new AmaltheaItemProvider(this);
		}

		return amaltheaItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CommonElements} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommonElementsItemProvider commonElementsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CommonElements}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommonElementsAdapter() {
		if (commonElementsItemProvider == null) {
			commonElementsItemProvider = new CommonElementsItemProvider(this);
		}

		return commonElementsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Tag} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TagItemProvider tagItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Tag}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTagAdapter() {
		if (tagItemProvider == null) {
			tagItemProvider = new TagItemProvider(this);
		}

		return tagItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransmissionPolicyItemProvider transmissionPolicyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransmissionPolicyAdapter() {
		if (transmissionPolicyItemProvider == null) {
			transmissionPolicyItemProvider = new TransmissionPolicyItemProvider(this);
		}

		return transmissionPolicyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Time} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeItemProvider timeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Time}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeAdapter() {
		if (timeItemProvider == null) {
			timeItemProvider = new TimeItemProvider(this);
		}

		return timeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SignedTime} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignedTimeItemProvider signedTimeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SignedTime}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignedTimeAdapter() {
		if (signedTimeItemProvider == null) {
			signedTimeItemProvider = new SignedTimeItemProvider(this);
		}

		return signedTimeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Frequency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FrequencyItemProvider frequencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Frequency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFrequencyAdapter() {
		if (frequencyItemProvider == null) {
			frequencyItemProvider = new FrequencyItemProvider(this);
		}

		return frequencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataSize} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataSizeItemProvider dataSizeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataSize}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataSizeAdapter() {
		if (dataSizeItemProvider == null) {
			dataSizeItemProvider = new DataSizeItemProvider(this);
		}

		return dataSizeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataRate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataRateItemProvider dataRateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataRate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataRateAdapter() {
		if (dataRateItemProvider == null) {
			dataRateItemProvider = new DataRateItemProvider(this);
		}

		return dataRateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomPropertyItemProvider customPropertyItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomPropertyAdapter() {
		if (customPropertyItemProvider == null) {
			customPropertyItemProvider = new CustomPropertyItemProvider(this);
		}

		return customPropertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ListObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListObjectItemProvider listObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ListObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createListObjectAdapter() {
		if (listObjectItemProvider == null) {
			listObjectItemProvider = new ListObjectItemProvider(this);
		}

		return listObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StringObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringObjectItemProvider stringObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StringObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringObjectAdapter() {
		if (stringObjectItemProvider == null) {
			stringObjectItemProvider = new StringObjectItemProvider(this);
		}

		return stringObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BigIntegerObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BigIntegerObjectItemProvider bigIntegerObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BigIntegerObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBigIntegerObjectAdapter() {
		if (bigIntegerObjectItemProvider == null) {
			bigIntegerObjectItemProvider = new BigIntegerObjectItemProvider(this);
		}

		return bigIntegerObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ReferenceObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceObjectItemProvider referenceObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ReferenceObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceObjectAdapter() {
		if (referenceObjectItemProvider == null) {
			referenceObjectItemProvider = new ReferenceObjectItemProvider(this);
		}

		return referenceObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.IntegerObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerObjectItemProvider integerObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.IntegerObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerObjectAdapter() {
		if (integerObjectItemProvider == null) {
			integerObjectItemProvider = new IntegerObjectItemProvider(this);
		}

		return integerObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LongObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LongObjectItemProvider longObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LongObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLongObjectAdapter() {
		if (longObjectItemProvider == null) {
			longObjectItemProvider = new LongObjectItemProvider(this);
		}

		return longObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FloatObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FloatObjectItemProvider floatObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FloatObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFloatObjectAdapter() {
		if (floatObjectItemProvider == null) {
			floatObjectItemProvider = new FloatObjectItemProvider(this);
		}

		return floatObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DoubleObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleObjectItemProvider doubleObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DoubleObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDoubleObjectAdapter() {
		if (doubleObjectItemProvider == null) {
			doubleObjectItemProvider = new DoubleObjectItemProvider(this);
		}

		return doubleObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BooleanObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanObjectItemProvider booleanObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BooleanObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanObjectAdapter() {
		if (booleanObjectItemProvider == null) {
			booleanObjectItemProvider = new BooleanObjectItemProvider(this);
		}

		return booleanObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TimeObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeObjectItemProvider timeObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TimeObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeObjectAdapter() {
		if (timeObjectItemProvider == null) {
			timeObjectItemProvider = new TimeObjectItemProvider(this);
		}

		return timeObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SignedTimeObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignedTimeObjectItemProvider signedTimeObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SignedTimeObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignedTimeObjectAdapter() {
		if (signedTimeObjectItemProvider == null) {
			signedTimeObjectItemProvider = new SignedTimeObjectItemProvider(this);
		}

		return signedTimeObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Deviation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeviationItemProvider deviationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Deviation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeviationAdapter() {
		if (deviationItemProvider == null) {
			deviationItemProvider = new DeviationItemProvider(this);
		}

		return deviationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.WeibullParameters} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WeibullParametersItemProvider weibullParametersItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.WeibullParameters}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeibullParametersAdapter() {
		if (weibullParametersItemProvider == null) {
			weibullParametersItemProvider = new WeibullParametersItemProvider(this);
		}

		return weibullParametersItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.WeibullEstimators} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WeibullEstimatorsItemProvider weibullEstimatorsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.WeibullEstimators}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeibullEstimatorsAdapter() {
		if (weibullEstimatorsItemProvider == null) {
			weibullEstimatorsItemProvider = new WeibullEstimatorsItemProvider(this);
		}

		return weibullEstimatorsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.UniformDistribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UniformDistributionItemProvider uniformDistributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.UniformDistribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUniformDistributionAdapter() {
		if (uniformDistributionItemProvider == null) {
			uniformDistributionItemProvider = new UniformDistributionItemProvider(this);
		}

		return uniformDistributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Boundaries} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BoundariesItemProvider boundariesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Boundaries}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBoundariesAdapter() {
		if (boundariesItemProvider == null) {
			boundariesItemProvider = new BoundariesItemProvider(this);
		}

		return boundariesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.GaussDistribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GaussDistributionItemProvider gaussDistributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.GaussDistribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGaussDistributionAdapter() {
		if (gaussDistributionItemProvider == null) {
			gaussDistributionItemProvider = new GaussDistributionItemProvider(this);
		}

		return gaussDistributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BetaDistribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BetaDistributionItemProvider betaDistributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BetaDistribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBetaDistributionAdapter() {
		if (betaDistributionItemProvider == null) {
			betaDistributionItemProvider = new BetaDistributionItemProvider(this);
		}

		return betaDistributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MinAvgMaxStatisticItemProvider minAvgMaxStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMinAvgMaxStatisticAdapter() {
		if (minAvgMaxStatisticItemProvider == null) {
			minAvgMaxStatisticItemProvider = new MinAvgMaxStatisticItemProvider(this);
		}

		return minAvgMaxStatisticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SingleValueStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleValueStatisticItemProvider singleValueStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SingleValueStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleValueStatisticAdapter() {
		if (singleValueStatisticItemProvider == null) {
			singleValueStatisticItemProvider = new SingleValueStatisticItemProvider(this);
		}

		return singleValueStatisticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Mode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeItemProvider modeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Mode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeAdapter() {
		if (modeItemProvider == null) {
			modeItemProvider = new ModeItemProvider(this);
		}

		return modeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeLiteralItemProvider modeLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeLiteralAdapter() {
		if (modeLiteralItemProvider == null) {
			modeLiteralItemProvider = new ModeLiteralItemProvider(this);
		}

		return modeLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComponentsModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentsModelItemProvider componentsModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComponentsModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentsModelAdapter() {
		if (componentsModelItemProvider == null) {
			componentsModelItemProvider = new ComponentsModelItemProvider(this);
		}

		return componentsModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Component} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentItemProvider componentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Component}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentAdapter() {
		if (componentItemProvider == null) {
			componentItemProvider = new ComponentItemProvider(this);
		}

		return componentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Composite} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeItemProvider compositeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Composite}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompositeAdapter() {
		if (compositeItemProvider == null) {
			compositeItemProvider = new CompositeItemProvider(this);
		}

		return compositeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.System} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SystemItemProvider systemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.System}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystemAdapter() {
		if (systemItemProvider == null) {
			systemItemProvider = new SystemItemProvider(this);
		}

		return systemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComponentInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentInstanceItemProvider componentInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComponentInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentInstanceAdapter() {
		if (componentInstanceItemProvider == null) {
			componentInstanceItemProvider = new ComponentInstanceItemProvider(this);
		}

		return componentInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Connector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectorItemProvider connectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Connector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectorAdapter() {
		if (connectorItemProvider == null) {
			connectorItemProvider = new ConnectorItemProvider(this);
		}

		return connectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.QualifiedPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QualifiedPortItemProvider qualifiedPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.QualifiedPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQualifiedPortAdapter() {
		if (qualifiedPortItemProvider == null) {
			qualifiedPortItemProvider = new QualifiedPortItemProvider(this);
		}

		return qualifiedPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FInterfacePort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FInterfacePortItemProvider fInterfacePortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FInterfacePort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFInterfacePortAdapter() {
		if (fInterfacePortItemProvider == null) {
			fInterfacePortItemProvider = new FInterfacePortItemProvider(this);
		}

		return fInterfacePortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConfigModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigModelItemProvider configModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConfigModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfigModelAdapter() {
		if (configModelItemProvider == null) {
			configModelItemProvider = new ConfigModelItemProvider(this);
		}

		return configModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventConfig} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventConfigItemProvider eventConfigItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventConfig}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventConfigAdapter() {
		if (eventConfigItemProvider == null) {
			eventConfigItemProvider = new EventConfigItemProvider(this);
		}

		return eventConfigItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConstraintsModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstraintsModelItemProvider constraintsModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConstraintsModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstraintsModelAdapter() {
		if (constraintsModelItemProvider == null) {
			constraintsModelItemProvider = new ConstraintsModelItemProvider(this);
		}

		return constraintsModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableSequencingConstraintItemProvider runnableSequencingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableSequencingConstraintAdapter() {
		if (runnableSequencingConstraintItemProvider == null) {
			runnableSequencingConstraintItemProvider = new RunnableSequencingConstraintItemProvider(this);
		}

		return runnableSequencingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessRunnableGroupItemProvider processRunnableGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessRunnableGroupAdapter() {
		if (processRunnableGroupItemProvider == null) {
			processRunnableGroupItemProvider = new ProcessRunnableGroupItemProvider(this);
		}

		return processRunnableGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableSeparationConstraintItemProvider runnableSeparationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableSeparationConstraintAdapter() {
		if (runnableSeparationConstraintItemProvider == null) {
			runnableSeparationConstraintItemProvider = new RunnableSeparationConstraintItemProvider(this);
		}

		return runnableSeparationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessSeparationConstraintItemProvider processSeparationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessSeparationConstraintAdapter() {
		if (processSeparationConstraintItemProvider == null) {
			processSeparationConstraintItemProvider = new ProcessSeparationConstraintItemProvider(this);
		}

		return processSeparationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataSeparationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataSeparationConstraintItemProvider dataSeparationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataSeparationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataSeparationConstraintAdapter() {
		if (dataSeparationConstraintItemProvider == null) {
			dataSeparationConstraintItemProvider = new DataSeparationConstraintItemProvider(this);
		}

		return dataSeparationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnablePairingConstraintItemProvider runnablePairingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnablePairingConstraintAdapter() {
		if (runnablePairingConstraintItemProvider == null) {
			runnablePairingConstraintItemProvider = new RunnablePairingConstraintItemProvider(this);
		}

		return runnablePairingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPairingConstraintItemProvider processPairingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessPairingConstraintAdapter() {
		if (processPairingConstraintItemProvider == null) {
			processPairingConstraintItemProvider = new ProcessPairingConstraintItemProvider(this);
		}

		return processPairingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataPairingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataPairingConstraintItemProvider dataPairingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataPairingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataPairingConstraintAdapter() {
		if (dataPairingConstraintItemProvider == null) {
			dataPairingConstraintItemProvider = new DataPairingConstraintItemProvider(this);
		}

		return dataPairingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TargetMemory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetMemoryItemProvider targetMemoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TargetMemory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetMemoryAdapter() {
		if (targetMemoryItemProvider == null) {
			targetMemoryItemProvider = new TargetMemoryItemProvider(this);
		}

		return targetMemoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TargetCore} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetCoreItemProvider targetCoreItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TargetCore}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetCoreAdapter() {
		if (targetCoreItemProvider == null) {
			targetCoreItemProvider = new TargetCoreItemProvider(this);
		}

		return targetCoreItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TargetScheduler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetSchedulerItemProvider targetSchedulerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TargetScheduler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetSchedulerAdapter() {
		if (targetSchedulerItemProvider == null) {
			targetSchedulerItemProvider = new TargetSchedulerItemProvider(this);
		}

		return targetSchedulerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelEntityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelEntityGroupItemProvider labelEntityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelEntityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelEntityGroupAdapter() {
		if (labelEntityGroupItemProvider == null) {
			labelEntityGroupItemProvider = new LabelEntityGroupItemProvider(this);
		}

		return labelEntityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableEntityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableEntityGroupItemProvider runnableEntityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableEntityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableEntityGroupAdapter() {
		if (runnableEntityGroupItemProvider == null) {
			runnableEntityGroupItemProvider = new RunnableEntityGroupItemProvider(this);
		}

		return runnableEntityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessEntityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessEntityGroupItemProvider processEntityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessEntityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessEntityGroupAdapter() {
		if (processEntityGroupItemProvider == null) {
			processEntityGroupItemProvider = new ProcessEntityGroupItemProvider(this);
		}

		return processEntityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TagGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TagGroupItemProvider tagGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TagGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTagGroupAdapter() {
		if (tagGroupItemProvider == null) {
			tagGroupItemProvider = new TagGroupItemProvider(this);
		}

		return tagGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainItemProvider eventChainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainAdapter() {
		if (eventChainItemProvider == null) {
			eventChainItemProvider = new EventChainItemProvider(this);
		}

		return eventChainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainReferenceItemProvider eventChainReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainReferenceAdapter() {
		if (eventChainReferenceItemProvider == null) {
			eventChainReferenceItemProvider = new EventChainReferenceItemProvider(this);
		}

		return eventChainReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SubEventChain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubEventChainItemProvider subEventChainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SubEventChain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubEventChainAdapter() {
		if (subEventChainItemProvider == null) {
			subEventChainItemProvider = new SubEventChainItemProvider(this);
		}

		return subEventChainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PhysicalSectionConstraintItemProvider physicalSectionConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPhysicalSectionConstraintAdapter() {
		if (physicalSectionConstraintItemProvider == null) {
			physicalSectionConstraintItemProvider = new PhysicalSectionConstraintItemProvider(this);
		}

		return physicalSectionConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventSynchronizationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventSynchronizationConstraintItemProvider eventSynchronizationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventSynchronizationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventSynchronizationConstraintAdapter() {
		if (eventSynchronizationConstraintItemProvider == null) {
			eventSynchronizationConstraintItemProvider = new EventSynchronizationConstraintItemProvider(this);
		}

		return eventSynchronizationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainSynchronizationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainSynchronizationConstraintItemProvider eventChainSynchronizationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainSynchronizationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainSynchronizationConstraintAdapter() {
		if (eventChainSynchronizationConstraintItemProvider == null) {
			eventChainSynchronizationConstraintItemProvider = new EventChainSynchronizationConstraintItemProvider(this);
		}

		return eventChainSynchronizationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DelayConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DelayConstraintItemProvider delayConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DelayConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDelayConstraintAdapter() {
		if (delayConstraintItemProvider == null) {
			delayConstraintItemProvider = new DelayConstraintItemProvider(this);
		}

		return delayConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainLatencyConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainLatencyConstraintItemProvider eventChainLatencyConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainLatencyConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainLatencyConstraintAdapter() {
		if (eventChainLatencyConstraintItemProvider == null) {
			eventChainLatencyConstraintItemProvider = new EventChainLatencyConstraintItemProvider(this);
		}

		return eventChainLatencyConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RepetitionConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RepetitionConstraintItemProvider repetitionConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RepetitionConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRepetitionConstraintAdapter() {
		if (repetitionConstraintItemProvider == null) {
			repetitionConstraintItemProvider = new RepetitionConstraintItemProvider(this);
		}

		return repetitionConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataAgeConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataAgeConstraintItemProvider dataAgeConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataAgeConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataAgeConstraintAdapter() {
		if (dataAgeConstraintItemProvider == null) {
			dataAgeConstraintItemProvider = new DataAgeConstraintItemProvider(this);
		}

		return dataAgeConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataAgeCycle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataAgeCycleItemProvider dataAgeCycleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataAgeCycle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataAgeCycleAdapter() {
		if (dataAgeCycleItemProvider == null) {
			dataAgeCycleItemProvider = new DataAgeCycleItemProvider(this);
		}

		return dataAgeCycleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataAgeTime} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataAgeTimeItemProvider dataAgeTimeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataAgeTime}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataAgeTimeAdapter() {
		if (dataAgeTimeItemProvider == null) {
			dataAgeTimeItemProvider = new DataAgeTimeItemProvider(this);
		}

		return dataAgeTimeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessRequirementItemProvider processRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessRequirementAdapter() {
		if (processRequirementItemProvider == null) {
			processRequirementItemProvider = new ProcessRequirementItemProvider(this);
		}

		return processRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableRequirementItemProvider runnableRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableRequirementAdapter() {
		if (runnableRequirementItemProvider == null) {
			runnableRequirementItemProvider = new RunnableRequirementItemProvider(this);
		}

		return runnableRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ArchitectureRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArchitectureRequirementItemProvider architectureRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ArchitectureRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArchitectureRequirementAdapter() {
		if (architectureRequirementItemProvider == null) {
			architectureRequirementItemProvider = new ArchitectureRequirementItemProvider(this);
		}

		return architectureRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessChainRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessChainRequirementItemProvider processChainRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessChainRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessChainRequirementAdapter() {
		if (processChainRequirementItemProvider == null) {
			processChainRequirementItemProvider = new ProcessChainRequirementItemProvider(this);
		}

		return processChainRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CPUPercentageRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CPUPercentageRequirementLimitItemProvider cpuPercentageRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CPUPercentageRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCPUPercentageRequirementLimitAdapter() {
		if (cpuPercentageRequirementLimitItemProvider == null) {
			cpuPercentageRequirementLimitItemProvider = new CPUPercentageRequirementLimitItemProvider(this);
		}

		return cpuPercentageRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FrequencyRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FrequencyRequirementLimitItemProvider frequencyRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FrequencyRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFrequencyRequirementLimitAdapter() {
		if (frequencyRequirementLimitItemProvider == null) {
			frequencyRequirementLimitItemProvider = new FrequencyRequirementLimitItemProvider(this);
		}

		return frequencyRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PercentageRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PercentageRequirementLimitItemProvider percentageRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PercentageRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPercentageRequirementLimitAdapter() {
		if (percentageRequirementLimitItemProvider == null) {
			percentageRequirementLimitItemProvider = new PercentageRequirementLimitItemProvider(this);
		}

		return percentageRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CountRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CountRequirementLimitItemProvider countRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CountRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCountRequirementLimitAdapter() {
		if (countRequirementLimitItemProvider == null) {
			countRequirementLimitItemProvider = new CountRequirementLimitItemProvider(this);
		}

		return countRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TimeRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeRequirementLimitItemProvider timeRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TimeRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeRequirementLimitAdapter() {
		if (timeRequirementLimitItemProvider == null) {
			timeRequirementLimitItemProvider = new TimeRequirementLimitItemProvider(this);
		}

		return timeRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataCoherencyGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataCoherencyGroupItemProvider dataCoherencyGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataCoherencyGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataCoherencyGroupAdapter() {
		if (dataCoherencyGroupItemProvider == null) {
			dataCoherencyGroupItemProvider = new DataCoherencyGroupItemProvider(this);
		}

		return dataCoherencyGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataStabilityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataStabilityGroupItemProvider dataStabilityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataStabilityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataStabilityGroupAdapter() {
		if (dataStabilityGroupItemProvider == null) {
			dataStabilityGroupItemProvider = new DataStabilityGroupItemProvider(this);
		}

		return dataStabilityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessScope} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessScopeItemProvider processScopeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessScope}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessScopeAdapter() {
		if (processScopeItemProvider == null) {
			processScopeItemProvider = new ProcessScopeItemProvider(this);
		}

		return processScopeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableScope} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableScopeItemProvider runnableScopeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableScope}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableScopeAdapter() {
		if (runnableScopeItemProvider == null) {
			runnableScopeItemProvider = new RunnableScopeItemProvider(this);
		}

		return runnableScopeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComponentScope} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentScopeItemProvider componentScopeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComponentScope}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentScopeAdapter() {
		if (componentScopeItemProvider == null) {
			componentScopeItemProvider = new ComponentScopeItemProvider(this);
		}

		return componentScopeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventModelItemProvider eventModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventModelAdapter() {
		if (eventModelItemProvider == null) {
			eventModelItemProvider = new EventModelItemProvider(this);
		}

		return eventModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventSetItemProvider eventSetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventSetAdapter() {
		if (eventSetItemProvider == null) {
			eventSetItemProvider = new EventSetItemProvider(this);
		}

		return eventSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomEventItemProvider customEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomEventAdapter() {
		if (customEventItemProvider == null) {
			customEventItemProvider = new CustomEventItemProvider(this);
		}

		return customEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StimulusEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StimulusEventItemProvider stimulusEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StimulusEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStimulusEventAdapter() {
		if (stimulusEventItemProvider == null) {
			stimulusEventItemProvider = new StimulusEventItemProvider(this);
		}

		return stimulusEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessEventItemProvider processEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessEventAdapter() {
		if (processEventItemProvider == null) {
			processEventItemProvider = new ProcessEventItemProvider(this);
		}

		return processEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessChainEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessChainEventItemProvider processChainEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessChainEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessChainEventAdapter() {
		if (processChainEventItemProvider == null) {
			processChainEventItemProvider = new ProcessChainEventItemProvider(this);
		}

		return processChainEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableEventItemProvider runnableEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableEventAdapter() {
		if (runnableEventItemProvider == null) {
			runnableEventItemProvider = new RunnableEventItemProvider(this);
		}

		return runnableEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelEventItemProvider labelEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelEventAdapter() {
		if (labelEventItemProvider == null) {
			labelEventItemProvider = new LabelEventItemProvider(this);
		}

		return labelEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChannelEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelEventItemProvider channelEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChannelEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelEventAdapter() {
		if (channelEventItemProvider == null) {
			channelEventItemProvider = new ChannelEventItemProvider(this);
		}

		return channelEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SemaphoreEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SemaphoreEventItemProvider semaphoreEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SemaphoreEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSemaphoreEventAdapter() {
		if (semaphoreEventItemProvider == null) {
			semaphoreEventItemProvider = new SemaphoreEventItemProvider(this);
		}

		return semaphoreEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HWModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HWModelItemProvider hwModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HWModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHWModelAdapter() {
		if (hwModelItemProvider == null) {
			hwModelItemProvider = new HWModelItemProvider(this);
		}

		return hwModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwSystem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwSystemItemProvider hwSystemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwSystem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwSystemAdapter() {
		if (hwSystemItemProvider == null) {
			hwSystemItemProvider = new HwSystemItemProvider(this);
		}

		return hwSystemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ECU} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ECUItemProvider ecuItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ECU}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createECUAdapter() {
		if (ecuItemProvider == null) {
			ecuItemProvider = new ECUItemProvider(this);
		}

		return ecuItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Microcontroller} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MicrocontrollerItemProvider microcontrollerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Microcontroller}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMicrocontrollerAdapter() {
		if (microcontrollerItemProvider == null) {
			microcontrollerItemProvider = new MicrocontrollerItemProvider(this);
		}

		return microcontrollerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Core} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoreItemProvider coreItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Core}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCoreAdapter() {
		if (coreItemProvider == null) {
			coreItemProvider = new CoreItemProvider(this);
		}

		return coreItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Memory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryItemProvider memoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Memory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryAdapter() {
		if (memoryItemProvider == null) {
			memoryItemProvider = new MemoryItemProvider(this);
		}

		return memoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Network} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkItemProvider networkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Network}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetworkAdapter() {
		if (networkItemProvider == null) {
			networkItemProvider = new NetworkItemProvider(this);
		}

		return networkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Quartz} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QuartzItemProvider quartzItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Quartz}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQuartzAdapter() {
		if (quartzItemProvider == null) {
			quartzItemProvider = new QuartzItemProvider(this);
		}

		return quartzItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwComponentItemProvider hwComponentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwComponentAdapter() {
		if (hwComponentItemProvider == null) {
			hwComponentItemProvider = new HwComponentItemProvider(this);
		}

		return hwComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SystemType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SystemTypeItemProvider systemTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SystemType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystemTypeAdapter() {
		if (systemTypeItemProvider == null) {
			systemTypeItemProvider = new SystemTypeItemProvider(this);
		}

		return systemTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ECUType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ECUTypeItemProvider ecuTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ECUType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createECUTypeAdapter() {
		if (ecuTypeItemProvider == null) {
			ecuTypeItemProvider = new ECUTypeItemProvider(this);
		}

		return ecuTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MicrocontrollerType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MicrocontrollerTypeItemProvider microcontrollerTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MicrocontrollerType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMicrocontrollerTypeAdapter() {
		if (microcontrollerTypeItemProvider == null) {
			microcontrollerTypeItemProvider = new MicrocontrollerTypeItemProvider(this);
		}

		return microcontrollerTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CoreType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoreTypeItemProvider coreTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CoreType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCoreTypeAdapter() {
		if (coreTypeItemProvider == null) {
			coreTypeItemProvider = new CoreTypeItemProvider(this);
		}

		return coreTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MemoryType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryTypeItemProvider memoryTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MemoryType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryTypeAdapter() {
		if (memoryTypeItemProvider == null) {
			memoryTypeItemProvider = new MemoryTypeItemProvider(this);
		}

		return memoryTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.NetworkType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkTypeItemProvider networkTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.NetworkType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetworkTypeAdapter() {
		if (networkTypeItemProvider == null) {
			networkTypeItemProvider = new NetworkTypeItemProvider(this);
		}

		return networkTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwPortItemProvider hwPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwPortAdapter() {
		if (hwPortItemProvider == null) {
			hwPortItemProvider = new HwPortItemProvider(this);
		}

		return hwPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Pin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PinItemProvider pinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Pin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPinAdapter() {
		if (pinItemProvider == null) {
			pinItemProvider = new PinItemProvider(this);
		}

		return pinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComplexPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComplexPortItemProvider complexPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComplexPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComplexPortAdapter() {
		if (complexPortItemProvider == null) {
			complexPortItemProvider = new ComplexPortItemProvider(this);
		}

		return complexPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComplexPin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComplexPinItemProvider complexPinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComplexPin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComplexPinAdapter() {
		if (complexPinItemProvider == null) {
			complexPinItemProvider = new ComplexPinItemProvider(this);
		}

		return complexPinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Prescaler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrescalerItemProvider prescalerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Prescaler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrescalerAdapter() {
		if (prescalerItemProvider == null) {
			prescalerItemProvider = new PrescalerItemProvider(this);
		}

		return prescalerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CrossbarSwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CrossbarSwitchItemProvider crossbarSwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CrossbarSwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCrossbarSwitchAdapter() {
		if (crossbarSwitchItemProvider == null) {
			crossbarSwitchItemProvider = new CrossbarSwitchItemProvider(this);
		}

		return crossbarSwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Bus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BusItemProvider busItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Bus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBusAdapter() {
		if (busItemProvider == null) {
			busItemProvider = new BusItemProvider(this);
		}

		return busItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Bridge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BridgeItemProvider bridgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Bridge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBridgeAdapter() {
		if (bridgeItemProvider == null) {
			bridgeItemProvider = new BridgeItemProvider(this);
		}

		return bridgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LatencyAccessPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LatencyAccessPathItemProvider latencyAccessPathItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LatencyAccessPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLatencyAccessPathAdapter() {
		if (latencyAccessPathItemProvider == null) {
			latencyAccessPathItemProvider = new LatencyAccessPathItemProvider(this);
		}

		return latencyAccessPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwAccessPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwAccessPathItemProvider hwAccessPathItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwAccessPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwAccessPathAdapter() {
		if (hwAccessPathItemProvider == null) {
			hwAccessPathItemProvider = new HwAccessPathItemProvider(this);
		}

		return hwAccessPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AccessPathRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AccessPathRefItemProvider accessPathRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AccessPathRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAccessPathRefAdapter() {
		if (accessPathRefItemProvider == null) {
			accessPathRefItemProvider = new AccessPathRefItemProvider(this);
		}

		return accessPathRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LatencyConstant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LatencyConstantItemProvider latencyConstantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LatencyConstant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLatencyConstantAdapter() {
		if (latencyConstantItemProvider == null) {
			latencyConstantItemProvider = new LatencyConstantItemProvider(this);
		}

		return latencyConstantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LatencyDeviation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LatencyDeviationItemProvider latencyDeviationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LatencyDeviation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLatencyDeviationAdapter() {
		if (latencyDeviationItemProvider == null) {
			latencyDeviationItemProvider = new LatencyDeviationItemProvider(this);
		}

		return latencyDeviationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwAccessPathRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwAccessPathRefItemProvider hwAccessPathRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwAccessPathRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwAccessPathRefAdapter() {
		if (hwAccessPathRefItemProvider == null) {
			hwAccessPathRefItemProvider = new HwAccessPathRefItemProvider(this);
		}

		return hwAccessPathRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwElementRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwElementRefItemProvider hwElementRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwElementRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwElementRefAdapter() {
		if (hwElementRefItemProvider == null) {
			hwElementRefItemProvider = new HwElementRefItemProvider(this);
		}

		return hwElementRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MappingModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MappingModelItemProvider mappingModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MappingModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMappingModelAdapter() {
		if (mappingModelItemProvider == null) {
			mappingModelItemProvider = new MappingModelItemProvider(this);
		}

		return mappingModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CoreAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoreAllocationItemProvider coreAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CoreAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCoreAllocationAdapter() {
		if (coreAllocationItemProvider == null) {
			coreAllocationItemProvider = new CoreAllocationItemProvider(this);
		}

		return coreAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PhysicalSectionMappingItemProvider physicalSectionMappingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPhysicalSectionMappingAdapter() {
		if (physicalSectionMappingItemProvider == null) {
			physicalSectionMappingItemProvider = new PhysicalSectionMappingItemProvider(this);
		}

		return physicalSectionMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AbstractElementMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractElementMappingItemProvider abstractElementMappingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AbstractElementMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstractElementMappingAdapter() {
		if (abstractElementMappingItemProvider == null) {
			abstractElementMappingItemProvider = new AbstractElementMappingItemProvider(this);
		}

		return abstractElementMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TaskAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskAllocationItemProvider taskAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TaskAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskAllocationAdapter() {
		if (taskAllocationItemProvider == null) {
			taskAllocationItemProvider = new TaskAllocationItemProvider(this);
		}

		return taskAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ISRAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISRAllocationItemProvider isrAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ISRAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISRAllocationAdapter() {
		if (isrAllocationItemProvider == null) {
			isrAllocationItemProvider = new ISRAllocationItemProvider(this);
		}

		return isrAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableAllocationItemProvider runnableAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableAllocationAdapter() {
		if (runnableAllocationItemProvider == null) {
			runnableAllocationItemProvider = new RunnableAllocationItemProvider(this);
		}

		return runnableAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OSModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OSModelItemProvider osModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OSModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOSModelAdapter() {
		if (osModelItemProvider == null) {
			osModelItemProvider = new OSModelItemProvider(this);
		}

		return osModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsDataConsistency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsDataConsistencyItemProvider osDataConsistencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsDataConsistency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsDataConsistencyAdapter() {
		if (osDataConsistencyItemProvider == null) {
			osDataConsistencyItemProvider = new OsDataConsistencyItemProvider(this);
		}

		return osDataConsistencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataStability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataStabilityItemProvider dataStabilityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataStability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataStabilityAdapter() {
		if (dataStabilityItemProvider == null) {
			dataStabilityItemProvider = new DataStabilityItemProvider(this);
		}

		return dataStabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.NonAtomicDataCoherency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NonAtomicDataCoherencyItemProvider nonAtomicDataCoherencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.NonAtomicDataCoherency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNonAtomicDataCoherencyAdapter() {
		if (nonAtomicDataCoherencyItemProvider == null) {
			nonAtomicDataCoherencyItemProvider = new NonAtomicDataCoherencyItemProvider(this);
		}

		return nonAtomicDataCoherencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Semaphore} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SemaphoreItemProvider semaphoreItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Semaphore}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSemaphoreAdapter() {
		if (semaphoreItemProvider == null) {
			semaphoreItemProvider = new SemaphoreItemProvider(this);
		}

		return semaphoreItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OSEK} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OSEKItemProvider osekItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OSEK}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOSEKAdapter() {
		if (osekItemProvider == null) {
			osekItemProvider = new OSEKItemProvider(this);
		}

		return osekItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PartlyPFairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartlyPFairPD2ItemProvider partlyPFairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PartlyPFairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartlyPFairPD2Adapter() {
		if (partlyPFairPD2ItemProvider == null) {
			partlyPFairPD2ItemProvider = new PartlyPFairPD2ItemProvider(this);
		}

		return partlyPFairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PfairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PfairPD2ItemProvider pfairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PfairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPfairPD2Adapter() {
		if (pfairPD2ItemProvider == null) {
			pfairPD2ItemProvider = new PfairPD2ItemProvider(this);
		}

		return pfairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PartlyEarlyReleaseFairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartlyEarlyReleaseFairPD2ItemProvider partlyEarlyReleaseFairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PartlyEarlyReleaseFairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartlyEarlyReleaseFairPD2Adapter() {
		if (partlyEarlyReleaseFairPD2ItemProvider == null) {
			partlyEarlyReleaseFairPD2ItemProvider = new PartlyEarlyReleaseFairPD2ItemProvider(this);
		}

		return partlyEarlyReleaseFairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EarlyReleaseFairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EarlyReleaseFairPD2ItemProvider earlyReleaseFairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EarlyReleaseFairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEarlyReleaseFairPD2Adapter() {
		if (earlyReleaseFairPD2ItemProvider == null) {
			earlyReleaseFairPD2ItemProvider = new EarlyReleaseFairPD2ItemProvider(this);
		}

		return earlyReleaseFairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LeastLocalRemainingExecutionTimeFirst} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LeastLocalRemainingExecutionTimeFirstItemProvider leastLocalRemainingExecutionTimeFirstItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LeastLocalRemainingExecutionTimeFirst}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLeastLocalRemainingExecutionTimeFirstAdapter() {
		if (leastLocalRemainingExecutionTimeFirstItemProvider == null) {
			leastLocalRemainingExecutionTimeFirstItemProvider = new LeastLocalRemainingExecutionTimeFirstItemProvider(this);
		}

		return leastLocalRemainingExecutionTimeFirstItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EarliestDeadlineFirstItemProvider earliestDeadlineFirstItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEarliestDeadlineFirstAdapter() {
		if (earliestDeadlineFirstItemProvider == null) {
			earliestDeadlineFirstItemProvider = new EarliestDeadlineFirstItemProvider(this);
		}

		return earliestDeadlineFirstItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DeadlineMonotonic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeadlineMonotonicItemProvider deadlineMonotonicItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DeadlineMonotonic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeadlineMonotonicAdapter() {
		if (deadlineMonotonicItemProvider == null) {
			deadlineMonotonicItemProvider = new DeadlineMonotonicItemProvider(this);
		}

		return deadlineMonotonicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RateMonotonic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RateMonotonicItemProvider rateMonotonicItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RateMonotonic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRateMonotonicAdapter() {
		if (rateMonotonicItemProvider == null) {
			rateMonotonicItemProvider = new RateMonotonicItemProvider(this);
		}

		return rateMonotonicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PriorityBasedRoundRobin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PriorityBasedRoundRobinItemProvider priorityBasedRoundRobinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PriorityBasedRoundRobin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPriorityBasedRoundRobinAdapter() {
		if (priorityBasedRoundRobinItemProvider == null) {
			priorityBasedRoundRobinItemProvider = new PriorityBasedRoundRobinItemProvider(this);
		}

		return priorityBasedRoundRobinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.UserSpecificSchedulingAlgorithm} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UserSpecificSchedulingAlgorithmItemProvider userSpecificSchedulingAlgorithmItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.UserSpecificSchedulingAlgorithm}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUserSpecificSchedulingAlgorithmAdapter() {
		if (userSpecificSchedulingAlgorithmItemProvider == null) {
			userSpecificSchedulingAlgorithmItemProvider = new UserSpecificSchedulingAlgorithmItemProvider(this);
		}

		return userSpecificSchedulingAlgorithmItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PriorityBased} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PriorityBasedItemProvider priorityBasedItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PriorityBased}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPriorityBasedAdapter() {
		if (priorityBasedItemProvider == null) {
			priorityBasedItemProvider = new PriorityBasedItemProvider(this);
		}

		return priorityBasedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AlgorithmParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AlgorithmParameterItemProvider algorithmParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AlgorithmParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAlgorithmParameterAdapter() {
		if (algorithmParameterItemProvider == null) {
			algorithmParameterItemProvider = new AlgorithmParameterItemProvider(this);
		}

		return algorithmParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SchedulingHWUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchedulingHWUnitItemProvider schedulingHWUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SchedulingHWUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchedulingHWUnitAdapter() {
		if (schedulingHWUnitItemProvider == null) {
			schedulingHWUnitItemProvider = new SchedulingHWUnitItemProvider(this);
		}

		return schedulingHWUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SchedulingSWUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchedulingSWUnitItemProvider schedulingSWUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SchedulingSWUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchedulingSWUnitAdapter() {
		if (schedulingSWUnitItemProvider == null) {
			schedulingSWUnitItemProvider = new SchedulingSWUnitItemProvider(this);
		}

		return schedulingSWUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OperatingSystem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperatingSystemItemProvider operatingSystemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OperatingSystem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperatingSystemAdapter() {
		if (operatingSystemItemProvider == null) {
			operatingSystemItemProvider = new OperatingSystemItemProvider(this);
		}

		return operatingSystemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.VendorOperatingSystem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VendorOperatingSystemItemProvider vendorOperatingSystemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.VendorOperatingSystem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVendorOperatingSystemAdapter() {
		if (vendorOperatingSystemItemProvider == null) {
			vendorOperatingSystemItemProvider = new VendorOperatingSystemItemProvider(this);
		}

		return vendorOperatingSystemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TaskScheduler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskSchedulerItemProvider taskSchedulerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TaskScheduler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskSchedulerAdapter() {
		if (taskSchedulerItemProvider == null) {
			taskSchedulerItemProvider = new TaskSchedulerItemProvider(this);
		}

		return taskSchedulerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InterruptController} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterruptControllerItemProvider interruptControllerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InterruptController}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterruptControllerAdapter() {
		if (interruptControllerItemProvider == null) {
			interruptControllerItemProvider = new InterruptControllerItemProvider(this);
		}

		return interruptControllerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsInstructionsItemProvider osInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsInstructionsAdapter() {
		if (osInstructionsItemProvider == null) {
			osInstructionsItemProvider = new OsInstructionsItemProvider(this);
		}

		return osInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsAPIInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsAPIInstructionsItemProvider osAPIInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsAPIInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsAPIInstructionsAdapter() {
		if (osAPIInstructionsItemProvider == null) {
			osAPIInstructionsItemProvider = new OsAPIInstructionsItemProvider(this);
		}

		return osAPIInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsISRInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsISRInstructionsItemProvider osISRInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsISRInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsISRInstructionsAdapter() {
		if (osISRInstructionsItemProvider == null) {
			osISRInstructionsItemProvider = new OsISRInstructionsItemProvider(this);
		}

		return osISRInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyConstraintsModelItemProvider propertyConstraintsModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyConstraintsModelAdapter() {
		if (propertyConstraintsModelItemProvider == null) {
			propertyConstraintsModelItemProvider = new PropertyConstraintsModelItemProvider(this);
		}

		return propertyConstraintsModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessAllocationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessAllocationConstraintItemProvider processAllocationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessAllocationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessAllocationConstraintAdapter() {
		if (processAllocationConstraintItemProvider == null) {
			processAllocationConstraintItemProvider = new ProcessAllocationConstraintItemProvider(this);
		}

		return processAllocationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessPrototypeAllocationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPrototypeAllocationConstraintItemProvider processPrototypeAllocationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessPrototypeAllocationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessPrototypeAllocationConstraintAdapter() {
		if (processPrototypeAllocationConstraintItemProvider == null) {
			processPrototypeAllocationConstraintItemProvider = new ProcessPrototypeAllocationConstraintItemProvider(this);
		}

		return processPrototypeAllocationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableAllocationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableAllocationConstraintItemProvider runnableAllocationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableAllocationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableAllocationConstraintAdapter() {
		if (runnableAllocationConstraintItemProvider == null) {
			runnableAllocationConstraintItemProvider = new RunnableAllocationConstraintItemProvider(this);
		}

		return runnableAllocationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AbstractElementMappingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractElementMappingConstraintItemProvider abstractElementMappingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AbstractElementMappingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstractElementMappingConstraintAdapter() {
		if (abstractElementMappingConstraintItemProvider == null) {
			abstractElementMappingConstraintItemProvider = new AbstractElementMappingConstraintItemProvider(this);
		}

		return abstractElementMappingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwCoreProperty} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwCorePropertyItemProvider hwCorePropertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwCoreProperty}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwCorePropertyAdapter() {
		if (hwCorePropertyItemProvider == null) {
			hwCorePropertyItemProvider = new HwCorePropertyItemProvider(this);
		}

		return hwCorePropertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwCoreConjunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwCoreConjunctionItemProvider hwCoreConjunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwCoreConjunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwCoreConjunctionAdapter() {
		if (hwCoreConjunctionItemProvider == null) {
			hwCoreConjunctionItemProvider = new HwCoreConjunctionItemProvider(this);
		}

		return hwCoreConjunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwMemoryProperty} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwMemoryPropertyItemProvider hwMemoryPropertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwMemoryProperty}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwMemoryPropertyAdapter() {
		if (hwMemoryPropertyItemProvider == null) {
			hwMemoryPropertyItemProvider = new HwMemoryPropertyItemProvider(this);
		}

		return hwMemoryPropertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwMemoryConjunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwMemoryConjunctionItemProvider hwMemoryConjunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwMemoryConjunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwMemoryConjunctionAdapter() {
		if (hwMemoryConjunctionItemProvider == null) {
			hwMemoryConjunctionItemProvider = new HwMemoryConjunctionItemProvider(this);
		}

		return hwMemoryConjunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StimuliModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StimuliModelItemProvider stimuliModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StimuliModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStimuliModelAdapter() {
		if (stimuliModelItemProvider == null) {
			stimuliModelItemProvider = new StimuliModelItemProvider(this);
		}

		return stimuliModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeValueList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeValueListItemProvider modeValueListItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeValueList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeValueListAdapter() {
		if (modeValueListItemProvider == null) {
			modeValueListItemProvider = new ModeValueListItemProvider(this);
		}

		return modeValueListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeValueListEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeValueListEntryItemProvider modeValueListEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeValueListEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeValueListEntryAdapter() {
		if (modeValueListEntryItemProvider == null) {
			modeValueListEntryItemProvider = new ModeValueListEntryItemProvider(this);
		}

		return modeValueListEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Periodic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicItemProvider periodicItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Periodic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeriodicAdapter() {
		if (periodicItemProvider == null) {
			periodicItemProvider = new PeriodicItemProvider(this);
		}

		return periodicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PeriodicEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicEventItemProvider periodicEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PeriodicEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeriodicEventAdapter() {
		if (periodicEventItemProvider == null) {
			periodicEventItemProvider = new PeriodicEventItemProvider(this);
		}

		return periodicEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Synthetic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SyntheticItemProvider syntheticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Synthetic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSyntheticAdapter() {
		if (syntheticItemProvider == null) {
			syntheticItemProvider = new SyntheticItemProvider(this);
		}

		return syntheticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TimestampList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimestampListItemProvider timestampListItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TimestampList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimestampListAdapter() {
		if (timestampListItemProvider == null) {
			timestampListItemProvider = new TimestampListItemProvider(this);
		}

		return timestampListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomStimulusItemProvider customStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomStimulusAdapter() {
		if (customStimulusItemProvider == null) {
			customStimulusItemProvider = new CustomStimulusItemProvider(this);
		}

		return customStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Single} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleItemProvider singleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Single}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleAdapter() {
		if (singleItemProvider == null) {
			singleItemProvider = new SingleItemProvider(this);
		}

		return singleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InterProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterProcessItemProvider interProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InterProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterProcessAdapter() {
		if (interProcessItemProvider == null) {
			interProcessItemProvider = new InterProcessItemProvider(this);
		}

		return interProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Sporadic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SporadicItemProvider sporadicItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Sporadic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSporadicAdapter() {
		if (sporadicItemProvider == null) {
			sporadicItemProvider = new SporadicItemProvider(this);
		}

		return sporadicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventStimulusItemProvider eventStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventStimulusAdapter() {
		if (eventStimulusItemProvider == null) {
			eventStimulusItemProvider = new EventStimulusItemProvider(this);
		}

		return eventStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ArrivalCurve} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrivalCurveItemProvider arrivalCurveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ArrivalCurve}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrivalCurveAdapter() {
		if (arrivalCurveItemProvider == null) {
			arrivalCurveItemProvider = new ArrivalCurveItemProvider(this);
		}

		return arrivalCurveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrivalCurveEntryItemProvider arrivalCurveEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrivalCurveEntryAdapter() {
		if (arrivalCurveEntryItemProvider == null) {
			arrivalCurveEntryItemProvider = new ArrivalCurveEntryItemProvider(this);
		}

		return arrivalCurveEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockTriangleFunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockTriangleFunctionItemProvider clockTriangleFunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockTriangleFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockTriangleFunctionAdapter() {
		if (clockTriangleFunctionItemProvider == null) {
			clockTriangleFunctionItemProvider = new ClockTriangleFunctionItemProvider(this);
		}

		return clockTriangleFunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockSinusFunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockSinusFunctionItemProvider clockSinusFunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockSinusFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockSinusFunctionAdapter() {
		if (clockSinusFunctionItemProvider == null) {
			clockSinusFunctionItemProvider = new ClockSinusFunctionItemProvider(this);
		}

		return clockSinusFunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockMultiplierListItemProvider clockMultiplierListItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockMultiplierListAdapter() {
		if (clockMultiplierListItemProvider == null) {
			clockMultiplierListItemProvider = new ClockMultiplierListItemProvider(this);
		}

		return clockMultiplierListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockMultiplierListEntryItemProvider clockMultiplierListEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockMultiplierListEntryAdapter() {
		if (clockMultiplierListEntryItemProvider == null) {
			clockMultiplierListEntryItemProvider = new ClockMultiplierListEntryItemProvider(this);
		}

		return clockMultiplierListEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SWModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SWModelItemProvider swModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SWModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSWModelAdapter() {
		if (swModelItemProvider == null) {
			swModelItemProvider = new SWModelItemProvider(this);
		}

		return swModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomEntity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomEntityItemProvider customEntityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomEntity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomEntityAdapter() {
		if (customEntityItemProvider == null) {
			customEntityItemProvider = new CustomEntityItemProvider(this);
		}

		return customEntityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessChain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessChainItemProvider processChainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessChain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessChainAdapter() {
		if (processChainItemProvider == null) {
			processChainItemProvider = new ProcessChainItemProvider(this);
		}

		return processChainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CallGraph} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallGraphItemProvider callGraphItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CallGraph}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallGraphAdapter() {
		if (callGraphItemProvider == null) {
			callGraphItemProvider = new CallGraphItemProvider(this);
		}

		return callGraphItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CallSequence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallSequenceItemProvider callSequenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CallSequence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallSequenceAdapter() {
		if (callSequenceItemProvider == null) {
			callSequenceItemProvider = new CallSequenceItemProvider(this);
		}

		return callSequenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeSwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeSwitchItemProvider modeSwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeSwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeSwitchAdapter() {
		if (modeSwitchItemProvider == null) {
			modeSwitchItemProvider = new ModeSwitchItemProvider(this);
		}

		return modeSwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeSwitchEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeSwitchEntryItemProvider modeSwitchEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeSwitchEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeSwitchEntryAdapter() {
		if (modeSwitchEntryItemProvider == null) {
			modeSwitchEntryItemProvider = new ModeSwitchEntryItemProvider(this);
		}

		return modeSwitchEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeSwitchDefault} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeSwitchDefaultItemProvider modeSwitchDefaultItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeSwitchDefault}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeSwitchDefaultAdapter() {
		if (modeSwitchDefaultItemProvider == null) {
			modeSwitchDefaultItemProvider = new ModeSwitchDefaultItemProvider(this);
		}

		return modeSwitchDefaultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProbabiltitySwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbabiltitySwitchItemProvider probabiltitySwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProbabiltitySwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProbabiltitySwitchAdapter() {
		if (probabiltitySwitchItemProvider == null) {
			probabiltitySwitchItemProvider = new ProbabiltitySwitchItemProvider(this);
		}

		return probabiltitySwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbabilitySwitchEntryItemProvider probabilitySwitchEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProbabilitySwitchEntryAdapter() {
		if (probabilitySwitchEntryItemProvider == null) {
			probabilitySwitchEntryItemProvider = new ProbabilitySwitchEntryItemProvider(this);
		}

		return probabilitySwitchEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Counter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CounterItemProvider counterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Counter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCounterAdapter() {
		if (counterItemProvider == null) {
			counterItemProvider = new CounterItemProvider(this);
		}

		return counterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.WaitEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WaitEventItemProvider waitEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.WaitEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWaitEventAdapter() {
		if (waitEventItemProvider == null) {
			waitEventItemProvider = new WaitEventItemProvider(this);
		}

		return waitEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SetEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetEventItemProvider setEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SetEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetEventAdapter() {
		if (setEventItemProvider == null) {
			setEventItemProvider = new SetEventItemProvider(this);
		}

		return setEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClearEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearEventItemProvider clearEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClearEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClearEventAdapter() {
		if (clearEventItemProvider == null) {
			clearEventItemProvider = new ClearEventItemProvider(this);
		}

		return clearEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventMask} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventMaskItemProvider eventMaskItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventMask}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventMaskAdapter() {
		if (eventMaskItemProvider == null) {
			eventMaskItemProvider = new EventMaskItemProvider(this);
		}

		return eventMaskItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsEventItemProvider osEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsEventAdapter() {
		if (osEventItemProvider == null) {
			osEventItemProvider = new OsEventItemProvider(this);
		}

		return osEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InterProcessActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterProcessActivationItemProvider interProcessActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InterProcessActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterProcessActivationAdapter() {
		if (interProcessActivationItemProvider == null) {
			interProcessActivationItemProvider = new InterProcessActivationItemProvider(this);
		}

		return interProcessActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EnforcedMigration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnforcedMigrationItemProvider enforcedMigrationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EnforcedMigration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnforcedMigrationAdapter() {
		if (enforcedMigrationItemProvider == null) {
			enforcedMigrationItemProvider = new EnforcedMigrationItemProvider(this);
		}

		return enforcedMigrationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TaskRunnableCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskRunnableCallItemProvider taskRunnableCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TaskRunnableCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskRunnableCallAdapter() {
		if (taskRunnableCallItemProvider == null) {
			taskRunnableCallItemProvider = new TaskRunnableCallItemProvider(this);
		}

		return taskRunnableCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SchedulePoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchedulePointItemProvider schedulePointItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SchedulePoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchedulePointAdapter() {
		if (schedulePointItemProvider == null) {
			schedulePointItemProvider = new SchedulePointItemProvider(this);
		}

		return schedulePointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TerminateProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TerminateProcessItemProvider terminateProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TerminateProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTerminateProcessAdapter() {
		if (terminateProcessItemProvider == null) {
			terminateProcessItemProvider = new TerminateProcessItemProvider(this);
		}

		return terminateProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Task} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskItemProvider taskItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Task}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskAdapter() {
		if (taskItemProvider == null) {
			taskItemProvider = new TaskItemProvider(this);
		}

		return taskItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ISR} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISRItemProvider isrItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ISR}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISRAdapter() {
		if (isrItemProvider == null) {
			isrItemProvider = new ISRItemProvider(this);
		}

		return isrItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessPrototype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPrototypeItemProvider processPrototypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessPrototype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessPrototypeAdapter() {
		if (processPrototypeItemProvider == null) {
			processPrototypeItemProvider = new ProcessPrototypeItemProvider(this);
		}

		return processPrototypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChainedProcessPrototype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChainedProcessPrototypeItemProvider chainedProcessPrototypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChainedProcessPrototype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChainedProcessPrototypeAdapter() {
		if (chainedProcessPrototypeItemProvider == null) {
			chainedProcessPrototypeItemProvider = new ChainedProcessPrototypeItemProvider(this);
		}

		return chainedProcessPrototypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AccessPrecedenceSpecItemProvider accessPrecedenceSpecItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAccessPrecedenceSpecAdapter() {
		if (accessPrecedenceSpecItemProvider == null) {
			accessPrecedenceSpecItemProvider = new AccessPrecedenceSpecItemProvider(this);
		}

		return accessPrecedenceSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OrderPrecedenceSpec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderPrecedenceSpecItemProvider orderPrecedenceSpecItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OrderPrecedenceSpec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrderPrecedenceSpecAdapter() {
		if (orderPrecedenceSpecItemProvider == null) {
			orderPrecedenceSpecItemProvider = new OrderPrecedenceSpecItemProvider(this);
		}

		return orderPrecedenceSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Runnable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableItemProvider runnableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Runnable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableAdapter() {
		if (runnableItemProvider == null) {
			runnableItemProvider = new RunnableItemProvider(this);
		}

		return runnableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Label} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelItemProvider labelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Label}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelAdapter() {
		if (labelItemProvider == null) {
			labelItemProvider = new LabelItemProvider(this);
		}

		return labelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Channel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelItemProvider channelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Channel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelAdapter() {
		if (channelItemProvider == null) {
			channelItemProvider = new ChannelItemProvider(this);
		}

		return channelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeLabelItemProvider modeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeLabelAdapter() {
		if (modeLabelItemProvider == null) {
			modeLabelItemProvider = new ModeLabelItemProvider(this);
		}

		return modeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Section} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SectionItemProvider sectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Section}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSectionAdapter() {
		if (sectionItemProvider == null) {
			sectionItemProvider = new SectionItemProvider(this);
		}

		return sectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableInstructionsItemProvider runnableInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableInstructionsAdapter() {
		if (runnableInstructionsItemProvider == null) {
			runnableInstructionsItemProvider = new RunnableInstructionsItemProvider(this);
		}

		return runnableInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableInstructionsEntryItemProvider runnableInstructionsEntryItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableInstructionsEntryAdapter() {
		if (runnableInstructionsEntryItemProvider == null) {
			runnableInstructionsEntryItemProvider = new RunnableInstructionsEntryItemProvider(this);
		}

		return runnableInstructionsEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeLabelAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeLabelAccessItemProvider modeLabelAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeLabelAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeLabelAccessAdapter() {
		if (modeLabelAccessItemProvider == null) {
			modeLabelAccessItemProvider = new ModeLabelAccessItemProvider(this);
		}

		return modeLabelAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableModeSwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableModeSwitchItemProvider runnableModeSwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableModeSwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableModeSwitchAdapter() {
		if (runnableModeSwitchItemProvider == null) {
			runnableModeSwitchItemProvider = new RunnableModeSwitchItemProvider(this);
		}

		return runnableModeSwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelAccessItemProvider labelAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelAccessAdapter() {
		if (labelAccessItemProvider == null) {
			labelAccessItemProvider = new LabelAccessItemProvider(this);
		}

		return labelAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChannelSend} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelSendItemProvider channelSendItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChannelSend}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelSendAdapter() {
		if (channelSendItemProvider == null) {
			channelSendItemProvider = new ChannelSendItemProvider(this);
		}

		return channelSendItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChannelReceive} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelReceiveItemProvider channelReceiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChannelReceive}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelReceiveAdapter() {
		if (channelReceiveItemProvider == null) {
			channelReceiveItemProvider = new ChannelReceiveItemProvider(this);
		}

		return channelReceiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SemaphoreAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SemaphoreAccessItemProvider semaphoreAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SemaphoreAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSemaphoreAccessAdapter() {
		if (semaphoreAccessItemProvider == null) {
			semaphoreAccessItemProvider = new SemaphoreAccessItemProvider(this);
		}

		return semaphoreAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SenderReceiverRead} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SenderReceiverReadItemProvider senderReceiverReadItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SenderReceiverRead}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSenderReceiverReadAdapter() {
		if (senderReceiverReadItemProvider == null) {
			senderReceiverReadItemProvider = new SenderReceiverReadItemProvider(this);
		}

		return senderReceiverReadItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SenderReceiverWrite} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SenderReceiverWriteItemProvider senderReceiverWriteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SenderReceiverWrite}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSenderReceiverWriteAdapter() {
		if (senderReceiverWriteItemProvider == null) {
			senderReceiverWriteItemProvider = new SenderReceiverWriteItemProvider(this);
		}

		return senderReceiverWriteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SynchronousServerCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynchronousServerCallItemProvider synchronousServerCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SynchronousServerCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynchronousServerCallAdapter() {
		if (synchronousServerCallItemProvider == null) {
			synchronousServerCallItemProvider = new SynchronousServerCallItemProvider(this);
		}

		return synchronousServerCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AsynchronousServerCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AsynchronousServerCallItemProvider asynchronousServerCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AsynchronousServerCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAsynchronousServerCallAdapter() {
		if (asynchronousServerCallItemProvider == null) {
			asynchronousServerCallItemProvider = new AsynchronousServerCallItemProvider(this);
		}

		return asynchronousServerCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableProbabilitySwitchItemProvider runnableProbabilitySwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableProbabilitySwitchAdapter() {
		if (runnableProbabilitySwitchItemProvider == null) {
			runnableProbabilitySwitchItemProvider = new RunnableProbabilitySwitchItemProvider(this);
		}

		return runnableProbabilitySwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Group} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GroupItemProvider groupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Group}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGroupAdapter() {
		if (groupItemProvider == null) {
			groupItemProvider = new GroupItemProvider(this);
		}

		return groupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableCallItemProvider runnableCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableCallAdapter() {
		if (runnableCallItemProvider == null) {
			runnableCallItemProvider = new RunnableCallItemProvider(this);
		}

		return runnableCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InstructionsDeviation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstructionsDeviationItemProvider instructionsDeviationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InstructionsDeviation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstructionsDeviationAdapter() {
		if (instructionsDeviationItemProvider == null) {
			instructionsDeviationItemProvider = new InstructionsDeviationItemProvider(this);
		}

		return instructionsDeviationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InstructionsConstant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstructionsConstantItemProvider instructionsConstantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InstructionsConstant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstructionsConstantAdapter() {
		if (instructionsConstantItemProvider == null) {
			instructionsConstantItemProvider = new InstructionsConstantItemProvider(this);
		}

		return instructionsConstantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Struct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructItemProvider structItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Struct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructAdapter() {
		if (structItemProvider == null) {
			structItemProvider = new StructItemProvider(this);
		}

		return structItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StructEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructEntryItemProvider structEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StructEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructEntryAdapter() {
		if (structEntryItemProvider == null) {
			structEntryItemProvider = new StructEntryItemProvider(this);
		}

		return structEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Array} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayItemProvider arrayItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Array}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayAdapter() {
		if (arrayItemProvider == null) {
			arrayItemProvider = new ArrayItemProvider(this);
		}

		return arrayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Pointer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PointerItemProvider pointerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Pointer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPointerAdapter() {
		if (pointerItemProvider == null) {
			pointerItemProvider = new PointerItemProvider(this);
		}

		return pointerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TypeRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeRefItemProvider typeRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TypeRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeRefAdapter() {
		if (typeRefItemProvider == null) {
			typeRefItemProvider = new TypeRefItemProvider(this);
		}

		return typeRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataPlatformMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataPlatformMappingItemProvider dataPlatformMappingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataPlatformMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataPlatformMappingAdapter() {
		if (dataPlatformMappingItemProvider == null) {
			dataPlatformMappingItemProvider = new DataPlatformMappingItemProvider(this);
		}

		return dataPlatformMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataTypeDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataTypeDefinitionItemProvider dataTypeDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataTypeDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataTypeDefinitionAdapter() {
		if (dataTypeDefinitionItemProvider == null) {
			dataTypeDefinitionItemProvider = new DataTypeDefinitionItemProvider(this);
		}

		return dataTypeDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BaseTypeDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BaseTypeDefinitionItemProvider baseTypeDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BaseTypeDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBaseTypeDefinitionAdapter() {
		if (baseTypeDefinitionItemProvider == null) {
			baseTypeDefinitionItemProvider = new BaseTypeDefinitionItemProvider(this);
		}

		return baseTypeDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PeriodicActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicActivationItemProvider periodicActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PeriodicActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeriodicActivationAdapter() {
		if (periodicActivationItemProvider == null) {
			periodicActivationItemProvider = new PeriodicActivationItemProvider(this);
		}

		return periodicActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SporadicActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SporadicActivationItemProvider sporadicActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SporadicActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSporadicActivationAdapter() {
		if (sporadicActivationItemProvider == null) {
			sporadicActivationItemProvider = new SporadicActivationItemProvider(this);
		}

		return sporadicActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SingleActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleActivationItemProvider singleActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SingleActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleActivationAdapter() {
		if (singleActivationItemProvider == null) {
			singleActivationItemProvider = new SingleActivationItemProvider(this);
		}

		return singleActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomActivationItemProvider customActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomActivationAdapter() {
		if (customActivationItemProvider == null) {
			customActivationItemProvider = new CustomActivationItemProvider(this);
		}

		return customActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelAccessStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelAccessStatisticItemProvider labelAccessStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelAccessStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelAccessStatisticAdapter() {
		if (labelAccessStatisticItemProvider == null) {
			labelAccessStatisticItemProvider = new LabelAccessStatisticItemProvider(this);
		}

		return labelAccessStatisticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InstructionFetch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstructionFetchItemProvider instructionFetchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InstructionFetch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstructionFetchAdapter() {
		if (instructionFetchItemProvider == null) {
			instructionFetchItemProvider = new InstructionFetchItemProvider(this);
		}

		return instructionFetchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunEntityCallStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunEntityCallStatisticItemProvider runEntityCallStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunEntityCallStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunEntityCallStatisticAdapter() {
		if (runEntityCallStatisticItemProvider == null) {
			runEntityCallStatisticItemProvider = new RunEntityCallStatisticItemProvider(this);
		}

		return runEntityCallStatisticItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (amaltheaItemProvider != null) amaltheaItemProvider.dispose();
		if (commonElementsItemProvider != null) commonElementsItemProvider.dispose();
		if (tagItemProvider != null) tagItemProvider.dispose();
		if (transmissionPolicyItemProvider != null) transmissionPolicyItemProvider.dispose();
		if (instructionsDeviationItemProvider != null) instructionsDeviationItemProvider.dispose();
		if (instructionsConstantItemProvider != null) instructionsConstantItemProvider.dispose();
		if (timeItemProvider != null) timeItemProvider.dispose();
		if (signedTimeItemProvider != null) signedTimeItemProvider.dispose();
		if (frequencyItemProvider != null) frequencyItemProvider.dispose();
		if (dataSizeItemProvider != null) dataSizeItemProvider.dispose();
		if (dataRateItemProvider != null) dataRateItemProvider.dispose();
		if (customPropertyItemProvider != null) customPropertyItemProvider.dispose();
		if (listObjectItemProvider != null) listObjectItemProvider.dispose();
		if (stringObjectItemProvider != null) stringObjectItemProvider.dispose();
		if (bigIntegerObjectItemProvider != null) bigIntegerObjectItemProvider.dispose();
		if (referenceObjectItemProvider != null) referenceObjectItemProvider.dispose();
		if (integerObjectItemProvider != null) integerObjectItemProvider.dispose();
		if (longObjectItemProvider != null) longObjectItemProvider.dispose();
		if (floatObjectItemProvider != null) floatObjectItemProvider.dispose();
		if (doubleObjectItemProvider != null) doubleObjectItemProvider.dispose();
		if (booleanObjectItemProvider != null) booleanObjectItemProvider.dispose();
		if (timeObjectItemProvider != null) timeObjectItemProvider.dispose();
		if (signedTimeObjectItemProvider != null) signedTimeObjectItemProvider.dispose();
		if (deviationItemProvider != null) deviationItemProvider.dispose();
		if (weibullParametersItemProvider != null) weibullParametersItemProvider.dispose();
		if (weibullEstimatorsItemProvider != null) weibullEstimatorsItemProvider.dispose();
		if (uniformDistributionItemProvider != null) uniformDistributionItemProvider.dispose();
		if (boundariesItemProvider != null) boundariesItemProvider.dispose();
		if (gaussDistributionItemProvider != null) gaussDistributionItemProvider.dispose();
		if (betaDistributionItemProvider != null) betaDistributionItemProvider.dispose();
		if (minAvgMaxStatisticItemProvider != null) minAvgMaxStatisticItemProvider.dispose();
		if (singleValueStatisticItemProvider != null) singleValueStatisticItemProvider.dispose();
		if (modeItemProvider != null) modeItemProvider.dispose();
		if (modeLiteralItemProvider != null) modeLiteralItemProvider.dispose();
		if (componentsModelItemProvider != null) componentsModelItemProvider.dispose();
		if (componentItemProvider != null) componentItemProvider.dispose();
		if (compositeItemProvider != null) compositeItemProvider.dispose();
		if (systemItemProvider != null) systemItemProvider.dispose();
		if (componentInstanceItemProvider != null) componentInstanceItemProvider.dispose();
		if (connectorItemProvider != null) connectorItemProvider.dispose();
		if (qualifiedPortItemProvider != null) qualifiedPortItemProvider.dispose();
		if (fInterfacePortItemProvider != null) fInterfacePortItemProvider.dispose();
		if (configModelItemProvider != null) configModelItemProvider.dispose();
		if (eventConfigItemProvider != null) eventConfigItemProvider.dispose();
		if (constraintsModelItemProvider != null) constraintsModelItemProvider.dispose();
		if (runnableSequencingConstraintItemProvider != null) runnableSequencingConstraintItemProvider.dispose();
		if (processRunnableGroupItemProvider != null) processRunnableGroupItemProvider.dispose();
		if (runnableSeparationConstraintItemProvider != null) runnableSeparationConstraintItemProvider.dispose();
		if (processSeparationConstraintItemProvider != null) processSeparationConstraintItemProvider.dispose();
		if (dataSeparationConstraintItemProvider != null) dataSeparationConstraintItemProvider.dispose();
		if (runnablePairingConstraintItemProvider != null) runnablePairingConstraintItemProvider.dispose();
		if (processPairingConstraintItemProvider != null) processPairingConstraintItemProvider.dispose();
		if (dataPairingConstraintItemProvider != null) dataPairingConstraintItemProvider.dispose();
		if (targetMemoryItemProvider != null) targetMemoryItemProvider.dispose();
		if (targetCoreItemProvider != null) targetCoreItemProvider.dispose();
		if (targetSchedulerItemProvider != null) targetSchedulerItemProvider.dispose();
		if (labelEntityGroupItemProvider != null) labelEntityGroupItemProvider.dispose();
		if (runnableEntityGroupItemProvider != null) runnableEntityGroupItemProvider.dispose();
		if (processEntityGroupItemProvider != null) processEntityGroupItemProvider.dispose();
		if (tagGroupItemProvider != null) tagGroupItemProvider.dispose();
		if (eventChainItemProvider != null) eventChainItemProvider.dispose();
		if (eventChainReferenceItemProvider != null) eventChainReferenceItemProvider.dispose();
		if (subEventChainItemProvider != null) subEventChainItemProvider.dispose();
		if (physicalSectionConstraintItemProvider != null) physicalSectionConstraintItemProvider.dispose();
		if (eventSynchronizationConstraintItemProvider != null) eventSynchronizationConstraintItemProvider.dispose();
		if (eventChainSynchronizationConstraintItemProvider != null) eventChainSynchronizationConstraintItemProvider.dispose();
		if (delayConstraintItemProvider != null) delayConstraintItemProvider.dispose();
		if (eventChainLatencyConstraintItemProvider != null) eventChainLatencyConstraintItemProvider.dispose();
		if (repetitionConstraintItemProvider != null) repetitionConstraintItemProvider.dispose();
		if (dataAgeConstraintItemProvider != null) dataAgeConstraintItemProvider.dispose();
		if (dataAgeCycleItemProvider != null) dataAgeCycleItemProvider.dispose();
		if (dataAgeTimeItemProvider != null) dataAgeTimeItemProvider.dispose();
		if (processRequirementItemProvider != null) processRequirementItemProvider.dispose();
		if (runnableRequirementItemProvider != null) runnableRequirementItemProvider.dispose();
		if (architectureRequirementItemProvider != null) architectureRequirementItemProvider.dispose();
		if (processChainRequirementItemProvider != null) processChainRequirementItemProvider.dispose();
		if (cpuPercentageRequirementLimitItemProvider != null) cpuPercentageRequirementLimitItemProvider.dispose();
		if (frequencyRequirementLimitItemProvider != null) frequencyRequirementLimitItemProvider.dispose();
		if (percentageRequirementLimitItemProvider != null) percentageRequirementLimitItemProvider.dispose();
		if (countRequirementLimitItemProvider != null) countRequirementLimitItemProvider.dispose();
		if (timeRequirementLimitItemProvider != null) timeRequirementLimitItemProvider.dispose();
		if (dataCoherencyGroupItemProvider != null) dataCoherencyGroupItemProvider.dispose();
		if (dataStabilityGroupItemProvider != null) dataStabilityGroupItemProvider.dispose();
		if (processScopeItemProvider != null) processScopeItemProvider.dispose();
		if (runnableScopeItemProvider != null) runnableScopeItemProvider.dispose();
		if (componentScopeItemProvider != null) componentScopeItemProvider.dispose();
		if (eventModelItemProvider != null) eventModelItemProvider.dispose();
		if (eventSetItemProvider != null) eventSetItemProvider.dispose();
		if (customEventItemProvider != null) customEventItemProvider.dispose();
		if (stimulusEventItemProvider != null) stimulusEventItemProvider.dispose();
		if (processEventItemProvider != null) processEventItemProvider.dispose();
		if (processChainEventItemProvider != null) processChainEventItemProvider.dispose();
		if (runnableEventItemProvider != null) runnableEventItemProvider.dispose();
		if (labelEventItemProvider != null) labelEventItemProvider.dispose();
		if (channelEventItemProvider != null) channelEventItemProvider.dispose();
		if (semaphoreEventItemProvider != null) semaphoreEventItemProvider.dispose();
		if (hwModelItemProvider != null) hwModelItemProvider.dispose();
		if (hwSystemItemProvider != null) hwSystemItemProvider.dispose();
		if (ecuItemProvider != null) ecuItemProvider.dispose();
		if (microcontrollerItemProvider != null) microcontrollerItemProvider.dispose();
		if (coreItemProvider != null) coreItemProvider.dispose();
		if (memoryItemProvider != null) memoryItemProvider.dispose();
		if (networkItemProvider != null) networkItemProvider.dispose();
		if (quartzItemProvider != null) quartzItemProvider.dispose();
		if (hwComponentItemProvider != null) hwComponentItemProvider.dispose();
		if (systemTypeItemProvider != null) systemTypeItemProvider.dispose();
		if (ecuTypeItemProvider != null) ecuTypeItemProvider.dispose();
		if (microcontrollerTypeItemProvider != null) microcontrollerTypeItemProvider.dispose();
		if (coreTypeItemProvider != null) coreTypeItemProvider.dispose();
		if (memoryTypeItemProvider != null) memoryTypeItemProvider.dispose();
		if (networkTypeItemProvider != null) networkTypeItemProvider.dispose();
		if (hwPortItemProvider != null) hwPortItemProvider.dispose();
		if (pinItemProvider != null) pinItemProvider.dispose();
		if (complexPortItemProvider != null) complexPortItemProvider.dispose();
		if (complexPinItemProvider != null) complexPinItemProvider.dispose();
		if (prescalerItemProvider != null) prescalerItemProvider.dispose();
		if (crossbarSwitchItemProvider != null) crossbarSwitchItemProvider.dispose();
		if (busItemProvider != null) busItemProvider.dispose();
		if (bridgeItemProvider != null) bridgeItemProvider.dispose();
		if (latencyAccessPathItemProvider != null) latencyAccessPathItemProvider.dispose();
		if (hwAccessPathItemProvider != null) hwAccessPathItemProvider.dispose();
		if (accessPathRefItemProvider != null) accessPathRefItemProvider.dispose();
		if (latencyConstantItemProvider != null) latencyConstantItemProvider.dispose();
		if (latencyDeviationItemProvider != null) latencyDeviationItemProvider.dispose();
		if (hwAccessPathRefItemProvider != null) hwAccessPathRefItemProvider.dispose();
		if (hwElementRefItemProvider != null) hwElementRefItemProvider.dispose();
		if (mappingModelItemProvider != null) mappingModelItemProvider.dispose();
		if (coreAllocationItemProvider != null) coreAllocationItemProvider.dispose();
		if (physicalSectionMappingItemProvider != null) physicalSectionMappingItemProvider.dispose();
		if (abstractElementMappingItemProvider != null) abstractElementMappingItemProvider.dispose();
		if (taskAllocationItemProvider != null) taskAllocationItemProvider.dispose();
		if (isrAllocationItemProvider != null) isrAllocationItemProvider.dispose();
		if (runnableAllocationItemProvider != null) runnableAllocationItemProvider.dispose();
		if (osModelItemProvider != null) osModelItemProvider.dispose();
		if (osDataConsistencyItemProvider != null) osDataConsistencyItemProvider.dispose();
		if (dataStabilityItemProvider != null) dataStabilityItemProvider.dispose();
		if (nonAtomicDataCoherencyItemProvider != null) nonAtomicDataCoherencyItemProvider.dispose();
		if (semaphoreItemProvider != null) semaphoreItemProvider.dispose();
		if (osekItemProvider != null) osekItemProvider.dispose();
		if (partlyPFairPD2ItemProvider != null) partlyPFairPD2ItemProvider.dispose();
		if (pfairPD2ItemProvider != null) pfairPD2ItemProvider.dispose();
		if (partlyEarlyReleaseFairPD2ItemProvider != null) partlyEarlyReleaseFairPD2ItemProvider.dispose();
		if (earlyReleaseFairPD2ItemProvider != null) earlyReleaseFairPD2ItemProvider.dispose();
		if (leastLocalRemainingExecutionTimeFirstItemProvider != null) leastLocalRemainingExecutionTimeFirstItemProvider.dispose();
		if (earliestDeadlineFirstItemProvider != null) earliestDeadlineFirstItemProvider.dispose();
		if (deadlineMonotonicItemProvider != null) deadlineMonotonicItemProvider.dispose();
		if (rateMonotonicItemProvider != null) rateMonotonicItemProvider.dispose();
		if (priorityBasedRoundRobinItemProvider != null) priorityBasedRoundRobinItemProvider.dispose();
		if (userSpecificSchedulingAlgorithmItemProvider != null) userSpecificSchedulingAlgorithmItemProvider.dispose();
		if (priorityBasedItemProvider != null) priorityBasedItemProvider.dispose();
		if (algorithmParameterItemProvider != null) algorithmParameterItemProvider.dispose();
		if (schedulingHWUnitItemProvider != null) schedulingHWUnitItemProvider.dispose();
		if (schedulingSWUnitItemProvider != null) schedulingSWUnitItemProvider.dispose();
		if (operatingSystemItemProvider != null) operatingSystemItemProvider.dispose();
		if (vendorOperatingSystemItemProvider != null) vendorOperatingSystemItemProvider.dispose();
		if (taskSchedulerItemProvider != null) taskSchedulerItemProvider.dispose();
		if (interruptControllerItemProvider != null) interruptControllerItemProvider.dispose();
		if (osInstructionsItemProvider != null) osInstructionsItemProvider.dispose();
		if (osAPIInstructionsItemProvider != null) osAPIInstructionsItemProvider.dispose();
		if (osISRInstructionsItemProvider != null) osISRInstructionsItemProvider.dispose();
		if (propertyConstraintsModelItemProvider != null) propertyConstraintsModelItemProvider.dispose();
		if (processAllocationConstraintItemProvider != null) processAllocationConstraintItemProvider.dispose();
		if (processPrototypeAllocationConstraintItemProvider != null) processPrototypeAllocationConstraintItemProvider.dispose();
		if (runnableAllocationConstraintItemProvider != null) runnableAllocationConstraintItemProvider.dispose();
		if (abstractElementMappingConstraintItemProvider != null) abstractElementMappingConstraintItemProvider.dispose();
		if (hwCorePropertyItemProvider != null) hwCorePropertyItemProvider.dispose();
		if (hwCoreConjunctionItemProvider != null) hwCoreConjunctionItemProvider.dispose();
		if (hwMemoryPropertyItemProvider != null) hwMemoryPropertyItemProvider.dispose();
		if (hwMemoryConjunctionItemProvider != null) hwMemoryConjunctionItemProvider.dispose();
		if (stimuliModelItemProvider != null) stimuliModelItemProvider.dispose();
		if (modeValueListItemProvider != null) modeValueListItemProvider.dispose();
		if (modeValueListEntryItemProvider != null) modeValueListEntryItemProvider.dispose();
		if (periodicItemProvider != null) periodicItemProvider.dispose();
		if (periodicEventItemProvider != null) periodicEventItemProvider.dispose();
		if (syntheticItemProvider != null) syntheticItemProvider.dispose();
		if (timestampListItemProvider != null) timestampListItemProvider.dispose();
		if (customStimulusItemProvider != null) customStimulusItemProvider.dispose();
		if (singleItemProvider != null) singleItemProvider.dispose();
		if (interProcessItemProvider != null) interProcessItemProvider.dispose();
		if (sporadicItemProvider != null) sporadicItemProvider.dispose();
		if (eventStimulusItemProvider != null) eventStimulusItemProvider.dispose();
		if (arrivalCurveItemProvider != null) arrivalCurveItemProvider.dispose();
		if (arrivalCurveEntryItemProvider != null) arrivalCurveEntryItemProvider.dispose();
		if (clockTriangleFunctionItemProvider != null) clockTriangleFunctionItemProvider.dispose();
		if (clockSinusFunctionItemProvider != null) clockSinusFunctionItemProvider.dispose();
		if (clockMultiplierListItemProvider != null) clockMultiplierListItemProvider.dispose();
		if (clockMultiplierListEntryItemProvider != null) clockMultiplierListEntryItemProvider.dispose();
		if (swModelItemProvider != null) swModelItemProvider.dispose();
		if (customEntityItemProvider != null) customEntityItemProvider.dispose();
		if (processChainItemProvider != null) processChainItemProvider.dispose();
		if (callGraphItemProvider != null) callGraphItemProvider.dispose();
		if (callSequenceItemProvider != null) callSequenceItemProvider.dispose();
		if (modeSwitchItemProvider != null) modeSwitchItemProvider.dispose();
		if (modeSwitchEntryItemProvider != null) modeSwitchEntryItemProvider.dispose();
		if (modeSwitchDefaultItemProvider != null) modeSwitchDefaultItemProvider.dispose();
		if (probabiltitySwitchItemProvider != null) probabiltitySwitchItemProvider.dispose();
		if (probabilitySwitchEntryItemProvider != null) probabilitySwitchEntryItemProvider.dispose();
		if (counterItemProvider != null) counterItemProvider.dispose();
		if (waitEventItemProvider != null) waitEventItemProvider.dispose();
		if (setEventItemProvider != null) setEventItemProvider.dispose();
		if (clearEventItemProvider != null) clearEventItemProvider.dispose();
		if (eventMaskItemProvider != null) eventMaskItemProvider.dispose();
		if (osEventItemProvider != null) osEventItemProvider.dispose();
		if (interProcessActivationItemProvider != null) interProcessActivationItemProvider.dispose();
		if (enforcedMigrationItemProvider != null) enforcedMigrationItemProvider.dispose();
		if (taskRunnableCallItemProvider != null) taskRunnableCallItemProvider.dispose();
		if (schedulePointItemProvider != null) schedulePointItemProvider.dispose();
		if (terminateProcessItemProvider != null) terminateProcessItemProvider.dispose();
		if (taskItemProvider != null) taskItemProvider.dispose();
		if (isrItemProvider != null) isrItemProvider.dispose();
		if (processPrototypeItemProvider != null) processPrototypeItemProvider.dispose();
		if (chainedProcessPrototypeItemProvider != null) chainedProcessPrototypeItemProvider.dispose();
		if (accessPrecedenceSpecItemProvider != null) accessPrecedenceSpecItemProvider.dispose();
		if (orderPrecedenceSpecItemProvider != null) orderPrecedenceSpecItemProvider.dispose();
		if (runnableItemProvider != null) runnableItemProvider.dispose();
		if (labelItemProvider != null) labelItemProvider.dispose();
		if (channelItemProvider != null) channelItemProvider.dispose();
		if (modeLabelItemProvider != null) modeLabelItemProvider.dispose();
		if (sectionItemProvider != null) sectionItemProvider.dispose();
		if (runnableInstructionsItemProvider != null) runnableInstructionsItemProvider.dispose();
		if (runnableInstructionsEntryItemProvider != null) runnableInstructionsEntryItemProvider.dispose();
		if (modeLabelAccessItemProvider != null) modeLabelAccessItemProvider.dispose();
		if (runnableModeSwitchItemProvider != null) runnableModeSwitchItemProvider.dispose();
		if (labelAccessItemProvider != null) labelAccessItemProvider.dispose();
		if (channelSendItemProvider != null) channelSendItemProvider.dispose();
		if (channelReceiveItemProvider != null) channelReceiveItemProvider.dispose();
		if (semaphoreAccessItemProvider != null) semaphoreAccessItemProvider.dispose();
		if (senderReceiverReadItemProvider != null) senderReceiverReadItemProvider.dispose();
		if (senderReceiverWriteItemProvider != null) senderReceiverWriteItemProvider.dispose();
		if (synchronousServerCallItemProvider != null) synchronousServerCallItemProvider.dispose();
		if (asynchronousServerCallItemProvider != null) asynchronousServerCallItemProvider.dispose();
		if (runnableProbabilitySwitchItemProvider != null) runnableProbabilitySwitchItemProvider.dispose();
		if (groupItemProvider != null) groupItemProvider.dispose();
		if (runnableCallItemProvider != null) runnableCallItemProvider.dispose();
		if (structItemProvider != null) structItemProvider.dispose();
		if (structEntryItemProvider != null) structEntryItemProvider.dispose();
		if (arrayItemProvider != null) arrayItemProvider.dispose();
		if (pointerItemProvider != null) pointerItemProvider.dispose();
		if (typeRefItemProvider != null) typeRefItemProvider.dispose();
		if (dataPlatformMappingItemProvider != null) dataPlatformMappingItemProvider.dispose();
		if (dataTypeDefinitionItemProvider != null) dataTypeDefinitionItemProvider.dispose();
		if (baseTypeDefinitionItemProvider != null) baseTypeDefinitionItemProvider.dispose();
		if (periodicActivationItemProvider != null) periodicActivationItemProvider.dispose();
		if (sporadicActivationItemProvider != null) sporadicActivationItemProvider.dispose();
		if (singleActivationItemProvider != null) singleActivationItemProvider.dispose();
		if (customActivationItemProvider != null) customActivationItemProvider.dispose();
		if (labelAccessStatisticItemProvider != null) labelAccessStatisticItemProvider.dispose();
		if (instructionFetchItemProvider != null) instructionFetchItemProvider.dispose();
		if (runEntityCallStatisticItemProvider != null) runEntityCallStatisticItemProvider.dispose();
	}

}
