/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class CheckMetamodelStructure {
    public static void main(String[] args) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        AmaltheaPackage amPackage = AmaltheaPackage.eINSTANCE;
        System.out.println("++++ Metamodel check startet at " + dateFormat.format(new Date()));
        ArrayList<EClass> classList = new ArrayList<EClass>();
        for (EClassifier classifier : amPackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            classList.add((EClass)classifier);
        }
        for (EClass eClass : classList) {
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                EReference eRef;
                if (!(feature instanceof EReference) || !((eRef = (EReference)feature).getEType() instanceof EClass)) continue;
                EClass refClass = (EClass)eRef.getEType();
                if (eRef.isContainment()) continue;
                if (eRef.isTransient()) {
                    if (eRef.isDerived()) {
                        CheckMetamodelStructure.print("Derived reference", eClass, eRef, refClass);
                        continue;
                    }
                    CheckMetamodelStructure.print("Transient reference", eClass, eRef, refClass);
                    continue;
                }
                if (amPackage.getIReferable().isSuperTypeOf(refClass)) continue;
                CheckMetamodelStructure.print("Illegal reference", eClass, eRef, refClass);
            }
        }
        System.out.println("++++ Metamodel check finished at " + dateFormat.format(new Date()));
    }

    private static void print(String prefix, EClass origin, EReference ref, EClass target) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(": ");
        sb.append(origin.getName());
        sb.append(" -- ");
        sb.append(ref.getName());
        sb.append(" --> ");
        sb.append(target.getName());
        System.out.println(sb.toString());
    }
}

