/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.validation.api;

import java.util.List;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sphinx.emf.util.EObjectUtil;

public class EObjectHelper
implements IEObjectHelper {
    @Override
    public Object getName(EObject element) {
        return this.getAttributeValueOf(element, "name");
    }

    @Override
    public Object getAttributeValueOf(EObject item, String attribName) {
        for (EAttribute attr : item.eClass().getEAllAttributes()) {
            if (!attr.getName().equalsIgnoreCase(attribName)) continue;
            return item.eGet((EStructuralFeature)attr);
        }
        return item.eClass().getName();
    }

    @Override
    public void printAllAttributesOf(EObject item, boolean ... verbose) {
        System.out.println("A*********************************************************A");
        System.out.println("Name (=InstanceClass): " + item.eClass().getName());
        if (verbose.length > 0 && verbose[0]) {
            System.out.println("InstanceClassName: " + item.eClass().getInstanceClassName());
            System.out.println("InstanceTypeName: " + item.eClass().getInstanceTypeName());
            System.out.println("Operation Cnt: " + item.eClass().getOperationCount());
            System.out.println("eOperations Cnt: " + item.eClass().getEOperations().size());
            System.out.println("eAttributes Cnt: " + item.eClass().getEAttributes().size());
            System.out.println("eReferences Cnt: " + item.eClass().getEReferences().size());
        }
        for (EAttribute attr : item.eClass().getEAttributes()) {
            System.out.println("  - Attribute pair: {name -> value}: \"" + attr.getName() + "\" -> \"" + item.eGet((EStructuralFeature)attr) + "\"");
        }
        for (EReference ref : item.eClass().getEReferences()) {
            System.out.println("  + Reference pair: {name -> value}: \"" + ref.getName() + "\" -> \"" + item.eGet((EStructuralFeature)ref) + "\"");
        }
        for (EOperation op : item.eClass().getEOperations()) {
            System.out.println("  * Operation name: \"" + op.getName() + "\"");
        }
        System.out.println("Z*********************************************************Z");
    }

    @Override
    public <T> List<T> getAllInstancesOf(EObject contextObject, Class<T> type) {
        return EObjectUtil.getAllInstancesOf((EObject)contextObject, type, (boolean)true);
    }

    @Override
    public <T> List<T> getAllInstancesAndInheritedOf(EObject contextObject, Class<T> type) {
        return EObjectUtil.getAllInstancesOf((EObject)contextObject, type, (boolean)false);
    }
}

