/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.Arrays;
import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.LabelEvent;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.checks.impl.ConstraintsModelCheckValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class ConstraintsModelTests {
    private ConstraintsModelCheckValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new ConstraintsModelCheckValidatorImpl(this.issueCreator);
    }

    @Test
    public void testEventChainSimpleGood() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in.setName("in");
        LabelEvent mid = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid.setName("mid");
        LabelEvent out = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out.setName("out");
        EventChain simpleEC = AmaltheaFactory.eINSTANCE.createEventChain();
        simpleEC.setName("BasicEventChain");
        simpleEC.setStimulus((Event)in);
        simpleEC.setResponse((Event)out);
        SubEventChain subEC1 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec1 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec1.setName("SubEvent1");
        ec1.setStimulus((Event)in);
        ec1.setResponse((Event)mid);
        SubEventChain subEC2 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec2 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec2.setName("SubEvent2");
        ec2.setStimulus((Event)mid);
        ec2.setResponse((Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        subEC1.setEventChain(ec1);
        subEC2.setEventChain(ec2);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.eventChainConstraint(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimple_UnmatchingStimulusEventAtChainStart() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in.setName("in");
        LabelEvent mid = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid.setName("mid");
        LabelEvent in_false = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in_false.setName("in_false");
        LabelEvent out = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out.setName("out");
        EventChain simpleEC = AmaltheaFactory.eINSTANCE.createEventChain();
        simpleEC.setName("BasicEventChain");
        simpleEC.setStimulus((Event)in_false);
        simpleEC.setResponse((Event)out);
        SubEventChain subEC1 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec1 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec1.setName("SubEvent1");
        ec1.setStimulus((Event)in);
        ec1.setResponse((Event)mid);
        SubEventChain subEC2 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec2 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec2.setName("SubEvent2");
        ec2.setStimulus((Event)mid);
        ec2.setResponse((Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().addAll(Arrays.asList(subEC1, subEC2));
        subEC1.setEventChain(ec1);
        subEC2.setEventChain(ec2);
        this.issueCreator.issue((EObject)simpleEC, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"Beginning SubEventChain not found; EventChain's stimulus does not match with any SubEventChain's stimulus BasicEventChain"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.eventChainConstraint(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimple_UnmatchingResponseEventAtChainEnd() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in.setName("in");
        LabelEvent mid = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid.setName("mid");
        LabelEvent out_false = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out_false.setName("out_false");
        LabelEvent out = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out.setName("out");
        EventChain simpleEC = AmaltheaFactory.eINSTANCE.createEventChain();
        simpleEC.setName("BasicEventChain");
        simpleEC.setStimulus((Event)in);
        simpleEC.setResponse((Event)out_false);
        SubEventChain subEC1 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec1 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec1.setName("SubEvent1");
        ec1.setStimulus((Event)in);
        ec1.setResponse((Event)mid);
        subEC1.setEventChain(ec1);
        SubEventChain subEC2 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec2 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec2.setName("SubEvent2");
        ec2.setStimulus((Event)mid);
        ec2.setResponse((Event)out);
        subEC2.setEventChain(ec2);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().addAll(Arrays.asList(subEC1, subEC2));
        this.issueCreator.issue((EObject)ec2, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent2'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.eventChainConstraint(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadWrongStimulusInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in.setName("in");
        LabelEvent mid = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid.setName("mid");
        LabelEvent mid_false = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid_false.setName("mid_false");
        LabelEvent out = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out.setName("out");
        EventChain simpleEC = AmaltheaFactory.eINSTANCE.createEventChain();
        simpleEC.setName("BasicEventChain");
        simpleEC.setStimulus((Event)in);
        simpleEC.setResponse((Event)out);
        SubEventChain subEC1 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec1 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec1.setName("SubEvent1");
        ec1.setStimulus((Event)in);
        ec1.setResponse((Event)mid);
        SubEventChain subEC2 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec2 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec2.setName("SubEvent2");
        ec2.setStimulus((Event)mid_false);
        ec2.setResponse((Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().addAll(Arrays.asList(subEC1, subEC2));
        subEC1.setEventChain(ec1);
        subEC2.setEventChain(ec2);
        this.issueCreator.issue((EObject)ec1, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.eventChainConstraint(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadWrongResponseInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in.setName("in");
        LabelEvent mid = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid.setName("mid");
        LabelEvent mid_false = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid_false.setName("mid_false");
        LabelEvent out = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out.setName("out");
        EventChain simpleEC = AmaltheaFactory.eINSTANCE.createEventChain();
        simpleEC.setName("BasicEventChain");
        simpleEC.setStimulus((Event)in);
        simpleEC.setResponse((Event)out);
        SubEventChain subEC1 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec1 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec1.setName("SubEvent1");
        ec1.setStimulus((Event)in);
        ec1.setResponse((Event)mid_false);
        SubEventChain subEC2 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec2 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec2.setName("SubEvent2");
        ec2.setStimulus((Event)mid);
        ec2.setResponse((Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().addAll(Arrays.asList(subEC1, subEC2));
        subEC1.setEventChain(ec1);
        subEC2.setEventChain(ec2);
        this.issueCreator.issue((EObject)ec1, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.eventChainConstraint(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadMissingStimulusInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in.setName("in");
        LabelEvent mid = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid.setName("mid");
        LabelEvent out = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out.setName("out");
        EventChain simpleEC = AmaltheaFactory.eINSTANCE.createEventChain();
        simpleEC.setName("BasicEventChain");
        simpleEC.setStimulus((Event)in);
        simpleEC.setResponse((Event)out);
        SubEventChain subEC1 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec1 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec1.setName("SubEvent1");
        ec1.setStimulus((Event)in);
        ec1.setResponse((Event)mid);
        SubEventChain subEC2 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec2 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec2.setName("SubEvent2");
        ec2.setResponse((Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().addAll(Arrays.asList(subEC1, subEC2));
        subEC1.setEventChain(ec1);
        subEC2.setEventChain(ec2);
        this.issueCreator.issue((EObject)ec1, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.eventChainConstraint(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadMissingResponseInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = AmaltheaFactory.eINSTANCE.createLabelEvent();
        in.setName("in");
        LabelEvent mid = AmaltheaFactory.eINSTANCE.createLabelEvent();
        mid.setName("mid");
        LabelEvent out = AmaltheaFactory.eINSTANCE.createLabelEvent();
        out.setName("out");
        EventChain simpleEC = AmaltheaFactory.eINSTANCE.createEventChain();
        simpleEC.setName("BasicEventChain");
        simpleEC.setStimulus((Event)in);
        simpleEC.setResponse((Event)out);
        SubEventChain subEC1 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec1 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec1.setName("SubEvent1");
        ec1.setStimulus((Event)in);
        SubEventChain subEC2 = AmaltheaFactory.eINSTANCE.createSubEventChain();
        EventChain ec2 = AmaltheaFactory.eINSTANCE.createEventChain();
        ec2.setName("SubEvent2");
        ec2.setStimulus((Event)mid);
        ec2.setResponse((Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().addAll(Arrays.asList(subEC1, subEC2));
        subEC1.setEventChain(ec1);
        subEC2.setEventChain(ec2);
        this.issueCreator.issue((EObject)ec1, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.eventChainConstraint(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

