/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.Arrays;
import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelEvent;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessEvent;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEvent;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.SemaphoreEvent;
import org.eclipse.app4mc.amalthea.model.Single;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.StimulusEvent;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.checks.impl.EventModelCheckValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class EventModelTests {
    private EventModelCheckValidatorImpl classUnderTest;
    private IssueCreator issueCreator;
    private IEObjectHelper eObjectHelper;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.eObjectHelper = (IEObjectHelper)EasyMock.createMock(IEObjectHelper.class);
        this.classUnderTest = new EventModelCheckValidatorImpl(this.issueCreator, this.eObjectHelper);
    }

    @Test
    public void testLabelEvent_CompleteMappingInfoWithTask() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        label.setName("TestLabel");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        labelEvent.setEntity(label);
        labelEvent.setProcess((Process)process);
        labelEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testLabelEvent_CompleteMappingInfoW() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        label.setName("TestLabel");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        labelEvent.setEntity(label);
        labelEvent.setProcess((Process)process);
        labelEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testLabelEvent_MissingEntity() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        labelEvent.setProcess((Process)process);
        labelEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Entity(), new Object[]{labelEvent.getName(), "Entity"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testLabelEvent_MissingProcess() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        label.setName("TestLabel");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        labelEvent.setEntity(label);
        labelEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Process(), new Object[]{labelEvent.getName(), "Process (i.e. Task)"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testLabelEvent_MissingRunnable() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        label.setName("TestLabel");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        labelEvent.setEntity(label);
        labelEvent.setProcess((Process)process);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Runnable(), new Object[]{labelEvent.getName(), "Runnable"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testLabelEvent_MissingAll() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Entity(), new Object[]{labelEvent.getName(), "Entity"});
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Process(), new Object[]{labelEvent.getName(), "Process (i.e. Task)"});
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Runnable(), new Object[]{labelEvent.getName(), "Runnable"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testProcessEvent_CompleteMappingInfo_WithISR() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        ProcessEvent processEvent = AmaltheaFactory.eINSTANCE.createProcessEvent();
        processEvent.setName("TestProcessEvent");
        ISR process = AmaltheaFactory.eINSTANCE.createISR();
        process.setName("TestProcessAsISR");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        processEvent.setEntity((Process)process);
        processEvent.setCore(core);
        eventModel.getEvents().add((Object)processEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, ProcessEvent.class)).andReturn(Arrays.asList(processEvent));
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testProcessEvent_MissingEntity() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        ProcessEvent processEvent = AmaltheaFactory.eINSTANCE.createProcessEvent();
        processEvent.setName("TestProcessEvent");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        processEvent.setCore(core);
        eventModel.getEvents().add((Object)processEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, ProcessEvent.class)).andReturn(Arrays.asList(processEvent));
        this.issueCreator.issue((EObject)processEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getProcessEvent_Entity(), new Object[]{processEvent.getName(), "Entity (i.e. Runnable)"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testProcessEvent_MissingCore() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        ProcessEvent processEvent = AmaltheaFactory.eINSTANCE.createProcessEvent();
        processEvent.setName("TestProcessEvent");
        ISR process = AmaltheaFactory.eINSTANCE.createISR();
        process.setName("TestProcessAsISR");
        processEvent.setEntity((Process)process);
        eventModel.getEvents().add((Object)processEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, ProcessEvent.class)).andReturn(Arrays.asList(processEvent));
        this.issueCreator.issue((EObject)processEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getProcessEvent_Core(), new Object[]{processEvent.getName(), "Core"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testProcessEvent_MissingAll() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        ProcessEvent processEvent = AmaltheaFactory.eINSTANCE.createProcessEvent();
        processEvent.setName("TestProcessEvent");
        eventModel.getEvents().add((Object)processEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, ProcessEvent.class)).andReturn(Arrays.asList(processEvent));
        this.issueCreator.issue((EObject)processEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getProcessEvent_Entity(), new Object[]{processEvent.getName(), "Entity (i.e. Runnable)"});
        this.issueCreator.issue((EObject)processEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getProcessEvent_Core(), new Object[]{processEvent.getName(), "Core"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testRunnableEvent_CompleteMappingInfo() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        RunnableEvent runnableEvent = AmaltheaFactory.eINSTANCE.createRunnableEvent();
        runnableEvent.setName("TestRunnableEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        runnableEvent.setEntity(runnable);
        runnableEvent.setProcess((Process)process);
        runnableEvent.setCore(core);
        eventModel.getEvents().add((Object)runnableEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, RunnableEvent.class)).andReturn(Arrays.asList(runnableEvent));
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkRunnableEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testRunnableEvent_MissingEntity() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        RunnableEvent runnableEvent = AmaltheaFactory.eINSTANCE.createRunnableEvent();
        runnableEvent.setName("TestRunnableEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        runnableEvent.setProcess((Process)process);
        runnableEvent.setCore(core);
        eventModel.getEvents().add((Object)runnableEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, RunnableEvent.class)).andReturn(Arrays.asList(runnableEvent));
        this.issueCreator.issue((EObject)runnableEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableEvent_Entity(), new Object[]{runnableEvent.getName(), "Entity (i.e. Runnable)"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkRunnableEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testRunnableEvent_MissingProcess() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        RunnableEvent runnableEvent = AmaltheaFactory.eINSTANCE.createRunnableEvent();
        runnableEvent.setName("TestRunnableEvent");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        runnableEvent.setEntity(runnable);
        runnableEvent.setCore(core);
        eventModel.getEvents().add((Object)runnableEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, RunnableEvent.class)).andReturn(Arrays.asList(runnableEvent));
        this.issueCreator.issue((EObject)runnableEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableEvent_Process(), new Object[]{runnableEvent.getName(), "Process (i.e. Task)"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkRunnableEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testRunnableEvent_MissingCore() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        RunnableEvent runnableEvent = AmaltheaFactory.eINSTANCE.createRunnableEvent();
        runnableEvent.setName("TestRunnableEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        runnableEvent.setEntity(runnable);
        runnableEvent.setProcess((Process)process);
        eventModel.getEvents().add((Object)runnableEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, RunnableEvent.class)).andReturn(Arrays.asList(runnableEvent));
        this.issueCreator.issue((EObject)runnableEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableEvent_Core(), new Object[]{runnableEvent.getName(), "Core"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkRunnableEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testRunnableEvent_MissingAll() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        RunnableEvent runnableEvent = AmaltheaFactory.eINSTANCE.createRunnableEvent();
        runnableEvent.setName("TestRunnableEvent");
        eventModel.getEvents().add((Object)runnableEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, RunnableEvent.class)).andReturn(Arrays.asList(runnableEvent));
        this.issueCreator.issue((EObject)runnableEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableEvent_Core(), new Object[]{runnableEvent.getName(), "Core"});
        this.issueCreator.issue((EObject)runnableEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableEvent_Process(), new Object[]{runnableEvent.getName(), "Process (i.e. Task)"});
        this.issueCreator.issue((EObject)runnableEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableEvent_Entity(), new Object[]{runnableEvent.getName(), "Entity (i.e. Runnable)"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkRunnableEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testSemaphoreEvent_CompleteMappingInfo() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        semaphoreEvent.setName("TestSemaphoreEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setName("TestSemaphore");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        semaphoreEvent.setEntity(semaphore);
        semaphoreEvent.setProcess((Process)process);
        semaphoreEvent.setRunnable(runnable);
        semaphoreEvent.setCore(core);
        eventModel.getEvents().add((Object)semaphoreEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, SemaphoreEvent.class)).andReturn(Arrays.asList(semaphoreEvent));
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkSemaphoreEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testSemaphoreEvent_MissingEntity() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        semaphoreEvent.setName("TestSemaphoreEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        semaphoreEvent.setProcess((Process)process);
        semaphoreEvent.setRunnable(runnable);
        semaphoreEvent.setCore(core);
        eventModel.getEvents().add((Object)semaphoreEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, SemaphoreEvent.class)).andReturn(Arrays.asList(semaphoreEvent));
        this.issueCreator.issue((EObject)semaphoreEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreEvent_Entity(), new Object[]{semaphoreEvent.getName(), "Entity (i.e. Semaphore)"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkSemaphoreEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testSemaphoreEvent_MissingCore() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        semaphoreEvent.setName("TestSemaphoreEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setName("TestSemaphore");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        semaphoreEvent.setEntity(semaphore);
        semaphoreEvent.setProcess((Process)process);
        semaphoreEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)semaphoreEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, SemaphoreEvent.class)).andReturn(Arrays.asList(semaphoreEvent));
        this.issueCreator.issue((EObject)semaphoreEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreEvent_Core(), new Object[]{semaphoreEvent.getName(), "Core"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkSemaphoreEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testSemaphoreEvent_MissingProcess() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        semaphoreEvent.setName("TestSemaphoreEvent");
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setName("TestSemaphore");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        semaphoreEvent.setEntity(semaphore);
        semaphoreEvent.setRunnable(runnable);
        semaphoreEvent.setCore(core);
        eventModel.getEvents().add((Object)semaphoreEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, SemaphoreEvent.class)).andReturn(Arrays.asList(semaphoreEvent));
        this.issueCreator.issue((EObject)semaphoreEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreEvent_Process(), new Object[]{semaphoreEvent.getName(), "Process (i.e. Task)"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkSemaphoreEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testSemaphoreEvent_MissingRunnable() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        semaphoreEvent.setName("TestSemaphoreEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setName("TestSemaphore");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        semaphoreEvent.setEntity(semaphore);
        semaphoreEvent.setProcess((Process)process);
        semaphoreEvent.setCore(core);
        eventModel.getEvents().add((Object)semaphoreEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, SemaphoreEvent.class)).andReturn(Arrays.asList(semaphoreEvent));
        this.issueCreator.issue((EObject)semaphoreEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreEvent_Runnable(), new Object[]{semaphoreEvent.getName(), "Runnable"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkSemaphoreEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testSemaphoreEvent_MissingAll() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        semaphoreEvent.setName("TestSemaphoreEvent");
        eventModel.getEvents().add((Object)semaphoreEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, SemaphoreEvent.class)).andReturn(Arrays.asList(semaphoreEvent));
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkSemaphoreEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testStimulusEvent_CompleteMappingInfo() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        StimulusEvent stimulusEvent = AmaltheaFactory.eINSTANCE.createStimulusEvent();
        stimulusEvent.setName("TestStimulusEvent");
        Single stimulus = AmaltheaFactory.eINSTANCE.createSingle();
        stimulus.setName("TestStimulus");
        stimulusEvent.setEntity((Stimulus)stimulus);
        eventModel.getEvents().add((Object)stimulusEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, StimulusEvent.class)).andReturn(Arrays.asList(stimulusEvent));
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkStimulusEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testStimulusEvent_MissingEntity() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        StimulusEvent stimulusEvent = AmaltheaFactory.eINSTANCE.createStimulusEvent();
        stimulusEvent.setName("TestStimulusEvent");
        eventModel.getEvents().add((Object)stimulusEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, StimulusEvent.class)).andReturn(Arrays.asList(stimulusEvent));
        this.issueCreator.issue((EObject)stimulusEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getStimulusEvent_Entity(), new Object[]{stimulusEvent.getName(), "Entity (i.e. Periodic, Inter Process, ...)"});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkStimulusEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }
}

