/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ECUType;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.checks.impl.HardwareModelCheckValidatorImpl;
import org.junit.Before;
import org.junit.Test;

public class HardwareModelTests {
    private HardwareModelCheckValidatorImpl classUnderTest;
    private IssueCreator issueCreator;
    private IEObjectHelper eObjectHelper;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.eObjectHelper = (IEObjectHelper)EasyMock.createMock(IEObjectHelper.class);
        this.classUnderTest = new HardwareModelCheckValidatorImpl(this.issueCreator, this.eObjectHelper);
    }

    @Test
    public void testECUType_Attributes_NoDuplicatesSameType() {
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        ECUType ecuType = AmaltheaFactory.eINSTANCE.createECUType();
        ecuType.setName("test_ECUType_name");
        StringObject strVal1 = AmaltheaFactory.eINSTANCE.createStringObject();
        StringObject strVal2 = AmaltheaFactory.eINSTANCE.createStringObject();
        hwModel.getEcuTypes().add((Object)ecuType);
        ecuType.getCustomProperties().put((Object)"test_StrValue1_name", (Object)strVal1);
        ecuType.getCustomProperties().put((Object)"test_StrValue2_name", (Object)strVal2);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkForHwAbstractTypeDuplicateName(hwModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testECUType_Attributes_NoDuplicatesAltType() {
    }

    @Test
    public void testECUType_Attributes_DuplicateNameSameType() {
    }

    @Test
    public void testECUType_Attributes_DuplicateNameAltType() {
    }

    @Test
    public void testECUType_Attributes_NoDuplicateNameAddAttributeTwice() {
    }

    @Test
    public void testSystem_Attributes_NoDuplicatesSameType() {
    }

    @Test
    public void testSystem_Attributes_NoDuplicatesAltType() {
    }

    @Test
    public void testSystem_Attributes_DuplicateNameSameType() {
    }

    @Test
    public void testSystem_Attributes_DuplicateNameAltType() {
    }

    @Test
    public void testSystem_Attributes_NoDuplicateNameAddAttributeTwice() {
    }

    @Test
    public void testECUType_Features_NoDuplicatesSameType() {
    }

    @Test
    public void testECUType_Features_NoDuplicatesAltType() {
    }

    @Test
    public void testECUType_Features_DuplicateNameSameType() {
    }

    @Test
    public void testECUType_Features_DuplicateNameAltType() {
    }

    @Test
    public void testECUType_Features_NoDuplicateNameAddAttributeTwice() {
    }

    @Test
    public void testSystem_Features_NoDuplicatesSameType() {
    }

    @Test
    public void testSystem_Features_NoDuplicatesAltType() {
    }

    @Test
    public void testSystem_Features_DuplicateNameSameType() {
    }

    @Test
    public void testSystem_Features_DuplicateNameAltType() {
    }

    @Test
    public void testSystem_Features_NoDuplicateNameAddAttributeTwice() {
    }
}

