/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreAllocation;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.checks.impl.MappingModelCheckValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class MappingModelTests {
    private MappingModelCheckValidatorImpl classUnderTest;
    private IssueCreator issueCreator;
    private IEObjectHelper eObjectHelper;
    private Amalthea amaltheaModel = null;
    final List<ISR> allIsrs = new ArrayList<ISR>();
    final List<ISRAllocation> allIsrAllocs = new ArrayList<ISRAllocation>();
    final List<Task> allTasks = new ArrayList<Task>();
    final List<TaskAllocation> allTaskAllocs = new ArrayList<TaskAllocation>();
    final List<Scheduler> allSchedulers = new ArrayList<Scheduler>();
    final List<CoreAllocation> allCoreAllocs = new ArrayList<CoreAllocation>();

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.eObjectHelper = (IEObjectHelper)EasyMock.createMock(IEObjectHelper.class);
        this.classUnderTest = new MappingModelCheckValidatorImpl(this.issueCreator, this.eObjectHelper);
        this.amaltheaModel = this.prepareAmaltheaModel();
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)this.amaltheaModel.getMappingModel(), ISR.class)).andReturn(this.allIsrs);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)this.amaltheaModel.getMappingModel(), ISRAllocation.class)).andReturn(this.allIsrAllocs);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)this.amaltheaModel.getMappingModel(), Task.class)).andReturn(this.allTasks);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)this.amaltheaModel.getMappingModel(), TaskAllocation.class)).andReturn(this.allTaskAllocs);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesAndInheritedOf((EObject)this.amaltheaModel.getMappingModel(), Scheduler.class)).andReturn(this.allSchedulers);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesAndInheritedOf((EObject)this.amaltheaModel.getMappingModel(), CoreAllocation.class)).andReturn(this.allCoreAllocs);
    }

    private Amalthea prepareAmaltheaModel() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        amalthea.setSwModel(swModel);
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        amalthea.setOsModel(osModel);
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        amalthea.setMappingModel(mappingModel);
        return amalthea;
    }

    @Test
    public void testTaskToSchedulerToCoreMapping() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setTask(task);
        taskAlloc.setScheduler(taskScheduler);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.getCore().add((Object)core);
        coreAlloc.setScheduler((Scheduler)taskScheduler);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_UnmappedTasks() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        Task task_left = AmaltheaFactory.eINSTANCE.createTask();
        task_left.setName("TestTask_left");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setTask(task);
        taskAlloc.setScheduler(taskScheduler);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.getCore().add((Object)core);
        coreAlloc.setScheduler((Scheduler)taskScheduler);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task_left);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.add((Scheduler)taskScheduler);
        this.allTasks.addAll(Arrays.asList(task, task_left));
        this.issueCreator.issue((EObject)task_left, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTypeRef_TypeDef(), new Object[]{"Task2Scheduler Mapping-Error: Unmapped Task found: " + task_left.getName(), task_left});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_UnmappedScheduler() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        TaskScheduler taskScheduler_left = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler_left.setName("TestScheduler_left");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setTask(task);
        taskAlloc.setScheduler(taskScheduler);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.getCore().add((Object)core);
        coreAlloc.setScheduler((Scheduler)taskScheduler);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        os.getTaskSchedulers().add((Object)taskScheduler_left);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.addAll(Arrays.asList(taskScheduler, taskScheduler_left));
        this.allTasks.add(task);
        this.issueCreator.issue((EObject)taskScheduler_left, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_Name(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler not mapped to any core: " + taskScheduler_left.getName(), taskScheduler_left});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_MissingSchedulerInTaskAlloc() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setTask(task);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.getCore().add((Object)core);
        coreAlloc.setScheduler((Scheduler)taskScheduler);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.add((Scheduler)taskScheduler);
        this.allTasks.add(task);
        this.issueCreator.issue((EObject)taskAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskAllocation_Task(), new Object[]{"Task2Scheduler Mapping-Error: Task \"" + task.getName() + "\" is not mapped to any Scheduler", taskAlloc});
        this.issueCreator.issue((EObject)task, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTypeRef_TypeDef(), new Object[]{"Task2Scheduler Mapping-Error: Unmapped Task found: " + task.getName(), task});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_MissingProcessInTaskAlloc() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setScheduler(taskScheduler);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.getCore().add((Object)core);
        coreAlloc.setScheduler((Scheduler)taskScheduler);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.add((Scheduler)taskScheduler);
        this.allTasks.add(task);
        this.issueCreator.issue((EObject)taskAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskAllocation_Scheduler(), new Object[]{"Task2Scheduler Mapping-Error: Scheduler \"" + taskScheduler.getName() + "\" is not mapped to any Task", taskAlloc});
        this.issueCreator.issue((EObject)task, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTypeRef_TypeDef(), new Object[]{"Task2Scheduler Mapping-Error: Unmapped Task found: " + task.getName(), task});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_MissingProcessAndSchedulerInTaskAlloc() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.getCore().add((Object)core);
        coreAlloc.setScheduler((Scheduler)taskScheduler);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.add((Scheduler)taskScheduler);
        this.allTasks.add(task);
        this.issueCreator.issue((EObject)taskAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskAllocation_Task(), new Object[]{"Task2Scheduler Mapping-Error: Task Allocation is left blank", taskAlloc});
        this.issueCreator.issue((EObject)task, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTypeRef_TypeDef(), new Object[]{"Task2Scheduler Mapping-Error: Unmapped Task found: " + task.getName(), task});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_MissingSchedulerInCoreAlloc() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        core.setName("TestCore");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setTask(task);
        taskAlloc.setScheduler(taskScheduler);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.getCore().add((Object)core);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.add((Scheduler)taskScheduler);
        this.allTasks.add(task);
        this.issueCreator.issue((EObject)coreAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCoreAllocation_Core(), new Object[]{"Scheduler2Core Mapping-Error: Core(s) \"" + core.getName() + "\", is/are not mapped to any Scheduler", coreAlloc});
        this.issueCreator.issue((EObject)taskScheduler, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_Name(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler not mapped to any core: " + taskScheduler.getName(), taskScheduler});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_MissingCoreInCoreAlloc() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setTask(task);
        taskAlloc.setScheduler(taskScheduler);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        coreAlloc.setScheduler((Scheduler)taskScheduler);
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.add((Scheduler)taskScheduler);
        this.allTasks.add(task);
        this.issueCreator.issue((EObject)coreAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCoreAllocation_Scheduler(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler \"" + taskScheduler.getName() + "\" is not mapped to any Core", coreAlloc});
        this.issueCreator.issue((EObject)taskScheduler, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_Name(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler not mapped to any core: " + taskScheduler.getName(), taskScheduler});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testTaskToSchedulerToCoreMapping_MissingSchedulerAndCoreInCoreAlloc() {
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        task.setName("TestTask");
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        taskScheduler.setName("TestScheduler");
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("TestOS");
        TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        taskAlloc.setTask(task);
        taskAlloc.setScheduler(taskScheduler);
        CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
        this.amaltheaModel.getSwModel().getTasks().add((Object)task);
        this.amaltheaModel.getMappingModel().getTaskAllocation().add((Object)taskAlloc);
        this.amaltheaModel.getMappingModel().getCoreAllocation().add((Object)coreAlloc);
        this.amaltheaModel.getOsModel().getOperatingSystems().add((Object)os);
        os.getTaskSchedulers().add((Object)taskScheduler);
        this.allTaskAllocs.add(taskAlloc);
        this.allCoreAllocs.add(coreAlloc);
        this.allSchedulers.add((Scheduler)taskScheduler);
        this.allTasks.add(task);
        this.issueCreator.issue((EObject)coreAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCoreAllocation_Core(), new Object[]{"Scheduler2Core Mapping-Error: Core Allocation is left blank", coreAlloc});
        this.issueCreator.issue((EObject)taskScheduler, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_Name(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler not mapped to any core: " + taskScheduler.getName(), taskScheduler});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkProcessToSchedulerToCoreMapping(this.amaltheaModel.getMappingModel());
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }
}

