/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.BetaDistribution;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Distribution;
import org.eclipse.app4mc.amalthea.model.GaussDistribution;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Periodic;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SignedTime;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.UniformDistribution;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.model.WeibullParameters;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.AmaltheaModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class AmaltheaModelValidatorTests {
    private AmaltheaModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new AmaltheaModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkUniqueName_nullNames() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Task taskA = fac.createTask();
        Task taskB = fac.createTask();
        swModel.getTasks().add((Object)taskA);
        swModel.getTasks().add((Object)taskB);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)taskA, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_UniqueName(), new Object[]{taskA.getUniqueName()});
        this.issueCreator.issue((EObject)taskB, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_UniqueName(), new Object[]{taskB.getUniqueName()});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkUniqueName(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkUniqueName_nullNamesDifferentType() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Task task = fac.createTask();
        Runnable runnable = fac.createRunnable();
        swModel.getTasks().add((Object)task);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkUniqueName(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkUniqueName_ambiguousNames() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Task taskA = fac.createTask();
        Task taskB = fac.createTask();
        taskA.setName("Task");
        taskB.setName("Task");
        swModel.getTasks().add((Object)taskA);
        swModel.getTasks().add((Object)taskB);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)taskA, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_UniqueName(), new Object[]{taskA.getUniqueName()});
        this.issueCreator.issue((EObject)taskB, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_UniqueName(), new Object[]{taskB.getUniqueName()});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkUniqueName(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkUniqueName_uniqueNames() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Task taskA = fac.createTask();
        Task taskB = fac.createTask();
        taskA.setName("TaskA");
        taskB.setName("TaskB");
        swModel.getTasks().add((Object)taskA);
        swModel.getTasks().add((Object)taskB);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkUniqueName(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_InstructionsNull() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_Distribution(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_InstructionsInvalidBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        lowerBound.setValue(2L);
        upperBound.setValue(1L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_InstructionsMissingBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_InstructionsMissingLowerBound() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        LongObject upperBound = fac.createLongObject();
        upperBound.setValue(1L);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_LowerBound(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_InstructionsMissingUpperBound() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        LongObject lowerBound = fac.createLongObject();
        lowerBound.setValue(1L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_InstructionsValidBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(2L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_StimulusNull() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_Distribution(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_StimulusInvalidBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        lowerBound.setValue(2);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(1);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_StimulusMissingBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_StimulusMissingLowerBound() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        SignedTime upperBound = fac.createSignedTime();
        upperBound.setValue(1);
        upperBound.setUnit(TimeUnit.S);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_LowerBound(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_StimulusMissingUpperBound() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        lowerBound.setValue(2);
        lowerBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeviation_StimulusValidBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeviation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkBetaDistribution_Invalid() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        BetaDistribution distribution = fac.createBetaDistribution();
        distribution.setAlpha(-1.0);
        distribution.setBeta(-1.0);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getBetaDistribution_Alpha(), new Object[0]);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getBetaDistribution_Beta(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkBetaDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkBetaDistribution_AlphaUnset() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        BetaDistribution distribution = fac.createBetaDistribution();
        distribution.setBeta(1.0);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getBetaDistribution_Alpha(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkBetaDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkBetaDistribution_BetaUnset() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        BetaDistribution distribution = fac.createBetaDistribution();
        distribution.setAlpha(1.0);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getBetaDistribution_Beta(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkBetaDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkBetaDistribution_Valid() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        BetaDistribution distribution = fac.createBetaDistribution();
        distribution.setAlpha(1.0);
        distribution.setBeta(1.0);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkBetaDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkUniformDistribution_Invalid() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_LowerBound(), new Object[0]);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkUniformDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkUniformDistribution_Valid() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        UniformDistribution distribution = fac.createUniformDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkUniformDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_InstructionsNull() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(2L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Sd(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_InstructionsMeanInvalidLower() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject sd = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(2L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(0L);
        sd.setValue(1L);
        distribution.setSd((Object)sd);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_InstructionsMeanInvalidUpper() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject sd = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(2L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(3L);
        sd.setValue(1L);
        distribution.setSd((Object)sd);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_InstructionsValidMean() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject sd = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(3L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(2L);
        sd.setValue(1L);
        distribution.setSd((Object)sd);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_StimulusNull() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Sd(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_StimulusMeanInvalidLower() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        SignedTime mean = fac.createSignedTime();
        SignedTime sd = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        sd.setValue(1);
        sd.setUnit(TimeUnit.S);
        mean.setValue(0);
        mean.setUnit(TimeUnit.S);
        distribution.setMean((Object)mean);
        distribution.setSd((Object)sd);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_StimulusMeanInvalidUpper() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        SignedTime mean = fac.createSignedTime();
        SignedTime sd = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        sd.setValue(1);
        sd.setUnit(TimeUnit.S);
        mean.setValue(3);
        mean.setUnit(TimeUnit.S);
        distribution.setMean((Object)mean);
        distribution.setSd((Object)sd);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkGaussDistribution_StimulusValidMean() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        GaussDistribution distribution = fac.createGaussDistribution();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        SignedTime mean = fac.createSignedTime();
        SignedTime sd = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(3);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        sd.setValue(1);
        sd.setUnit(TimeUnit.S);
        mean.setValue(2);
        mean.setUnit(TimeUnit.S);
        distribution.setMean((Object)mean);
        distribution.setSd((Object)sd);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkGaussDistribution(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullParameters_Null() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullParameters distribution = fac.createWeibullParameters();
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullParameters(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullParameters_Invalid() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullParameters distribution = fac.createWeibullParameters();
        distribution.setKappa(-1.0);
        distribution.setLambda(-1.0);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullParameters_Kappa(), new Object[0]);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullParameters_Lambda(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullParameters(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullParameters_Valid() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullParameters distribution = fac.createWeibullParameters();
        distribution.setKappa(1.0);
        distribution.setLambda(1.0);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullParameters(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_InstructionsNull() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(2L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_InstructionsMeanInvalidLower() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(2L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(0L);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_InstructionsMeanInvalidUpper() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(2L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(3L);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_InstructionsValidMean() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(3L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(2L);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_InstructionsMissingBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        LongObject mean = fac.createLongObject();
        mean.setValue(2L);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_StimulusNull() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_StimulusMeanInvalidLower() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        SignedTime mean = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(0);
        mean.setUnit(TimeUnit.S);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_StimulusMeanInvalidUpper() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        SignedTime mean = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(2);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(3);
        mean.setUnit(TimeUnit.S);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_StimulusValidMean() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        SignedTime lowerBound = fac.createSignedTime();
        SignedTime upperBound = fac.createSignedTime();
        SignedTime mean = fac.createSignedTime();
        lowerBound.setValue(1);
        lowerBound.setUnit(TimeUnit.S);
        upperBound.setValue(3);
        upperBound.setUnit(TimeUnit.S);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(2);
        mean.setUnit(TimeUnit.S);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_StimulusMissingBounds() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        StimuliModel stimuliModel = fac.createStimuliModel();
        Periodic periodic = fac.createPeriodic();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        SignedTime mean = fac.createSignedTime();
        mean.setValue(2);
        mean.setUnit(TimeUnit.S);
        distribution.setMean((Object)mean);
        deviation.setDistribution((Distribution)distribution);
        periodic.setStimulusDeviation(deviation);
        stimuliModel.getStimuli().add((Object)periodic);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_InvalidPRemainPromille() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(3L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(2L);
        distribution.setMean((Object)mean);
        distribution.setPRemainPromille(-1.0);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_PRemainPromille(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkWeibullEstimators_ValidPRemainPromille() {
        AmaltheaFactory fac = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = fac.createAmalthea();
        SWModel swModel = fac.createSWModel();
        Runnable runnable = fac.createRunnable();
        RunnableInstructions runInstr = fac.createRunnableInstructions();
        InstructionsDeviation instructions = fac.createInstructionsDeviation();
        Deviation deviation = fac.createDeviation();
        WeibullEstimators distribution = fac.createWeibullEstimators();
        LongObject lowerBound = fac.createLongObject();
        LongObject upperBound = fac.createLongObject();
        LongObject mean = fac.createLongObject();
        lowerBound.setValue(1L);
        upperBound.setValue(3L);
        deviation.setLowerBound((Object)lowerBound);
        deviation.setUpperBound((Object)upperBound);
        mean.setValue(2L);
        distribution.setMean((Object)mean);
        distribution.setPRemainPromille(1.0);
        deviation.setDistribution((Distribution)distribution);
        instructions.setDeviation(deviation);
        runInstr.setDefault((Instructions)instructions);
        runnable.getRunnableItems().add((Object)runInstr);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullEstimators(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

