/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.RequirementLimit;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SignedTime;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.TaskSchedulingAlgorithm;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.ConstraintsModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class ConstraintsModelValidatorTests {
    private ConstraintsModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new ConstraintsModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkEDFDeadlineAvailability_missing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        OperatingSystem operatingSystem = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        EarliestDeadlineFirst edf = AmaltheaFactory.eINSTANCE.createEarliestDeadlineFirst();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        String name = "hello";
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        TaskAllocation taskAllocation = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        amalthea.setOsModel(osModel);
        osModel.getOperatingSystems().add((Object)operatingSystem);
        operatingSystem.getTaskSchedulers().add((Object)taskScheduler);
        taskScheduler.setSchedulingAlgorithm((TaskSchedulingAlgorithm)edf);
        amalthea.setSwModel(swModel);
        swModel.getTasks().add((Object)task);
        task.setName(name);
        amalthea.setMappingModel(mappingModel);
        mappingModel.getTaskAllocation().add((Object)taskAllocation);
        taskAllocation.setScheduler(taskScheduler);
        taskAllocation.setTask(task);
        this.issueCreator.issue((EObject)task, null, new Object[]{name});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEDFDeadlineAvailability(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEDFDeadlineAvailability_available() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        OperatingSystem operatingSystem = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        EarliestDeadlineFirst edf = AmaltheaFactory.eINSTANCE.createEarliestDeadlineFirst();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        String name = "hello";
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        TaskAllocation taskAllocation = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        SignedTime time = AmaltheaFactory.eINSTANCE.createSignedTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setOsModel(osModel);
        osModel.getOperatingSystems().add((Object)operatingSystem);
        operatingSystem.getTaskSchedulers().add((Object)taskScheduler);
        taskScheduler.setSchedulingAlgorithm((TaskSchedulingAlgorithm)edf);
        amalthea.setSwModel(swModel);
        swModel.getTasks().add((Object)task);
        task.setName(name);
        amalthea.setMappingModel(mappingModel);
        mappingModel.getTaskAllocation().add((Object)taskAllocation);
        taskAllocation.setScheduler(taskScheduler);
        taskAllocation.setTask(task);
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setProcess((AbstractProcess)task);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(10);
        time.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEDFDeadlineAvailability(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeadlineValue_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        SignedTime time = AmaltheaFactory.eINSTANCE.createSignedTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(-10);
        time.setUnit(unit);
        this.issueCreator.issue((EObject)limit, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimeRequirementLimit_LimitValue(), new Object[]{-10, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeadlineValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeadlineValue_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        SignedTime time = AmaltheaFactory.eINSTANCE.createSignedTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(0);
        time.setUnit(unit);
        this.issueCreator.issue((EObject)limit, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimeRequirementLimit_LimitValue(), new Object[]{0, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeadlineValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeadlineValue_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        SignedTime time = AmaltheaFactory.eINSTANCE.createSignedTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(10);
        time.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeadlineValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

