/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Clock;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierList;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry;
import org.eclipse.app4mc.amalthea.model.ClockSinusFunction;
import org.eclipse.app4mc.amalthea.model.ClockTriangleFunction;
import org.eclipse.app4mc.amalthea.model.Periodic;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.StimuliModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class StimuliModelValidatorTests {
    private StimuliModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new StimuliModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkPeriodicRecurrence_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        Periodic periodic = AmaltheaFactory.eINSTANCE.createPeriodic();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(-10);
        recurrence.setUnit(unit);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Recurrence(), new Object[]{-10, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrence(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrence_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        Periodic periodic = AmaltheaFactory.eINSTANCE.createPeriodic();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(0);
        recurrence.setUnit(unit);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Recurrence(), new Object[]{0, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrence(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrence_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        Periodic periodic = AmaltheaFactory.eINSTANCE.createPeriodic();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(10);
        recurrence.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrence(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        Periodic periodic = AmaltheaFactory.eINSTANCE.createPeriodic();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Clock(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockReferenceOfPeriodic(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        Periodic periodic = AmaltheaFactory.eINSTANCE.createPeriodic();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setClock((Clock)clock);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Clock(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockReferenceOfPeriodic(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_Existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        Periodic periodic = AmaltheaFactory.eINSTANCE.createPeriodic();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clock);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setClock((Clock)clock);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockReferenceOfPeriodic(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minPositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_maxNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMax(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_maxPositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMax(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minMaxIncorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(2.0);
        clock.setMax(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minMaxCorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(1.0);
        clock.setMax(2.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudeNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudePositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_yOffsetNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setYOffset(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_yOffsetPositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setYOffset(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudeYOffsetIncorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(2.0);
        clock.setYOffset(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudeYOffsetCorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(1.0);
        clock.setYOffset(2.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListConstraint_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clock = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry entry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        clock.getEntries().add((Object)entry);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierList(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListConstraint_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clock = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry entry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        entry.setMultiplier(-1.0);
        clock.getEntries().add((Object)entry);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Multiplier(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierList(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListConstraint_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clock = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry entry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        entry.setMultiplier(1.0);
        clock.getEntries().add((Object)entry);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierList(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

