/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BasicCheckValidatorImpl
extends AbstractValidatorImpl {
    public BasicCheckValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public BasicCheckValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkDuplicateUniqueNames(Amalthea model) {
        HashMap<String, IReferable> visitedObjects = new HashMap<String, IReferable>();
        for (IReferable element : this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)model, IReferable.class)) {
            String id = element.getUniqueName();
            if (visitedObjects.containsKey(id)) {
                IReferable firstElement = visitedObjects.put(id, null);
                if (firstElement != null) {
                    this.issueCreator.issue((EObject)firstElement, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_Name(), new Object[]{firstElement.getName()});
                }
                this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_Name(), new Object[]{element.getName()});
                continue;
            }
            visitedObjects.put(id, element);
        }
    }

    public void checkForCustomPropertyDuplicateKey(Amalthea model) {
        HashMap<String, Boolean> visitedKeys = new HashMap<String, Boolean>();
        for (IAnnotatable element : this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)model, IAnnotatable.class)) {
            visitedKeys.clear();
            for (Map.Entry entry : element.getCustomProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (visitedKeys.containsKey(key)) {
                    if (!((Boolean)visitedKeys.get(key)).booleanValue()) continue;
                    this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCustomProperty_Key(), new Object[]{this.getObjectHelper().getName((EObject)element), key});
                    visitedKeys.put(key, false);
                    continue;
                }
                visitedKeys.put(key, true);
            }
        }
    }

    public void checkWeibullParameters(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Deviation dev;
            EObject elem = (EObject)amaIter.next();
            if (!elem.eClass().getInstanceClass().equals(AmaltheaPackage.eINSTANCE.getDeviation().getInstanceClass()) || (dev = (Deviation)elem).getDistribution() == null || !dev.getDistribution().eClass().getInstanceClass().equals(AmaltheaPackage.eINSTANCE.getWeibullEstimators().getInstanceClass())) continue;
            long lowerBoundValue = ((LongObject)dev.getLowerBound()).getValue();
            long upperBoundValue = ((LongObject)dev.getUpperBound()).getValue();
            long meanValue = ((LongObject)((WeibullEstimators)dev.getDistribution()).getMean()).getValue();
            if (lowerBoundValue != upperBoundValue && lowerBoundValue != meanValue && upperBoundValue != meanValue) continue;
            this.issueCreator.issue((EObject)dev, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_Distribution(), new Object[]{lowerBoundValue, upperBoundValue});
        }
    }
}

