/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.RequirementLimit;
import org.eclipse.app4mc.amalthea.model.SignedTime;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.TaskSchedulingAlgorithm;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ConstraintsModelValidatorImpl
extends AbstractValidatorImpl {
    public ConstraintsModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public ConstraintsModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkEDFDeadlineAvailability(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<Task> tasks = new HashSet<Task>();
        HashSet<Task> tasksWithDeadlines = new HashSet<Task>();
        while (amaIter.hasNext()) {
            ProcessRequirement requirement;
            AbstractProcess process;
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof TaskAllocation) {
                Task task;
                TaskSchedulingAlgorithm schedulingAlgorithm;
                TaskAllocation taskAllocation = (TaskAllocation)elem;
                TaskScheduler taskScheduler = taskAllocation.getScheduler();
                if (taskScheduler == null || !((schedulingAlgorithm = taskScheduler.getSchedulingAlgorithm()) instanceof EarliestDeadlineFirst) || (task = taskAllocation.getTask()) == null) continue;
                tasks.add(task);
                continue;
            }
            if (!(elem instanceof ProcessRequirement) || !((process = (requirement = (ProcessRequirement)elem).getProcess()) instanceof Task)) continue;
            Task task = (Task)process;
            RequirementLimit limit = requirement.getLimit();
            if (limit == null || LimitType.UPPER_LIMIT != limit.getLimitType()) continue;
            tasksWithDeadlines.add(task);
        }
        HashSet tasksMissingDeadline = new HashSet(tasks);
        tasksMissingDeadline.removeAll(tasksWithDeadlines);
        for (Task task : tasksMissingDeadline) {
            this.issueCreator.issue((EObject)task, null, new Object[]{task.getName()});
        }
    }

    public void checkDeadlineValue(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            SignedTime time;
            TimeRequirementLimit timeRequirementLimit;
            TimeMetric metric;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof TimeRequirementLimit) || TimeMetric.RESPONSE_TIME != (metric = (timeRequirementLimit = (TimeRequirementLimit)elem).getMetric()) || (time = timeRequirementLimit.getLimitValue()) == null) continue;
            int value = time.getValue();
            TimeUnit unit = time.getUnit();
            if (value > 0 && TimeUnit._UNDEFINED_ != unit) continue;
            this.issueCreator.issue((EObject)timeRequirementLimit, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimeRequirementLimit_LimitValue(), new Object[]{value, unit});
        }
    }
}

