/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ga.lb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractGABasedMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.SimpleListBuilder;
import org.eclipse.app4mc.multicore.openmapping.model.AmaltheaModelBuilder;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.openmapping.visualizer.OMVisualizer;
import org.jenetics.Chromosome;
import org.jenetics.Genotype;
import org.jenetics.IntegerChromosome;
import org.jenetics.IntegerGene;
import org.jenetics.Optimize;
import org.jenetics.engine.Engine;
import org.jenetics.engine.EvolutionResult;
import org.jenetics.engine.EvolutionStatistics;
import org.jenetics.engine.EvolutionStream;
import org.jenetics.util.Factory;

public class GABasedLoadBalancing
extends AbstractGABasedMappingAlgorithm {
    private static List<OMTask> taskList = new ArrayList<OMTask>();
    private static List<OMCore> coreList = new ArrayList<OMCore>();
    private static long[][] utilMatrix;
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");

    private Boolean parseConstraints() {
        return true;
    }

    @Override
    public void calculateMapping() {
        long timeStep3;
        this.con.appendln("Performing GA based Load Balancing");
        long timeStart = System.nanoTime();
        this.con.appendln("Step 1: Building Task-List...");
        taskList = SimpleListBuilder.taskList(this.getSwModel());
        if (taskList == null) {
            this.con.append("Error during Task generation, exiting.");
            return;
        }
        long timeStep1 = System.nanoTime();
        this.con.appendln(" Success! (" + (timeStep1 - timeStart) / 1000000L + "ms)");
        this.con.appendln("Step 2: Building Core-List...");
        coreList = SimpleListBuilder.coreList(this.getHwModel());
        if (coreList == null) {
            this.con.appendln("Error during Core generation, exiting.");
            return;
        }
        long timeStep2 = System.nanoTime();
        this.con.appendln(" Success! (" + (timeStep2 - timeStep1) / 1000000L + "ms)");
        this.con.appendln("Step 3: Determining Constraints and narrowing down the solution space... ");
        if (!this.hasConstraints().booleanValue()) {
            this.con.appendln(" There are no propertyConstraints set, skipping this step.");
            timeStep3 = System.nanoTime();
        } else {
            if (!this.parseConstraints().booleanValue()) {
                this.con.appendln("Error during constrain analysis, exiting.");
                return;
            }
            timeStep3 = System.nanoTime();
            this.con.appendln(" Success! (" + (timeStep3 - timeStep2) / 1000000L + "ms)");
        }
        this.con.appendln("Step 4: Creating Mapping...");
        if (!this.performMappingAlgorithm()) {
            this.con.appendln("Error during performMappingAlgorithm, exiting.");
            return;
        }
        long timeStep4 = System.nanoTime();
        this.con.appendln("Success after " + (timeStep4 - timeStep3) / 1000000L + "ms.");
        this.con.appendln("Leaving mapping algorithm.");
    }

    private boolean performMappingAlgorithm() {
        int noCores = coreList.size();
        int noTasks = taskList.size();
        utilMatrix = new long[noCores][noTasks];
        for (OMCore core : coreList) {
            int indexCore = coreList.indexOf(core);
            for (OMTask task : taskList) {
                int indexTask = taskList.indexOf(task);
                GABasedLoadBalancing.utilMatrix[indexCore][indexTask] = new OMAllocation(task, core).calculateProcessingTime();
            }
        }
        Genotype gtf = Genotype.of((Chromosome)IntegerChromosome.of((int)0, (int)(noCores - 1), (int)noTasks), (Chromosome[])new Chromosome[0]);
        Engine engine = Engine.builder(GABasedLoadBalancing::evaluate, (Factory)gtf).optimize(Optimize.MINIMUM).populationSize(noTasks).build();
        EvolutionStream stream = engine.stream();
        EvolutionStatistics statistics = EvolutionStatistics.ofNumber();
        Stream stream2 = stream.limit(1000L).peek(statistics);
        Genotype result = (Genotype)stream2.collect(EvolutionResult.toBestGenotype());
        this.con.appendln(statistics.toString());
        this.con.appendln(result.toString());
        OMMapping mapping = this.generateOMMapping((Genotype<IntegerGene>)result);
        AmaltheaModelBuilder builder = new AmaltheaModelBuilder(mapping);
        this.setOsModel(builder.getAmaltheaModel().getOsModel());
        this.setMappingModel(builder.getAmaltheaModel().getMappingModel());
        OMVisualizer vis = new OMVisualizer(mapping);
        this.con.appendln("\n" + vis.getASCIIChart());
        return true;
    }

    private OMMapping generateOMMapping(Genotype<IntegerGene> mappingResult) {
        OMMapping mapping = new OMMapping();
        Iterator itChromosomes = mappingResult.iterator();
        if (mappingResult.length() != 1) {
            this.con.appendln("Invalid number of Genes");
            return null;
        }
        Chromosome intGenes = (Chromosome)itChromosomes.next();
        Iterator intGene = intGenes.iterator();
        int taskIndex = 0;
        while (intGene.hasNext()) {
            IntegerGene allele = (IntegerGene)intGene.next();
            int coreIndex = (Integer)allele.getAllele();
            OMCore core = coreList.get(coreIndex);
            OMTask task = taskList.get(taskIndex);
            OMAllocation alloc = new OMAllocation(task, core);
            mapping.addAllocation(alloc);
            ++taskIndex;
        }
        return mapping;
    }

    public static Long evaluate(Genotype<IntegerGene> gt) {
        long max = 0L;
        long[] tmpCoreLoad = new long[coreList.size()];
        Iterator itChromosomes = gt.iterator();
        int taskIndex = 0;
        while (itChromosomes.hasNext()) {
            Chromosome chromosome = (Chromosome)itChromosomes.next();
            for (IntegerGene gene : chromosome) {
                int coreIndex = (Integer)gene.getAllele();
                tmpCoreLoad[((Integer)gene.getAllele()).intValue()] = tmpCoreLoad[(Integer)gene.getAllele()] + utilMatrix[coreIndex][taskIndex];
                ++taskIndex;
            }
        }
        int i = 0;
        while (i < coreList.size()) {
            if (tmpCoreLoad[i] > max) {
                max = tmpCoreLoad[i];
            }
            ++i;
        }
        return max;
    }
}

