/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.heuristic.lb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.SimpleListBuilder;
import org.eclipse.app4mc.multicore.openmapping.model.AmaltheaModelBuilder;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.app4mc.multicore.openmapping.visualizer.OMVisualizer;

public class LoadBalancingDFG
extends AbstractMappingAlgorithm {
    private List<OMTask> taskList = new ArrayList<OMTask>();
    private List<OMCore> coreList = new ArrayList<OMCore>();
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");

    private Boolean parseConstraints() {
        return true;
    }

    @Override
    public void calculateMapping() {
        long timeStep3;
        this.con.appendln("Performing heuristic DFG Mapping");
        long timeStart = System.nanoTime();
        this.con.appendln("Step 1: Building Task-List...");
        this.taskList = SimpleListBuilder.taskList(this.getSwModel());
        if (this.taskList == null) {
            this.con.append("Error during Task generation, exiting.");
            return;
        }
        long timeStep1 = System.nanoTime();
        this.con.appendln(" Success! (" + (timeStep1 - timeStart) / 1000000L + "ms)");
        this.con.appendln("Step 2: Building Core-List...");
        this.coreList = SimpleListBuilder.coreList(this.getHwModel());
        if (this.coreList == null) {
            this.con.appendln("Error during Core generation, exiting.");
            return;
        }
        long timeStep2 = System.nanoTime();
        this.con.appendln(" Success! (" + (timeStep2 - timeStep1) / 1000000L + "ms)");
        this.con.appendln("Step 3: Determining Constraints and narrowing down the solution space... ");
        if (!this.hasConstraints().booleanValue()) {
            this.con.appendln(" There are no propertyConstraints set, skipping this step.");
            timeStep3 = System.nanoTime();
        } else {
            if (!this.parseConstraints().booleanValue()) {
                this.con.appendln("Error during constrain analysis, exiting.");
                return;
            }
            timeStep3 = System.nanoTime();
            this.con.appendln(" Success! (" + (timeStep3 - timeStep2) / 1000000L + "ms)");
        }
        this.con.appendln("Step 4: Creating Mapping...");
        if (!this.performMappingAlgorithm()) {
            this.con.appendln("Error during performMappingAlgorithm, exiting.");
            return;
        }
        long timeStep4 = System.nanoTime();
        this.con.appendln("Success after " + (timeStep4 - timeStep3) / 1000000L + "ms.");
        this.con.appendln("Leaving mapping algorithm.");
    }

    private boolean performMappingAlgorithm() {
        HashMap<OMCore, Long> coreLoad = new HashMap<OMCore, Long>();
        OMMapping hMapping = new OMMapping();
        UniversalHandler.getInstance().logCon("Sorting...");
        Collections.sort(this.taskList, new SortTasks());
        Collections.sort(this.coreList, new SortCores());
        for (OMTask task : this.taskList) {
            OMCore targetCore = null;
            long minLoad = 0L;
            for (OMCore core : this.coreList) {
                long taskLoad = new OMAllocation(task, core).calculateProcessingTime();
                long resultLoad = coreLoad.getOrDefault(core, 0L) + taskLoad;
                if (targetCore != null && resultLoad >= minLoad) continue;
                UniversalHandler.getInstance().logCon("+     Setting this core as Target!");
                minLoad = resultLoad;
                targetCore = core;
            }
            if (targetCore == null) continue;
            coreLoad.put(targetCore, minLoad);
            OMAllocation allocation = new OMAllocation(task, targetCore);
            hMapping.addAllocation(allocation);
        }
        AmaltheaModelBuilder builder = new AmaltheaModelBuilder(hMapping);
        this.setOsModel(builder.getAmaltheaModel().getOsModel());
        this.setMappingModel(builder.getAmaltheaModel().getMappingModel());
        OMVisualizer vis = new OMVisualizer(hMapping);
        this.con.appendln("\n" + vis.getASCIIChart());
        return true;
    }

    private class SortCores
    implements Comparator<OMCore> {
        @Override
        public int compare(OMCore o1, OMCore o2) {
            if (o1.getInstructionsPerSecond() == o2.getInstructionsPerSecond()) {
                return 0;
            }
            if (o1.getInstructionsPerSecond() < o2.getInstructionsPerSecond()) {
                return 1;
            }
            return -1;
        }
    }

    private class SortTasks
    implements Comparator<OMTask> {
        @Override
        public int compare(OMTask o1, OMTask o2) {
            if (o1.getInstructionCount() == o2.getInstructionCount()) {
                return 0;
            }
            if (o1.getInstructionCount() < o2.getInstructionCount()) {
                return 1;
            }
            return -1;
        }
    }
}

