/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.DoubleObject;
import org.eclipse.app4mc.amalthea.model.ECU;
import org.eclipse.app4mc.amalthea.model.HwSystem;
import org.eclipse.app4mc.amalthea.model.Microcontroller;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractILPBasedMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.AdvancedCore;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.AdvancedRunnable;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.MappingBuilder;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.VoltageLevel;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.context.NumberContext;

public class EnergyMinimization
extends AbstractILPBasedMappingAlgorithm {
    private long tCon;
    private long psPerInstruction;
    private final AmaltheaFactory osInstance = AmaltheaFactory.eINSTANCE;
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");
    private final MappingBuilder mappingHandle = new MappingBuilder();
    private final ExpressionsBasedModel ebm = new ExpressionsBasedModel();
    private final Map<Core, AdvancedCore> mCoreMap = new HashMap<Core, AdvancedCore>();
    private final Map<Runnable, AdvancedRunnable> mRunnableMap = new HashMap<Runnable, AdvancedRunnable>();
    private final List<AdvancedRunnable> lUnscheduledRunnables = new ArrayList<AdvancedRunnable>();
    private final List<VoltageLevel> lVoltageLevels = new LinkedList<VoltageLevel>();
    private final DirectedGraph<AdvancedRunnable, DefaultEdge> dag = new DirectedAcyclicGraph(DefaultEdge.class);

    @Override
    public void calculateMapping() {
        String sVersion = "Using: " + OjAlgoUtils.getTitle() + " " + OjAlgoUtils.getVersion() + " (" + OjAlgoUtils.getDate() + ")";
        UniversalHandler.getInstance().logCon("Entering ILP mapping algorithm");
        UniversalHandler.getInstance().logCon(sVersion);
        this.con.appendln("Performing ILP Mapping");
        this.con.appendln(sVersion);
        this.setOsModel(this.osInstance.createOSModel());
        OperatingSystem operatingSystem = this.osInstance.createOperatingSystem();
        operatingSystem.setName("OS");
        this.getOsModel().getOperatingSystems().add((Object)operatingSystem);
        long timeStart = Util.nanoTime();
        this.con.appendln("Step 1: Determining the lowest iteration time... ");
        if (!this.prepareMaxExecutionTime()) {
            this.con.appendln("Error during Activation analysis, exiting.");
            return;
        }
        long timeStep1 = Util.nanoTime();
        this.con.appendln("Success! (" + (timeStep1 - timeStart) / 1000000L + "ms)\n");
        this.con.appendln("Step 2: Determining Cores and calculating performance... ");
        if (!this.createAdvancedCores().booleanValue()) {
            this.con.appendln("Error during ExtendedCore generation, exiting.");
            return;
        }
        long timeStep2 = Util.nanoTime();
        this.con.appendln("Success! (" + (timeStep2 - timeStep1) / 1000000L + "ms)\n");
        this.con.appendln("Step 3: Determining Runnables and calculating their resp. execution cycles... ");
        if (!this.createAdvancedRunnables()) {
            this.con.append("Error during AdvRunnables generation, exiting.");
            return;
        }
        long timeStep3 = Util.nanoTime();
        this.con.appendln("Success! (" + (timeStep3 - timeStep2) / 1000000L + "ms)\n");
        this.con.appendln("Step 4: Creating task ordering and assignment... ");
        if (!this.scheduleAndAllocateTasks()) {
            this.con.append("Error during task ordering and assignment, exiting.");
            return;
        }
        long timeStep4 = Util.nanoTime();
        this.con.appendln("Success! (" + (timeStep4 - timeStep3) / 1000000L + "ms)\n");
        this.con.appendln("Step 5: Performing ILP based Voltage Selection... ");
        if (!this.performVoltageSelection()) {
            this.con.append("Error during voltage selection, exiting.");
            return;
        }
        long timeStep5 = Util.nanoTime();
        this.con.appendln("Success! (" + (timeStep5 - timeStep4) / 1000000L + "ms)\n");
    }

    private boolean prepareMaxExecutionTime() {
        if (this.getSwModel().getActivations().size() == 0) {
            UniversalHandler.getInstance().log("Error: Invalid SWModel.\nThere are no activation elements present in this model.", null);
            return false;
        }
        long minOffset = Long.MAX_VALUE;
        for (Activation a : this.getSwModel().getActivations()) {
            if (a instanceof PeriodicActivation) {
                PeriodicActivation entry = (PeriodicActivation)a;
                if (entry.getOffset() != null) {
                    long offset = Util.convertTime2ps(entry.getOffset());
                    if (offset >= minOffset) continue;
                    minOffset = offset;
                    continue;
                }
                UniversalHandler.getInstance().log("Invalid Activation element.\nOffset NULL!\nSkipping...", null);
                continue;
            }
            UniversalHandler.getInstance().log("Unhandled Activation element.\nSkipping...", null);
        }
        if (minOffset == Long.MAX_VALUE) {
            return false;
        }
        this.tCon = minOffset;
        this.con.appendln(" Lowest iteration time:  " + this.tCon);
        return true;
    }

    private Boolean createAdvancedCores() {
        HwSystem system = this.getHwModel().getSystem();
        if (system == null) {
            UniversalHandler.getInstance().log("Invalid HWModel.\nThere is no System element in this model.", null);
            return false;
        }
        if (system.getEcus().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid HWModel.\nThere are no ECUs in the System.", null);
            return false;
        }
        for (ECU ecu : system.getEcus()) {
            UniversalHandler.getInstance().logCon("Parsing ECU '" + ecu.getName() + "'");
            if (ecu.getMicrocontrollers().size() <= 0) {
                UniversalHandler.getInstance().log("Invalid HWModel.\nThere are no Microcontrollers in the System.", null);
                return false;
            }
            for (Microcontroller mc : ecu.getMicrocontrollers()) {
                UniversalHandler.getInstance().logCon(" Parsing Microcontroller '" + mc.getName() + "'");
                Iterator cores = mc.getCores().iterator();
                if (cores == null) {
                    UniversalHandler.getInstance().logCon(" Warning: Microcontroller contains no Cores, skipping...");
                    continue;
                }
                CoreType ct = null;
                while (cores.hasNext()) {
                    Core core = (Core)cores.next();
                    String sn = String.valueOf(core.getName()) + "_SCHED";
                    UniversalHandler.getInstance().logCon("  Adding Core '" + core.getName() + "'");
                    if (ct == null) {
                        ct = core.getCoreType();
                        this.determineVoltageLevels(ct);
                    } else if (ct != core.getCoreType()) {
                        this.con.appendln("Heterogeneous CoreTypes detected. This algorithm only supports homogeneous cores.");
                        return false;
                    }
                    AdvancedCore ac = new AdvancedCore(core, true);
                    this.mCoreMap.put(core, ac);
                    UniversalHandler.getInstance().logCon("  Creating Scheduler: " + sn);
                    TaskScheduler s = this.osInstance.createTaskScheduler();
                    s.setName(sn);
                    ac.setScheduler(s);
                    ((OperatingSystem)this.getOsModel().getOperatingSystems().get(0)).getTaskSchedulers().add((Object)s);
                    this.mappingHandle.addCoreToSchedulder(ac, (Scheduler)s);
                    this.con.appendln(" Core " + ac.getCore().getName() + ": " + ac.getPsPerInstruction());
                    if (this.psPerInstruction == 0L) {
                        this.psPerInstruction = ac.getPsPerInstruction();
                        continue;
                    }
                    if (this.psPerInstruction == ac.getPsPerInstruction()) continue;
                    this.con.appendln("Heterogeneous CoreTypes detected. This algorithm only supports homogeneous cores.");
                    return false;
                }
            }
        }
        if (this.mCoreMap.size() <= 0) {
            UniversalHandler.getInstance().logCon(" Error: It seems there have been no (correct?) core definitions this model.");
            return false;
        }
        return true;
    }

    private boolean determineVoltageLevels(CoreType ct) {
        if (ct.getCustomProperties().size() <= 0) {
            this.con.appendln("Error: CoreType contains no voltage levels.");
            return false;
        }
        HashMap<String, VoltageLevel> mVL = new HashMap<String, VoltageLevel>();
        for (Map.Entry at : ct.getCustomProperties()) {
            VoltageLevel vl;
            int type;
            String name;
            if (!((String)at.getKey()).startsWith("EnEf-") || !(at.getValue() instanceof DoubleObject)) continue;
            DoubleObject d = (DoubleObject)at.getValue();
            if (((String)at.getKey()).startsWith("EnEf-Volt_")) {
                name = ((String)at.getKey()).substring(10);
                type = 0;
            } else if (((String)at.getKey()).startsWith("EnEf-Scale_")) {
                name = ((String)at.getKey()).substring(11);
                type = 1;
            } else {
                UniversalHandler.getInstance().logCon("Warning: Unsupported attribute with EnEf prefix!");
                continue;
            }
            if (mVL.containsKey(name)) {
                vl = (VoltageLevel)mVL.get(name);
            } else {
                vl = new VoltageLevel(name);
                mVL.put(name, vl);
            }
            switch (type) {
                case 0: {
                    vl.setVolt(d.getValue());
                    break;
                }
                case 1: {
                    vl.setScale(d.getValue());
                    break;
                }
            }
        }
        for (VoltageLevel vl : mVL.values()) {
            if (vl.getScale() > 0.0 && vl.getVolt() > 0.0) {
                this.lVoltageLevels.add(vl);
                continue;
            }
            UniversalHandler.getInstance().logCon("Warning: VoltageLevel '" + vl.getName() + "' is not corretly specified!");
        }
        if (this.lVoltageLevels.size() > 0) {
            Collections.sort(this.lVoltageLevels);
            return true;
        }
        return false;
    }

    private boolean createAdvancedRunnables() {
        if (this.getSwModel().getRunnables().size() <= 0) {
            UniversalHandler.getInstance().log("Error: Invalid SWModel.\nThere are no runnables in this model.", null);
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getSwModel().getRunnables().size() + " Runnable(s).");
        for (Runnable r : this.getSwModel().getRunnables()) {
            AdvancedRunnable ar = new AdvancedRunnable(r);
            ar.setExecTime(this.psPerInstruction);
            this.lUnscheduledRunnables.add(ar);
            this.mRunnableMap.put(r, ar);
            this.dag.addVertex((Object)ar);
            this.con.appendln(" Runnable " + ar.getRunnableRef().getName() + ": " + ar.getNumberOfInstructions() + " Ins / " + ar.getExecTime() + " ps");
        }
        if (this.mRunnableMap.size() <= 0) {
            UniversalHandler.getInstance().logCon(" Error: It seems there have been no (correct?) Runnable definitions this model.");
            return false;
        }
        return true;
    }

    private boolean scheduleAndAllocateTasks() {
        if (this.mCoreMap.size() == 1) {
            return this.EDF();
        }
        return this.PrioScheduling();
    }

    private boolean EDF() {
        this.con.appendln("This algorithm only supports Multi-Core systems.");
        return false;
    }

    private boolean PrioScheduling() {
        if (this.getConstraintsModel().getRunnableSequencingConstraints().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid SWModel.\nThere are no RunnableSequencingConstraints in this model.\nLeaving Algorithm...", null);
            return false;
        }
        UniversalHandler.getInstance().logCon("Runnable dependencies (Source->Target)");
        for (RunnableSequencingConstraint rsc : this.getConstraintsModel().getRunnableSequencingConstraints()) {
            this.proccessRSC(rsc);
        }
        for (AdvancedRunnable node : this.dag.vertexSet()) {
            node.setLft(this.calculateLft(node));
        }
        while (this.lUnscheduledRunnables.size() > 0) {
            long startTime;
            AdvancedCore bestFitCore;
            this.updateReadyTimes();
            Collections.sort(this.lUnscheduledRunnables);
            AdvancedRunnable ar = this.lUnscheduledRunnables.get(0);
            Iterator<Map.Entry<Core, AdvancedCore>> itCores = this.mCoreMap.entrySet().iterator();
            AdvancedCore targetStage1 = null;
            AdvancedCore targetStage2 = null;
            AdvancedCore targetStage3 = null;
            while (itCores.hasNext()) {
                AdvancedCore ac = itCores.next().getValue();
                if (ac.getAvailTime() == ar.getReadyTime()) {
                    targetStage1 = ac;
                    break;
                }
                if (ac.getAvailTime() < ar.getReadyTime() && ac.getAvailTime() >= AdvancedCore.getMaxAvailTime()) {
                    targetStage2 = ac;
                }
                if (ac.getAvailTime() > AdvancedCore.getMinAvailTime()) continue;
                targetStage3 = ac;
            }
            if (targetStage1 != null) {
                bestFitCore = targetStage1;
                startTime = ar.getReadyTime();
            } else if (targetStage2 != null) {
                bestFitCore = targetStage2;
                startTime = ar.getReadyTime();
            } else if (targetStage3 != null) {
                bestFitCore = targetStage3;
                startTime = bestFitCore.getAvailTime();
            } else {
                this.con.appendln("ERR!!!");
                return false;
            }
            bestFitCore.setAvailTime(startTime + ar.getExecTime());
            bestFitCore.addRunnable(ar);
            ar.setStartTime(startTime);
            this.lUnscheduledRunnables.remove(ar);
            this.updateMinAvailTime();
        }
        this.createInterCoreDependencies();
        return true;
    }

    private void createInterCoreDependencies() {
        UniversalHandler.getInstance().logCon("Creating Inter-Core dependencies...");
        for (AdvancedCore c : this.mCoreMap.values()) {
            AdvancedRunnable prev = null;
            UniversalHandler.getInstance().logCon("Processing: " + c.getCore().getName());
            for (AdvancedRunnable ar : c.getRunnables()) {
                UniversalHandler.getInstance().logCon(" Processing: " + ar.getRunnableRef().getName());
                if (prev != null && !this.dag.containsEdge((Object)prev, (Object)ar)) {
                    this.dag.addEdge((Object)prev, (Object)ar);
                }
                prev = ar;
            }
        }
    }

    private void proccessRSC(RunnableSequencingConstraint rsc) {
        AdvancedRunnable target;
        if (rsc.getRunnableGroups().size() != 2) {
            UniversalHandler.getInstance().log("Invalid RunnableSequencingConstraint.\nRunnableSequencingConstraints must contain 2 RunnableGroups.\nSkipping...", null);
            return;
        }
        ProcessRunnableGroup originGroup = (ProcessRunnableGroup)rsc.getRunnableGroups().get(0);
        ProcessRunnableGroup targetGroup = (ProcessRunnableGroup)rsc.getRunnableGroups().get(1);
        if (originGroup.getRunnables().size() != 1 || targetGroup.getRunnables().size() != 1) {
            UniversalHandler.getInstance().log("Invalid ProcessRunnableGroup.\nProcessRunnableGroup must contain one ProcessRunnableGroupEntry.\nSkipping...", null);
            return;
        }
        Runnable originRunnable = (Runnable)originGroup.getRunnables().get(0);
        Runnable targetRunnable = (Runnable)targetGroup.getRunnables().get(0);
        if (originRunnable == null || targetRunnable == null) {
            UniversalHandler.getInstance().log("Invalid ProcessRunnableGroupEntry.\nProcessRunnableGroupEntry must reference one Runnable.\nSkipping...", null);
            return;
        }
        if (originRunnable == targetRunnable) {
            UniversalHandler.getInstance().logCon("Same Runnable - No Edge!");
            return;
        }
        AdvancedRunnable origin = this.mRunnableMap.get(originRunnable);
        if (this.dag.getEdge((Object)origin, (Object)(target = this.mRunnableMap.get(targetRunnable))) != null) {
            UniversalHandler.getInstance().logCon("ERR: Edge already Present: " + origin.getRunnableRef().getName() + " -> " + target.getRunnableRef().getName());
            return;
        }
        UniversalHandler.getInstance().logCon(String.valueOf(origin.getRunnableRef().getName()) + " -> " + target.getRunnableRef().getName());
        this.dag.addEdge((Object)origin, (Object)target);
    }

    private long calculateLft(AdvancedRunnable node) {
        long deadline;
        if (node.getLft() != -1L) {
            return node.getLft();
        }
        if (this.dag.outDegreeOf((Object)node) == 0) {
            long deadline2;
            if (node.getRunnableRef().getDeadline() != null && (deadline2 = Util.convertTime2ps(node.getRunnableRef().getDeadline())) < this.tCon) {
                return deadline2;
            }
            return this.tCon;
        }
        long least = Long.MAX_VALUE;
        for (DefaultEdge e : this.dag.outgoingEdgesOf((Object)node)) {
            AdvancedRunnable succesor = (AdvancedRunnable)this.dag.getEdgeTarget((Object)e);
            long lft_s = this.calculateLft(succesor) - succesor.getExecTime();
            if (lft_s >= least) continue;
            least = lft_s;
        }
        if (node.getRunnableRef().getDeadline() != null && (deadline = Util.convertTime2ps(node.getRunnableRef().getDeadline())) < least) {
            return deadline;
        }
        return least;
    }

    private void updateReadyTimes() {
        TopologicalOrderIterator itSortedAdvRunnables = new TopologicalOrderIterator(this.dag);
        while (itSortedAdvRunnables.hasNext()) {
            AdvancedRunnable ar = (AdvancedRunnable)itSortedAdvRunnables.next();
            if (this.dag.inDegreeOf((Object)ar) == 0) {
                ar.setReadyTime(0L);
                continue;
            }
            Iterator itIncoming = this.dag.incomingEdgesOf((Object)ar).iterator();
            long newLatestFinishTime = -1L;
            while (itIncoming.hasNext()) {
                DefaultEdge edge = (DefaultEdge)itIncoming.next();
                AdvancedRunnable arPredecessor = (AdvancedRunnable)this.dag.getEdgeSource((Object)edge);
                if (newLatestFinishTime >= arPredecessor.getEarliestStartTime() + arPredecessor.getExecTime()) continue;
                newLatestFinishTime = arPredecessor.getEarliestStartTime() + arPredecessor.getExecTime();
            }
            ar.setReadyTime(newLatestFinishTime);
        }
    }

    private void updateMinAvailTime() {
        Iterator<Map.Entry<Core, AdvancedCore>> itCores = this.mCoreMap.entrySet().iterator();
        long localMin = Long.MAX_VALUE;
        while (itCores.hasNext()) {
            AdvancedCore ac = itCores.next().getValue();
            if (localMin <= ac.getAvailTime()) continue;
            localMin = ac.getAvailTime();
        }
        AdvancedCore.setMinAvailTime(localMin);
    }

    private boolean performVoltageSelection() {
        AdvancedRunnable in = new AdvancedRunnable(null);
        AdvancedRunnable out = new AdvancedRunnable(null);
        this.dag.addVertex((Object)in);
        this.dag.addVertex((Object)out);
        Iterator<Map.Entry<Core, AdvancedCore>> itCores = this.mCoreMap.entrySet().iterator();
        while (itCores.hasNext()) {
            AdvancedCore ac = itCores.next().getValue();
            AdvancedRunnable first = ac.getRunnables().get(0);
            AdvancedRunnable last = ac.getRunnables().get(ac.getRunnables().size() - 1);
            this.dag.addEdge((Object)in, (Object)first);
            this.dag.addEdge((Object)last, (Object)out);
        }
        this.mappingHandle.setVoltageLevels(this.lVoltageLevels);
        double scaleHigh = this.lVoltageLevels.get(0).getScale();
        double voltHigh = this.lVoltageLevels.get(0).getVolt();
        this.lVoltageLevels.remove(0);
        for (AdvancedRunnable ar : this.dag.vertexSet()) {
            String idD = "D_" + ar.getIndex();
            Variable D = ((Variable)Variable.make((String)idD).lower((Number)0)).integer(true);
            this.ebm.addVariable(D);
            ar.setVarDu(D);
            String idNu = "N_" + ar.getIndex();
            Variable Nu = (Variable)Variable.make((String)idNu).level((Number)ar.getNumberOfInstructions());
            this.ebm.addVariable(Nu);
            ar.setVarNu(Nu);
            Iterator<VoltageLevel> itVl = this.lVoltageLevels.iterator();
            Expression eDelay = this.ebm.addExpression("posDelay-N_" + ar.getIndex());
            Expression eConN = this.ebm.addExpression("ConN_" + ar.getIndex());
            while (itVl.hasNext()) {
                VoltageLevel vl = itVl.next();
                String idNui = "N_" + ar.getIndex() + "_" + this.lVoltageLevels.indexOf(vl);
                Variable Nui = ((Variable)Variable.make((String)idNui).lower((Number)0)).integer(true);
                this.ebm.addVariable(Nui);
                ar.addVarNui(vl, Nui);
                long ct = (long)((double)this.psPerInstruction / vl.getScale() - (double)this.psPerInstruction / scaleHigh);
                eDelay.setLinearFactor(Nui, (Number)ct);
                eConN.setLinearFactor(Nui, (Number)1);
            }
            eDelay.lower((Number)0);
            eConN.setLinearFactor(Nu, (Number)-1);
            eConN.upper((Number)0);
        }
        Expression eRuntime = this.ebm.addExpression("Runtime");
        eRuntime.setLinearFactor(out.getVarDu(), (Number)1);
        eRuntime.setLinearFactor(in.getVarDu(), (Number)-1);
        eRuntime.upper((Number)this.tCon);
        for (DefaultEdge edge : this.dag.edgeSet()) {
            AdvancedRunnable source = (AdvancedRunnable)this.dag.getEdgeSource((Object)edge);
            AdvancedRunnable target = (AdvancedRunnable)this.dag.getEdgeTarget((Object)edge);
            Expression eSequencing = this.ebm.addExpression("Seq_" + source.getIndex() + "->" + target.getIndex());
            eSequencing.setLinearFactor(target.getVarDu(), (Number)1);
            eSequencing.setLinearFactor(source.getVarDu(), (Number)-1);
            for (VoltageLevel vl : this.lVoltageLevels) {
                Variable nui = source.getVarNui(vl);
                long ct = (long)(-1.0 * ((double)this.psPerInstruction / vl.getScale() - (double)this.psPerInstruction / scaleHigh));
                eSequencing.setLinearFactor(nui, (Number)ct);
            }
            eSequencing.lower((Number)source.getExecTime());
        }
        for (AdvancedRunnable ar : this.mRunnableMap.values()) {
            Expression obj = this.ebm.addExpression("Obj_" + ar.getIndex());
            obj.weight((Number)1);
            for (VoltageLevel vl : this.lVoltageLevels) {
                obj.setLinearFactor(ar.getVarNui(vl), (Number)(vl.getVolt() * vl.getVolt() - voltHigh * voltHigh));
            }
            obj.setLinearFactor(ar.getVarNu(), (Number)(voltHigh * voltHigh));
        }
        this.con.appendln("ILP solver settings");
        this.con.appendln(" Max gap: " + this.ebm.options.mip_gap);
        this.con.appendln(" Max iterations (abort): " + this.ebm.options.iterations_abort);
        this.con.appendln(" Max iterations (suffice): " + this.ebm.options.iterations_suffice);
        this.con.appendln(" Max time (abort): " + this.ebm.options.time_abort);
        this.con.appendln(" Max time (suffice): " + this.ebm.options.time_suffice);
        this.con.appendln("Working...");
        this.ebm.options.validate = true;
        boolean success = false;
        this.con.appendln("MathContext (Precision/Scale) set to ...");
        int prec = 8;
        while (prec < 256 && !success) {
            int scale = 8;
            while (scale < 256 && !success) {
                if (scale % 128 == 0) {
                    this.con.appendln("");
                }
                this.ebm.options.problem = NumberContext.getGeneral((int)prec, (int)scale);
                Optimisation.Result res = this.ebm.minimise();
                this.con.append(" " + prec + "/" + scale + "...");
                if (!res.getState().isFailure()) {
                    success = true;
                    this.con.appendln(" success!");
                    this.con.appendln("Objective Minimization successful!");
                    this.con.appendln(" Objective value: " + res.getValue());
                    this.con.appendln(" Solution state: " + res.getState().toString() + "\n");
                }
                scale += 8;
            }
            prec += 8;
        }
        if (!success) {
            return false;
        }
        for (AdvancedCore ac : this.mCoreMap.values()) {
            for (AdvancedRunnable ar : ac.getRunnables()) {
                this.mappingHandle.addRunnableToCore(ac, ar);
            }
        }
        this.mappingHandle.generateMapping();
        this.setMappingModel(this.mappingHandle.getMappingModel());
        this.con.appendln("Allocations:");
        this.con.appendln(this.mappingHandle.getAllocation());
        this.con.appendln("Core Utilization:");
        this.con.appendln(this.mappingHandle.getBarChart());
        String exTime = String.format("%-,18.5f ms", out.getVarDu().getValue().doubleValue() / Math.pow(10.0, 9.0));
        this.con.appendln("Total Execution time:\t" + exTime);
        this.con.appendln(this.mappingHandle.getSlowDownText());
        this.con.focus();
        return true;
    }

    private static class Util {
        private Util() {
        }

        /*
         * Exception decompiling
         */
        static long convertTime2ps(Time t) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl43 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl43 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static long nanoTime() {
            return System.nanoTime();
        }
    }
}

