/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.taskgen.pragmatic;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Runnable;

public class ExtendedProcessPrototype {
    private final List<Runnable> lRunnables = new LinkedList<Runnable>();
    private final List<Runnable> lOrphanRunnables = new LinkedList<Runnable>();
    private final List<AbstractMap.SimpleEntry<Runnable, Runnable>> lEdges = new LinkedList<AbstractMap.SimpleEntry<Runnable, Runnable>>();
    private final Runnable last;
    private final String name;

    public ExtendedProcessPrototype(String name, Runnable first, Runnable last) {
        this.name = name;
        this.last = last;
    }

    public void createRunnableList() {
        this.tSort();
    }

    public void addEdge(Runnable source, Runnable target) {
        this.lEdges.add(new AbstractMap.SimpleEntry<Runnable, Runnable>(source, target));
    }

    public void addOrphanRunnable(Runnable r) {
        this.lOrphanRunnables.add(r);
    }

    public String getName() {
        return this.name;
    }

    public List<Runnable> getRunnableList() {
        return this.lRunnables;
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + "Information about " + this.name + "\n";
        out = String.valueOf(out) + "No Runnables: " + this.lRunnables.size() + "\n";
        out = String.valueOf(out) + "No Orphans: " + this.lOrphanRunnables.size() + "\n";
        out = String.valueOf(out) + "No Edges: " + this.lEdges.size() + "\n";
        out = String.valueOf(out) + "Final Runnable List\n";
        for (Runnable runnable : this.lRunnables) {
            out = String.valueOf(out) + runnable.getName() + "\n";
        }
        out = String.valueOf(out) + "List of orphan Runnables\n";
        for (Runnable runnable : this.lOrphanRunnables) {
            out = String.valueOf(out) + runnable.getName() + "\n";
        }
        out = String.valueOf(out) + "List of Edges\n";
        for (AbstractMap.SimpleEntry simpleEntry : this.lEdges) {
            out = String.valueOf(out) + ((Runnable)simpleEntry.getKey()).getName() + "<=>" + ((Runnable)simpleEntry.getValue()).getName() + "\n";
        }
        return out;
    }

    private void tSort() {
        HashMap<Runnable, Integer> mIncEdgesNo = new HashMap<Runnable, Integer>();
        HashMap mFollowerList = new HashMap();
        Iterator<AbstractMap.SimpleEntry<Runnable, Runnable>> graphEdges = this.lEdges.iterator();
        while (graphEdges.hasNext()) {
            List<Object> tmp = new ArrayList<Runnable>();
            AbstractMap.SimpleEntry<Runnable, Runnable> edge = graphEdges.next();
            Runnable origin = edge.getKey();
            Runnable target = edge.getValue();
            if (mFollowerList.containsKey(origin)) {
                tmp = (List)mFollowerList.get(origin);
            }
            tmp.add(target);
            mFollowerList.put(origin, tmp);
            if (!mIncEdgesNo.containsKey(origin)) {
                mIncEdgesNo.put(origin, 0);
            }
            if (!mIncEdgesNo.containsKey(target)) {
                mIncEdgesNo.put(target, 1);
                continue;
            }
            mIncEdgesNo.put(target, (Integer)mIncEdgesNo.get(target) + 1);
        }
        while (!mIncEdgesNo.isEmpty()) {
            Iterator it = mIncEdgesNo.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry runFollowers = it.next();
                if ((Integer)runFollowers.getValue() != 0) continue;
                this.lRunnables.add((Runnable)runFollowers.getKey());
                if (mFollowerList.containsKey(runFollowers.getKey())) {
                    for (Runnable cRun : (List)mFollowerList.get(runFollowers.getKey())) {
                        mIncEdgesNo.put(cRun, (Integer)mIncEdgesNo.get(cRun) - 1);
                    }
                    mFollowerList.remove(runFollowers.getKey());
                }
                it.remove();
            }
        }
        for (Runnable orphanNode : this.lOrphanRunnables) {
            if (this.lRunnables.contains(orphanNode)) continue;
            this.lRunnables.add(orphanNode);
        }
        if (this.last != null && !this.lRunnables.contains(this.last) && !this.lOrphanRunnables.contains(this.last)) {
            this.lRunnables.add(this.last);
        }
    }
}

