/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.taskgen.pragmatic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.Periodic;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractTaskCreationAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.taskgen.pragmatic.ExtendedProcessPrototype;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PragmaticTaskGenerator
extends AbstractTaskCreationAlgorithm {
    private final Map<Activation, Stimulus> mActivationStimuli = new HashMap<Activation, Stimulus>();
    private final Map<ProcessPrototype, ExtendedProcessPrototype> lProcessPrototypes = new HashMap<ProcessPrototype, ExtendedProcessPrototype>();
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");

    private boolean initProcessPrototypes() {
        if (this.getSwModel().getProcessPrototypes().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid SWModel.\nThere are no ProcessPrototypes in this model.\nLeaving Algorithm...", null);
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getSwModel().getProcessPrototypes().size() + " Process Prototype(s)");
        for (ProcessPrototype pp : this.getSwModel().getProcessPrototypes()) {
            ExtendedProcessPrototype epp = new ExtendedProcessPrototype(pp.getName(), pp.getFirstRunnable(), pp.getLastRunnable());
            this.lProcessPrototypes.put(pp, epp);
        }
        return true;
    }

    private boolean convertActivations() {
        if (this.getSwModel().getActivations().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid SWModel.\nThere are no Activation elements in this model.\nLeaving Algorithm...", null);
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getSwModel().getActivations().size() + " Activation element(s)");
        for (Activation activation : this.getSwModel().getActivations()) {
            if (activation instanceof PeriodicActivation) {
                PeriodicActivation entry = (PeriodicActivation)activation;
                String name = entry.getName();
                UniversalHandler.getInstance().logCon("Connverting Periodic Activation Element '" + name);
                Periodic stimuliPeriodic = this.getStimuliInstance().createPeriodic();
                stimuliPeriodic.setName(name);
                if (entry.getOffset() != null) {
                    stimuliPeriodic.setOffset((Time)EcoreUtil.copy((EObject)entry.getOffset()));
                }
                if (entry.getMax() != null) {
                    stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)entry.getMax()));
                }
                if (entry.getMin() != null) {
                    stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)entry.getMin()));
                }
                if (entry.getDeadline() != null) {
                    stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)entry.getDeadline()));
                }
                this.getStimuliModel().getStimuli().add((Object)stimuliPeriodic);
                this.mActivationStimuli.put((Activation)entry, (Stimulus)stimuliPeriodic);
                continue;
            }
            UniversalHandler.getInstance().log("Unhandled Activation element.\nSkipping...", null);
        }
        return true;
    }

    private void processRunnableSequencingConstraint(RunnableSequencingConstraint rsc) {
        if (rsc.getRunnableGroups().size() != 2) {
            UniversalHandler.getInstance().log("Invalid RunnableSequencingConstraint.\nRunnableSequencingConstraints must contain 2 RunnableGroups.\nSkipping...", null);
            return;
        }
        ProcessRunnableGroup originGroup = (ProcessRunnableGroup)rsc.getRunnableGroups().get(0);
        ProcessRunnableGroup targetGroup = (ProcessRunnableGroup)rsc.getRunnableGroups().get(1);
        if (originGroup.getRunnables().size() != 1 || targetGroup.getRunnables().size() != 1) {
            UniversalHandler.getInstance().log("Invalid ProcessRunnableGroup.\nProcessRunnableGroup must contain one ProcessRunnableGroupEntry.\nSkipping...", null);
            return;
        }
        if (1 != rsc.getProcessScope().size()) {
            UniversalHandler.getInstance().log("Invalid ProcessRunnableGroupEntry.\nProcessRunnableGroupEntry must reference one AbstractProcess.\nSkipping...", null);
            return;
        }
        Runnable originRunnable = (Runnable)originGroup.getRunnables().get(0);
        Runnable targetRunnable = (Runnable)targetGroup.getRunnables().get(0);
        AbstractProcess abstractProcess = (AbstractProcess)rsc.getProcessScope().get(0);
        if (!(abstractProcess instanceof ProcessPrototype)) {
            UniversalHandler.getInstance().log("Invalid ProcessScope reference.\nThe ProcessScope must reference a ProcessPrototype.\nSkipping...", null);
            return;
        }
        ProcessPrototype processPrototype = (ProcessPrototype)abstractProcess;
        if (originRunnable == null || targetRunnable == null) {
            UniversalHandler.getInstance().log("Invalid ProcessRunnableGroupEntry.\nProcessRunnableGroupEntry must reference one Runnable.\nSkipping...", null);
            return;
        }
        ExtendedProcessPrototype epp = this.lProcessPrototypes.get(processPrototype);
        epp.addEdge(originRunnable, targetRunnable);
    }

    private boolean createRunnableDependencyGraph() {
        if (this.getConstraintsModel() == null || this.getConstraintsModel().getRunnableSequencingConstraints() == null || this.getConstraintsModel().getRunnableSequencingConstraints().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid ConstraintsModel.\nThere are no RunnableSequencingConstraints in this model.\nLeaving Algorithm...", null);
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getConstraintsModel().getRunnableSequencingConstraints().size() + " Sequencing Constraint(s)");
        for (RunnableSequencingConstraint rsc : this.getConstraintsModel().getRunnableSequencingConstraints()) {
            this.processRunnableSequencingConstraint(rsc);
        }
        return true;
    }

    @Override
    public void createTasks() {
        UniversalHandler.getInstance().setPluginId(OpenMappingPlugin.getPluginId());
        if (OpenMappingPlugin.getDefault() != null) {
            UniversalHandler.getInstance().setLog(OpenMappingPlugin.getDefault().getLog());
        }
        UniversalHandler.getInstance().log("Entering Pragmatic Task-Creation algorithm.");
        this.setStimuliModel(this.getStimuliInstance().createStimuliModel());
        if (!this.initProcessPrototypes()) {
            UniversalHandler.getInstance().log("Error during ProcessPrototype initialization.\nLeaving Algorithm...", null);
            return;
        }
        UniversalHandler.getInstance().logCon("ProcessPrototypes successfully initialized.");
        if (!this.convertActivations()) {
            UniversalHandler.getInstance().log("Error during Activation element conversion.\nLeaving Algorithm...", null);
            return;
        }
        UniversalHandler.getInstance().logCon("Activation elements successfully converted.");
        if (!this.createRunnableDependencyGraph()) {
            UniversalHandler.getInstance().log("Error during dependency graph generation.\nLeaving Algorithm...", null);
            return;
        }
        UniversalHandler.getInstance().log("Runnable Dependency Graph has been successfully created.", null);
        for (Map.Entry<ProcessPrototype, ExtendedProcessPrototype> e : this.lProcessPrototypes.entrySet()) {
            ProcessPrototype pp = e.getKey();
            ExtendedProcessPrototype epp = e.getValue();
            String name = pp.getName();
            epp.createRunnableList();
            List<Runnable> lRunnables = epp.getRunnableList();
            if (lRunnables.isEmpty()) {
                UniversalHandler.getInstance().logCon("Unexpected Runnable list (List Empty?).\nSkipping entry...");
                break;
            }
            Task task = this.getSwInstance().createTask();
            task.setName("Task_" + name);
            CallGraph cGraph = this.getSwInstance().createCallGraph();
            CallSequence cSeq = this.getSwInstance().createCallSequence();
            for (Runnable run : lRunnables) {
                TaskRunnableCall trc = this.getSwInstance().createTaskRunnableCall();
                trc.setRunnable(run);
                cSeq.getCalls().add((Object)trc);
            }
            cGraph.getGraphEntries().add((Object)cSeq);
            task.setCallGraph(cGraph);
            if (pp.getActivation() != null) {
                task.getStimuli().add((Object)this.mActivationStimuli.get(pp.getActivation()));
            }
            this.getSwModel().getTasks().add((Object)task);
            UniversalHandler.getInstance().logCon("Added Task: '" + task.getName() + "'");
            this.con.appendln("Added Task: '" + task.getName() + "'");
        }
        UniversalHandler.getInstance().logCon("Leaving Pragmatic Task-Creation algorithm.");
        this.con.appendln("Done!\n");
        this.con.focus();
    }
}

