/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.handlers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.app4mc.multicore.openmapping.algorithms.taskgen.pragmatic.PragmaticTaskGenerator;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;

public class CreateTasks
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        URI uri;
        UniversalHandler.getInstance().setPluginId(OpenMappingPlugin.getPluginId());
        UniversalHandler.getInstance().setLog(OpenMappingPlugin.getDefault().getLog());
        IPreferenceStore store = OpenMappingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole")) {
            UniversalHandler.getInstance().enableVerboseOutput();
        }
        int radioOutputDirectory = store.getInt("org.eclipse.app4mc.multicore.openmapping.outputLocation");
        String sOutputDirectory = store.getString("org.eclipse.app4mc.multicore.openmapping.outputLocationString");
        ArrayList<EObject> outModels = new ArrayList<EObject>();
        IFile swModelFile = UniversalHandler.getInstance().getSelectedFile(event);
        String fileName = new File(swModelFile.getFullPath().toOSString()).getName();
        String rawFileName = fileName.substring(0, fileName.lastIndexOf(46));
        UniversalHandler.getInstance().dropCache();
        UniversalHandler.getInstance().readModels(URI.createPlatformResourceURI((String)swModelFile.getFullPath().toOSString(), (boolean)true), true);
        CommonElements commonElements = UniversalHandler.getInstance().getCommonElements();
        SWModel sourceSwModel = UniversalHandler.getInstance().getSwModel();
        if (sourceSwModel == null) {
            UniversalHandler.getInstance().logCon("There seems to be no software model in the selected file.\nExiting...");
            return null;
        }
        ConstraintsModel conModel = UniversalHandler.getInstance().getConstraintsModel();
        if (conModel == null) {
            UniversalHandler.getInstance().logCon("There seems to be no constraints model in the selected file.\nExiting...");
            return null;
        }
        PropertyConstraintsModel pcModel = UniversalHandler.getInstance().getPropertyConstraintsModel();
        PragmaticTaskGenerator createTaskAlgorithm = new PragmaticTaskGenerator();
        createTaskAlgorithm.setCommonElements(commonElements);
        createTaskAlgorithm.setSwModel(sourceSwModel);
        createTaskAlgorithm.setConstraintsModel(conModel);
        createTaskAlgorithm.createTasks();
        SWModel targetSwModel = createTaskAlgorithm.getSwModel();
        if (targetSwModel == null) {
            System.out.println("An error occured during the task creation process");
            System.out.println("Check the error logs for further details");
            System.out.println("No changes will be made to the software model until this issue is fixed");
            return null;
        }
        StimuliModel stimuliModel = createTaskAlgorithm.getStimuliModel();
        if (stimuliModel == null) {
            System.out.println("An error occured during the task creation process");
            System.out.println("Check the error logs for further details");
            System.out.println("No changes will be made to the software model until this issue is fixed");
            return null;
        }
        outModels.add((EObject)commonElements);
        outModels.add((EObject)targetSwModel);
        outModels.add((EObject)stimuliModel);
        outModels.add((EObject)conModel);
        if (pcModel != null) {
            outModels.add((EObject)pcModel);
        }
        if (radioOutputDirectory == 0 || sOutputDirectory == null || sOutputDirectory.isEmpty()) {
            String outputLocation = String.valueOf(swModelFile.getProject().getFullPath().toString()) + "/output/";
            uri = URI.createPlatformResourceURI((String)(String.valueOf(outputLocation) + rawFileName + "_withTasks.amxmi"), (boolean)true);
        } else if (radioOutputDirectory == 1) {
            String outputLocation = String.valueOf(swModelFile.getProject().getFullPath().toString()) + "/" + sOutputDirectory;
            uri = URI.createPlatformResourceURI((String)(String.valueOf(outputLocation) + "/" + rawFileName + "_withTasks.amxmi"), (boolean)true);
        } else {
            uri = URI.createFileURI((String)(String.valueOf(sOutputDirectory) + "/" + rawFileName + "_withTasks.amxmi"));
        }
        UniversalHandler.getInstance().writeModel(uri, outModels);
        return null;
    }
}

