/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.handlers;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PerformMappingGUI
extends TitleAreaDialog {
    String workingDirectory;
    private String initName;
    private String initSWModel;
    private String nameOfCompilation;
    private String pathToSWModel;
    private String pathToHWModel;
    private Text textProjectName;
    Text textSWModelFile;
    Text textHWModelFile;

    public PerformMappingGUI(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Mapping");
    }

    protected Point getInitialSize() {
        return new Point(600, 380);
    }

    protected Control createDialogArea(final Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Label label1 = new Label(parent, 0);
        label1.setText("Name of the Project");
        this.textProjectName = new Text(parent, 2048);
        this.textProjectName.setLayoutData((Object)gridData);
        if (this.initName != null) {
            this.textProjectName.setText(this.initName);
        }
        new Label(parent, 0);
        Label label2 = new Label(parent, 0);
        label2.setText("Path to Software Model");
        this.textSWModelFile = new Text(parent, 2048);
        this.textSWModelFile.setLayoutData((Object)gridData);
        if (this.initSWModel != null) {
            this.textSWModelFile.setText(this.initSWModel);
        }
        Button btwSearchSWModel = new Button(parent, 0);
        btwSearchSWModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = parent.getShell();
                String selection = PerformMappingGUI.this.openFileDialog(shell, "Select Software Model", "*.amxmi; *.amxmi-sw", PerformMappingGUI.this.workingDirectory);
                if (selection != null) {
                    PerformMappingGUI.this.textSWModelFile.setText(selection);
                }
            }
        });
        btwSearchSWModel.setText("Search");
        Label label3 = new Label(parent, 0);
        label3.setText("Path to Hardware Model");
        this.textHWModelFile = new Text(parent, 2048);
        this.textHWModelFile.setLayoutData((Object)gridData);
        Button btwSearchHWModel = new Button(parent, 0);
        btwSearchHWModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = parent.getShell();
                String selection = PerformMappingGUI.this.openFileDialog(shell, "Select Hardware Model", "*.amxmi; *.amxmi-hw", PerformMappingGUI.this.workingDirectory);
                if (selection != null) {
                    PerformMappingGUI.this.textHWModelFile.setText(selection);
                }
            }
        });
        btwSearchHWModel.setText("Search");
        return parent;
    }

    String openFileDialog(Shell shell, String text, String extension, String filterPath) {
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setText(text);
        fileDialog.setFilterExtensions(new String[]{extension});
        fileDialog.setFilterNames(new String[]{"(" + extension + ")"});
        fileDialog.setFilterPath(filterPath);
        try {
            String selected = fileDialog.open();
            return selected;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        parent.setLayoutData((Object)gridData);
        this.createButton(parent, 0, "Create Mapping", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    boolean isValidInput() {
        boolean valid = true;
        if (this.textProjectName.getText().length() == 0) {
            this.setErrorMessage("Please enter a valid Project Name.");
            valid = false;
        }
        if (this.textSWModelFile.getText().length() == 0) {
            this.setErrorMessage("Please select a valid SW Model.");
            valid = false;
        }
        if (this.textHWModelFile.getText().length() == 0) {
            this.setErrorMessage("Please select a valid HW Model.");
            valid = false;
        }
        return valid;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.setNameOfCompilation(this.textProjectName.getText());
        this.setPathToSWModel(this.textSWModelFile.getText());
        this.setPathToHWModel(this.textHWModelFile.getText());
    }

    protected void okPressed() {
        if (this.isValidInput()) {
            this.saveInput();
            super.okPressed();
        }
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getNameOfCompilation() {
        return this.nameOfCompilation;
    }

    public void setNameOfCompilation(String nameOfCompilation) {
        this.nameOfCompilation = nameOfCompilation;
    }

    public String getPathToSWModel() {
        return this.pathToSWModel;
    }

    public void setPathToSWModel(String pathToSWModel) {
        this.pathToSWModel = pathToSWModel;
    }

    public String getPathToHWModel() {
        return this.pathToHWModel;
    }

    public void setPathToHWModel(String pathToHWModel) {
        this.pathToHWModel = pathToHWModel;
    }

    public void setProjectName(String projectName) {
        this.initName = projectName;
    }

    public void setInitSWModel(String pathToSWModel) {
        this.initSWModel = pathToSWModel;
    }
}

