/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.handlers;

import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractILPBasedMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ga.lb.GABasedLoadBalancing;
import org.eclipse.app4mc.multicore.openmapping.algorithms.heuristic.lb.LoadBalancingDFG;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.EnergyMinimization;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.lb.ILPBasedLoadBalancing;
import org.eclipse.app4mc.multicore.openmapping.handlers.PerformMappingGUI;
import org.eclipse.app4mc.multicore.openmapping.handlers.PerformMappingJob;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class PerformMappingHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        URI path;
        String outputLocation;
        AbstractMappingAlgorithm mappingAlgorithm;
        String sOutputDirectory;
        int radioOutputDirectory;
        IPreferenceStore store;
        String pathHWModel;
        String pathSWModel;
        String projectName;
        IFile file;
        block19: {
            UniversalHandler.getInstance().setPluginId(OpenMappingPlugin.getPluginId());
            UniversalHandler.getInstance().setLog(OpenMappingPlugin.getDefault().getLog());
            file = UniversalHandler.getInstance().getSelectedFile(event);
            URI projectFolder = UniversalHandler.getInstance().getProjectDir(event);
            projectName = "";
            pathSWModel = "";
            pathHWModel = "";
            store = OpenMappingPlugin.getDefault().getPreferenceStore();
            if (store.getBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole")) {
                UniversalHandler.getInstance().enableVerboseOutput();
            }
            radioOutputDirectory = store.getInt("org.eclipse.app4mc.multicore.openmapping.outputLocation");
            sOutputDirectory = store.getString("org.eclipse.app4mc.multicore.openmapping.outputLocationString");
            int radioAlgorithmChoice = store.getInt("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm");
            switch (radioAlgorithmChoice) {
                case 0: {
                    mappingAlgorithm = new LoadBalancingDFG();
                    break;
                }
                case 1: {
                    mappingAlgorithm = new ILPBasedLoadBalancing();
                    break;
                }
                case 2: {
                    mappingAlgorithm = new EnergyMinimization();
                    break;
                }
                case 3: {
                    mappingAlgorithm = new GABasedLoadBalancing();
                    break;
                }
                default: {
                    return null;
                }
            }
            UniversalHandler.getInstance().dropCache();
            try {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                PerformMappingGUI dialog = new PerformMappingGUI(window.getShell());
                String f = file.getName();
                dialog.setProjectName(f.substring(0, f.lastIndexOf(46)));
                dialog.setInitSWModel(file.getRawLocation().toOSString());
                dialog.setWorkingDirectory(projectFolder.devicePath());
                dialog.create();
                if (dialog.open() == 0) {
                    projectName = dialog.getNameOfCompilation();
                    pathSWModel = dialog.getPathToSWModel();
                    pathHWModel = dialog.getPathToHWModel();
                    break block19;
                }
                return null;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (radioOutputDirectory == 0 || sOutputDirectory == null || sOutputDirectory.isEmpty()) {
            outputLocation = String.valueOf(file.getProject().getFullPath().toString()) + "/output/";
            path = URI.createPlatformResourceURI((String)(String.valueOf(outputLocation) + projectName + "_out.amxmi"), (boolean)true);
        } else if (radioOutputDirectory == 1) {
            outputLocation = String.valueOf(file.getProject().getFullPath().toString()) + "/" + sOutputDirectory;
            path = URI.createPlatformResourceURI((String)(String.valueOf(outputLocation) + "/" + projectName + "_out.amxmi"), (boolean)true);
        } else {
            path = URI.createPlatformResourceURI((String)(String.valueOf(sOutputDirectory) + "/" + projectName + "_out.amxmi"), (boolean)true);
        }
        if (mappingAlgorithm instanceof AbstractILPBasedMappingAlgorithm) {
            int iMaxTimeSuffice;
            int iMaxItSuffice;
            int iMaxTimeAbort;
            int iMaxItAbort = store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxItAbort");
            if (iMaxItAbort == 0) {
                iMaxItAbort = Integer.MAX_VALUE;
            }
            if ((iMaxTimeAbort = store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxTimeAbort")) == 0) {
                iMaxTimeAbort = Integer.MAX_VALUE;
            }
            if ((iMaxItSuffice = store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxItSuffice")) == 0) {
                iMaxItSuffice = Integer.MAX_VALUE;
            }
            if ((iMaxTimeSuffice = store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxTimeSuffice")) == 0) {
                iMaxTimeSuffice = Integer.MAX_VALUE;
            }
            double fMaxGap = store.getDouble("org.eclipse.app4mc.multicore.openmapping.MaxGap");
            ((AbstractILPBasedMappingAlgorithm)mappingAlgorithm).setMaxGap(fMaxGap);
            ((AbstractILPBasedMappingAlgorithm)mappingAlgorithm).setMaxIterationsAbort(iMaxItAbort);
            ((AbstractILPBasedMappingAlgorithm)mappingAlgorithm).setMaxTimeAbort(iMaxTimeAbort);
            ((AbstractILPBasedMappingAlgorithm)mappingAlgorithm).setMaxIterationsSuffice(iMaxItSuffice);
            ((AbstractILPBasedMappingAlgorithm)mappingAlgorithm).setMaxTimeSuffice(iMaxTimeSuffice);
        }
        PerformMappingJob job = new PerformMappingJob(mappingAlgorithm, URI.createFileURI((String)pathSWModel), null, URI.createFileURI((String)pathHWModel), path);
        job.schedule();
        return null;
    }
}

