/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.handlers;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class PerformMappingJob
extends Job {
    private final AbstractMappingAlgorithm mappingAlgorithm;
    private final URI pathSwModel;
    private final URI pathHwModel;
    private final URI path;
    private SWModel swModel;
    private PropertyConstraintsModel pcModel;
    private HWModel hwModel;
    private OSModel osModel;
    private MappingModel mmModel;
    private ConstraintsModel conModel;

    public PerformMappingJob(AbstractMappingAlgorithm mappingAlgorithm, URI pathSwModel, URI pathPcModel, URI pathHwModel, URI path) {
        super("ILP Job");
        this.mappingAlgorithm = mappingAlgorithm;
        this.pathSwModel = pathSwModel;
        this.pathHwModel = pathHwModel;
        this.path = path;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Performing mapping...", 3);
        monitor.subTask("Reading models");
        if (!this.readModels()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        monitor.subTask("Solving ILP model");
        if (!this.solve()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        monitor.subTask("Writing models");
        if (!this.writeModels()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean readModels() {
        UniversalHandler.getInstance().readModels(this.pathSwModel, true);
        this.swModel = UniversalHandler.getInstance().getSwModel();
        if (this.swModel == null) {
            UniversalHandler.getInstance().logCon("There seems to be no software model in the specified file.\nExiting...");
            return false;
        }
        this.conModel = UniversalHandler.getInstance().getConstraintsModel();
        if (this.conModel == null) {
            UniversalHandler.getInstance().logCon("There seems to be no software model in the specified file.\nExiting...");
            return false;
        }
        this.pcModel = UniversalHandler.getInstance().getPropertyConstraintsModel();
        if (this.pcModel != null) {
            this.mappingAlgorithm.setPropertyConstraintsModel(this.pcModel);
            UniversalHandler.getInstance().logCon("PropertyConstraints Model set.");
        }
        UniversalHandler.getInstance().readModels(this.pathHwModel, true);
        this.hwModel = UniversalHandler.getInstance().getHwModel();
        if (this.hwModel == null) {
            UniversalHandler.getInstance().logCon("There seems to be no hardware model in the specified file.\nExiting...");
            return false;
        }
        this.mappingAlgorithm.setSwModel(this.swModel);
        this.mappingAlgorithm.setHwModel(this.hwModel);
        this.mappingAlgorithm.setConnstraintsModel(this.conModel);
        return true;
    }

    private boolean solve() {
        this.mappingAlgorithm.calculateMapping();
        return true;
    }

    private boolean writeModels() {
        this.osModel = this.mappingAlgorithm.getOsModel();
        if (this.osModel == null) {
            UniversalHandler.getInstance().logCon("An error occured during the OSModel creation process");
            UniversalHandler.getInstance().logCon("Check the error logs for further details");
            return false;
        }
        this.mmModel = this.mappingAlgorithm.getMappingModel();
        if (this.mmModel == null) {
            UniversalHandler.getInstance().logCon("An error occured during the mapping creation process");
            UniversalHandler.getInstance().logCon("Check the error logs for further details");
            return false;
        }
        Amalthea cen = AmaltheaFactory.eINSTANCE.createAmalthea();
        cen.setCommonElements(UniversalHandler.getInstance().getCommonElements());
        cen.setSwModel(UniversalHandler.getInstance().getSwModel());
        cen.setHwModel(UniversalHandler.getInstance().getHwModel());
        cen.setConstraintsModel(UniversalHandler.getInstance().getConstraintsModel());
        cen.setStimuliModel(UniversalHandler.getInstance().getStimuliModel());
        cen.setMappingModel(this.mmModel);
        cen.setOsModel(this.osModel);
        UniversalHandler.getInstance().writeModel(this.path, (EObject)cen);
        return true;
    }
}

